/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.toolbaritem;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungMessageNotifier;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungMessageNotifierListener;
import de.cismet.cids.custom.wunda_blau.search.actions.BerechtigungspruefungFreigabeServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsClientToolbarItem;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BerechtigungspruefungToolbarWidget
extends JPanel
implements CidsClientToolbarItem,
ConnectionContextStore,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(BerechtigungspruefungToolbarWidget.class);
    private static final String TEXT_TEMPLATE = "%s offene Berechtigungspr\u00fcfungs-Anfragen";
    private static final String TEXT_TEMPLATE_NONE = "keine offene Berechtigungspr\u00fcfungs-Anfragen";
    private static final String TEXT_TEMPLATE_ONE = "Eine offene Berechtigungspr\u00fcfungs-Anfrage";
    private static final ImageIcon ICON_PENDING = new ImageIcon(BerechtigungspruefungToolbarWidget.class.getResource("/de/cismet/cids/custom/wunda_blau/toolbaritem/exclamation-red-icon.png"));
    private static final ImageIcon ICON_DONE = new ImageIcon(BerechtigungspruefungToolbarWidget.class.getResource("/de/cismet/cids/custom/wunda_blau/toolbaritem/tick-circle-icon.png"));
    private final BerechtigungspruefungMessageNotifierListener notifierListener = new MessageListener();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton jButton1;
    private JLabel jLabel1;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        if (this.isVisible()) {
            this.initComponents();
            this.updateAnfragen();
            BerechtigungspruefungMessageNotifier.getInstance().addListener(this.notifierListener);
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.setMaximumSize(new Dimension(333, 31));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(333, 31));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)TEXT_TEMPLATE_NONE);
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setHorizontalAlignment(2);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BerechtigungspruefungToolbarWidget.this.jButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel1.setIcon(ICON_DONE);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BerechtigungspruefungToolbarWidget.class, (String)"BerechtigungspruefungToolbarWidget.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        new SwingWorker<BerechtigungspruefungFreigabeServerAction.ReturnType, Void>(){

            @Override
            protected BerechtigungspruefungFreigabeServerAction.ReturnType doInBackground() throws Exception {
                try {
                    return (BerechtigungspruefungFreigabeServerAction.ReturnType)SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "berechtigungspruefungFreigabe", SessionManager.getSession().getUser().getDomain(), (Object)BerechtigungspruefungMessageNotifier.getInstance().getAeltesteOffeneAnfrage(BerechtigungspruefungToolbarWidget.this.getConnectionContext()), BerechtigungspruefungToolbarWidget.this.getConnectionContext(), new ServerActionParameter[]{new ServerActionParameter(BerechtigungspruefungFreigabeServerAction.ParameterType.MODUS.toString(), (Object)"PRUEFUNG")});
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    BerechtigungspruefungFreigabeServerAction.ReturnType ret = (BerechtigungspruefungFreigabeServerAction.ReturnType)this.get();
                    if (ret.equals((Object)BerechtigungspruefungFreigabeServerAction.ReturnType.OK)) {
                        BerechtigungspruefungToolbarWidget.this.gotoPruefung(BerechtigungspruefungMessageNotifier.getInstance().getAeltesteOffeneAnfrage(BerechtigungspruefungToolbarWidget.this.getConnectionContext()));
                    } else {
                        String title = "Fehler beim Sperren.";
                        String message = "<html>Die Berechtigungs-Anfrage wird bereits von einem anderen Pr\u00fcfer bearbeitet.";
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)ComponentRegistry.getRegistry().getMainWindow()), "<html>Die Berechtigungs-Anfrage wird bereits von einem anderen Pr\u00fcfer bearbeitet.", "Fehler beim Sperren.", 0);
                    }
                }
                catch (Exception ex) {
                    String title = "Fehler beim Sperren.";
                    String message = "Beim Sperren ist es zu unerwartetem einem Fehler gekommen.";
                    ErrorInfo info = new ErrorInfo("Fehler beim Sperren.", "Beim Sperren ist es zu unerwartetem einem Fehler gekommen.", null, null, (Throwable)ex, Level.SEVERE, null);
                    JXErrorPane.showDialog((Component)ComponentRegistry.getRegistry().getMainWindow(), (ErrorInfo)info);
                    LOG.error((Object)"Fehler beim Freigeben", (Throwable)ex);
                }
            }
        }.execute();
    }

    public String getSorterString() {
        return "XXX";
    }

    @Override
    public final boolean isVisible() {
        return !BerechtigungspruefungMessageNotifier.getInstance().getProdukttypeList().isEmpty();
    }

    private void gotoPruefung(final String schluessel) {
        ComponentRegistry.getRegistry().showComponent(ComponentRegistry.DESCRIPTION_PANE);
        ComponentRegistry.getRegistry().getDescriptionPane().showWaitScreen();
        new SwingWorker<MetaObjectNode, Object>(){

            @Override
            protected MetaObjectNode doInBackground() throws Exception {
                MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)BerechtigungspruefungToolbarWidget.this.getConnectionContext());
                String pruefungQuery = "SELECT DISTINCT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE " + mcBerechtigungspruefung.getTableName() + ".schluessel LIKE '" + schluessel + "' LIMIT 1;";
                MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(pruefungQuery, 0, BerechtigungspruefungToolbarWidget.this.getConnectionContext());
                CidsBean cidsBean = mos[0].getBean();
                return new MetaObjectNode(cidsBean);
            }

            @Override
            protected void done() {
                try {
                    MetaObjectNode mon = (MetaObjectNode)this.get();
                    ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObjectNode(mon);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }.execute();
    }

    private void updateAnfragen() {
        boolean pending;
        ImageIcon icon;
        String name;
        int anzahlAnfragen;
        try {
            anzahlAnfragen = BerechtigungspruefungMessageNotifier.getInstance().getOffeneAnfragen(this.getConnectionContext()).size();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler bei der Abfrage der offenen Anfragen", (Throwable)ex);
            anzahlAnfragen = -1;
        }
        switch (anzahlAnfragen) {
            case 0: {
                name = TEXT_TEMPLATE_NONE;
                icon = ICON_DONE;
                pending = false;
                break;
            }
            case 1: {
                name = TEXT_TEMPLATE_ONE;
                icon = ICON_PENDING;
                pending = true;
                break;
            }
            default: {
                name = String.format(TEXT_TEMPLATE, String.valueOf(anzahlAnfragen));
                icon = ICON_PENDING;
                pending = true;
            }
        }
        this.jButton1.setEnabled(pending);
        this.jButton1.setText(name);
        this.jLabel1.setToolTipText(name);
        this.jLabel1.setIcon(icon);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "BerechtigungspruefungToolbarWidget";
        }
        return null;
    }

    public Component getComponent() {
        return this;
    }

    private class MessageListener
    implements BerechtigungspruefungMessageNotifierListener {
        private MessageListener() {
        }

        @Override
        public void anfrageAdded(String key) {
            BerechtigungspruefungToolbarWidget.this.updateAnfragen();
        }

        @Override
        public void anfrageRemoved(String key) {
            BerechtigungspruefungToolbarWidget.this.updateAnfragen();
        }
    }
}

