/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wupp.client.alkis;

import de.cismet.cids.custom.wupp.client.alkis.AbstractInputFieldConfig;
import de.cismet.cids.custom.wupp.client.alkis.ParcelInputField;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractInputField
extends JPanel {
    public static final String PROP_DISTRICT_NAME = "districtName";
    public static final String PROP_DISTRICT_NUMBER = "districtNumber";
    private static final Logger LOG = Logger.getLogger(AbstractInputField.class);
    boolean changeFocus = true;
    boolean writeOver = true;
    private String districtNumber;
    private String districtName;
    private boolean validParcelNr = false;
    private final AbstractInputFieldConfig config;
    private boolean overwritten = false;
    private JTextField txtDistrict;

    public AbstractInputField(AbstractInputFieldConfig config) {
        this.config = config;
    }

    public AbstractInputFieldConfig getConfig() {
        return this.config;
    }

    public boolean getValidParcelNr() {
        return this.validParcelNr;
    }

    abstract void updateResult();

    public String getDistrictName() {
        return this.districtName;
    }

    public String getDistrictNumber() {
        return this.districtNumber;
    }

    public void setDistrictNumber(String districtNumber) {
        this.districtNumber = districtNumber;
    }

    public void setDistrictNumberInTxtDistrict(String districtNumber) {
        this.changeFocus = false;
        this.writeOver = false;
        this.txtDistrict.setText(districtNumber);
        this.changeFocus = true;
        this.writeOver = true;
        this.finishDistrict();
    }

    void addLeadingZeroes(Document document, int maxLen, int offs) {
        if (document.getLength() < maxLen) {
            for (int i = document.getLength(); i < maxLen; ++i) {
                try {
                    document.insertString(offs, "0", null);
                    continue;
                }
                catch (BadLocationException ex) {
                    Logger.getLogger((String)ParcelInputField.class.getName()).log((Priority)Level.INFO, (Object)"Leading zero could not be inserted", (Throwable)ex);
                }
            }
        }
    }

    void addLeadingZeroes(Document document, int maxLen) {
        this.addLeadingZeroes(document, maxLen, 0);
    }

    Integer getDistrictNrFromAbrv(String districtAbrv) {
        char abbreviationLength = districtAbrv.charAt(0);
        return this.config.getConversionMap().get(districtAbrv.substring(0, Math.min(abbreviationLength, districtAbrv.length())).toLowerCase());
    }

    boolean validDistrict(String districtAbrv) {
        return this.getDistrictNrFromAbrv(districtAbrv) != null;
    }

    public JTextField getTxtDistrict() {
        return this.txtDistrict;
    }

    public void setTxtDistrict(JTextField txtDistrict) {
        this.txtDistrict = txtDistrict;
    }

    void finishDistrict() {
        String text = this.txtDistrict.getText();
        if (text.matches("^[\u00f6\u00d6\u00fc\u00dc\u00e4\u00c4\u00dfa-zA-Z]+$")) {
            if (this.validDistrict(text)) {
                this.txtDistrict.setText(this.getDistrictNrFromAbrv(text).toString());
                text = this.txtDistrict.getText();
            } else {
                this.txtDistrict.setForeground(Color.red);
            }
        }
        if (text.matches("^[0-9]+$") || text.isEmpty()) {
            if (!text.matches("^05.*")) {
                this.txtDistrict.setText("05" + text);
            }
            this.addLeadingZeroes(this.txtDistrict.getDocument(), this.config.getMaxLenDistrictNumberField() + 2, 2);
        }
        String oldAreaName = this.districtName;
        try {
            int intArea = this.txtDistrict.getText().length() > this.config.getMaxLenDistrictNumberField() ? Integer.parseInt(this.txtDistrict.getText().substring(2)) : Integer.parseInt(this.txtDistrict.getText().substring(0));
            this.districtName = this.config.getDistrictNamesMap().get(intArea);
        }
        catch (NumberFormatException e) {
            this.districtName = null;
        }
        this.firePropertyChange(PROP_DISTRICT_NAME, oldAreaName, this.getDistrictName());
        if (this.getDistrictName() != null) {
            this.fireAreaBlockFinished(BlockType.DISTRICT);
        }
    }

    abstract void fireAreaBlockFinished(BlockType var1);

    public boolean isOverwritten() {
        return this.overwritten;
    }

    public void setOverwritten(boolean overwritten) {
        this.overwritten = overwritten;
    }

    public int getAbbreviationLength(Character abreviationStart) {
        abreviationStart = Character.valueOf(Character.toLowerCase(abreviationStart.charValue()));
        if (this.config.getAlternativeAbbreviationLength().containsKey(abreviationStart)) {
            return this.config.getAlternativeAbbreviationLength().get(abreviationStart);
        }
        return this.config.getDefaultAbbreviationLength();
    }

    public class DistrictPlainDocument
    extends PlainDocument {
        private JTextField textField;
        private JTextField nextTextField;

        public DistrictPlainDocument(JTextField textField, JTextField nextTextField) {
            this.textField = textField;
            this.nextTextField = nextTextField;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            this.textField.setForeground(Color.BLACK);
            if (str == null) {
                return;
            }
            String newStr = str = str.replaceAll("[^-\\u00F6\\u00D6\\u00FC\\u00DC\\u00E4\\u00C4\\u00dfa-zA-Z0-9_%]", "");
            int maxLen = AbstractInputField.this.config.getMaxLenDistrictNumberField();
            if ((this.textField.getDocument().getText(0, this.textField.getDocument().getLength()) + str).matches("^05.*")) {
                maxLen += 2;
            }
            if (str.length() > 0 && (str.length() > maxLen - offs || str.substring(0, Math.min(maxLen + 1 - offs, str.length())).contains(AbstractInputField.this.config.getDelimiter1AsString()))) {
                String writeOverStr;
                int pos = maxLen - offs;
                int posDel = str.indexOf(AbstractInputField.this.config.getDelimiter1());
                if (posDel >= 0 && posDel < pos) {
                    pos = posDel;
                }
                while (str.indexOf(95) >= 0 && str.indexOf(95) < pos || str.indexOf(37) >= 0 && str.indexOf(37) < pos) {
                    posDel = (str = str.replaceFirst("[_%]", "")).indexOf(AbstractInputField.this.config.getDelimiter1());
                    if (posDel < 0 || posDel >= pos) continue;
                    pos = posDel;
                }
                if (AbstractInputField.this.changeFocus) {
                    this.nextTextField.requestFocusInWindow();
                }
                newStr = str.substring(0, pos);
                if (AbstractInputField.this.writeOver && !(writeOverStr = str.indexOf(AbstractInputField.this.config.getDelimiter1()) == pos ? str.substring(pos + 1) : str.substring(pos)).isEmpty()) {
                    AbstractInputField.this.overwritten = true;
                    this.nextTextField.setText(writeOverStr);
                }
            } else {
                newStr = newStr.replaceFirst("[_%]", "");
            }
            if (!newStr.isEmpty()) {
                if (this.textField.getDocument().getLength() == 0) {
                    if (Character.isDigit(newStr.charAt(0))) {
                        newStr = newStr.replaceAll("[^0-9]", "");
                    } else if (Character.isLetter(newStr.charAt(0))) {
                        newStr = newStr.replaceAll("[^\\u00F6\\u00D6\\u00FC\\u00DC\\u00E4\\u00C4\\u00dfa-zA-Z]", "");
                        int abbreviationLength = AbstractInputField.this.getAbbreviationLength(Character.valueOf(newStr.charAt(0)));
                        newStr = newStr.substring(0, Math.min(Math.max(abbreviationLength - offs, 0), newStr.length()));
                        String districtAbreviation = this.textField.getDocument().getText(0, this.textField.getDocument().getLength()) + newStr;
                        if (AbstractInputField.this.validDistrict(districtAbreviation)) {
                            if (AbstractInputField.this.changeFocus && offs + newStr.length() >= abbreviationLength) {
                                this.nextTextField.requestFocusInWindow();
                            }
                        } else {
                            this.textField.setForeground(Color.red);
                        }
                    }
                } else if (this.textField.getDocument().getText(0, this.textField.getDocument().getLength()).matches("^[0-9]*")) {
                    newStr = newStr.replaceAll("[^0-9]", "");
                } else if (this.textField.getDocument().getText(0, this.textField.getDocument().getLength()).matches("^[\\u00F6\\u00D6\\u00FC\\u00DC\\u00E4\\u00C4\\u00dfa-zA-Z]*")) {
                    newStr = newStr.replaceAll("[^\\u00F6\\u00D6\\u00FC\\u00DC\\u00E4\\u00C4\\u00dfa-zA-Z]", "");
                    Character abbrevStart = Character.valueOf(this.textField.getDocument().getText(0, this.textField.getDocument().getLength()).charAt(0));
                    int abbreviationLength = AbstractInputField.this.getAbbreviationLength(abbrevStart);
                    newStr = newStr.substring(0, Math.min(Math.max(abbreviationLength - offs, 0), newStr.length()));
                    if (AbstractInputField.this.validDistrict(this.textField.getDocument().getText(0, this.textField.getDocument().getLength()) + newStr)) {
                        if (AbstractInputField.this.changeFocus && offs + newStr.length() >= abbreviationLength) {
                            this.nextTextField.requestFocusInWindow();
                        }
                    } else {
                        this.textField.setForeground(Color.red);
                    }
                }
            }
            super.insertString(offs, newStr, a);
            AbstractInputField.this.updateResult();
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.textField.setForeground(Color.BLACK);
            super.remove(offs, len);
        }
    }

    public static enum BlockType {
        DISTRICT,
        PARCEL,
        PARCEL_NUMERATOR,
        PARCEL_DENOMINATOR,
        BUCHUNGSBLATTNUMMER;

    }
}

