/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.wunda_blau.search.server.BaumChildLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BaumGebietDeletionProvider
extends AbstractCustomDeletionProvider
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BaumGebietDeletionProvider.class);
    private static final String TABLE_NAME = "baum_gebiet";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_gebiet";
    private static final String TABLE_NAME_SEARCH = "baum_meldung";
    private static final String DELETE_TEXT = "Dieses Gebiet kann nicht gel\u00f6scht werden, da dieses mindestens eine Meldung hat.";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean gebietBean = metaObject.getBean();
        Integer gebiet_id = (Integer)gebietBean.getProperty(FIELD__ID);
        return this.checkChildObject(FIELD__FK, gebiet_id, TABLE_NAME_SEARCH, user);
    }

    public boolean checkChildObject(String fkField, int parentId, String searchTable, User user) {
        String[] childFields = new String[]{FIELD__ID};
        BaumChildLightweightSearch search = new BaumChildLightweightSearch();
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("WUNDA_BLAU", this.getMetaService());
        search.setActiveLocalServers(localServers);
        search.setUser(user);
        search.initWithConnectionContext(this.connectionContext);
        search.setFkField(fkField);
        search.setParentId(parentId);
        search.setTable(searchTable);
        search.setRepresentationFields(childFields);
        try {
            Collection mons = search.performServerSearch();
            if (!mons.isEmpty()) {
                return true;
            }
        }
        catch (SearchException ex) {
            LOG.error((Object)"Cannot delete Gebiet object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(DELETE_TEXT);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

