/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import org.apache.log4j.Logger;

public class StrAdrStrasseDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(StrAdrStrasseDeletionProvider.class);
    public static final String TABLE_NAME = "str_adr_strasse";
    public static final String FIELD__KEY = "schluessel.name";
    private static final String AMTL_STR_GRENZE = "04000";
    private static final String DELETE_KLEINER = "Diese Stra\u00dfe darf nicht gel\u00f6scht werden, sie muss historisiert werden.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean strBean = metaObject.getBean();
        return strBean.getProperty(FIELD__KEY).toString().compareTo(AMTL_STR_GRENZE) <= 0;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        CidsBean strBean;
        String strasse;
        if (metaObject != null && (strasse = (strBean = metaObject.getBean()).getProperty(FIELD__KEY).toString()).compareTo(AMTL_STR_GRENZE) < 0) {
            throw new DeletionProviderClientException(DELETE_KLEINER);
        }
        return false;
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

