/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UaBereitschaftDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(UaBereitschaftDeletionProvider.class);
    private static final String TABLE_NAME = "ua_bereitschaft";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_bereitschaft";
    private static final String TABLE_NAME_SEARCH = "ua_einsatz";
    private static final String CAUSE = "Diese Person kann nicht gel\u00f6scht werden, da diese bei mindestens einem Einsatz verwendet wird.";
    private String deleteText = "Diese Person kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean bereitBean = metaObject.getBean();
        Integer bereit_id = bereitBean.getPrimaryKeyValue();
        String queryBereitIn = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, bereit_id);
        try {
            ArrayList bereitArray = this.getMetaService().performCustomSearch(queryBereitIn, this.getConnectionContext());
            if (!bereitArray.isEmpty()) {
                this.deleteText = CAUSE;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Bereitschaft object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

