/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UaGewaesserDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(UaGewaesserDeletionProvider.class);
    private static final String TABLE_NAME = "ua_gewaesser";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_gewaesser";
    private static final String TABLE_NAME_SEARCH = "ua_einsatz";
    private static final String CAUSE = "Dieses Gew\u00e4sser kann nicht gel\u00f6scht werden, da dieses bei mindestens einem Einsatz verwendet wird.";
    private String deleteText = "Dieses Gew\u00e4sser kann nicht gel\u00f6scht werden, da dieses verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean gewaesserBean = metaObject.getBean();
        Integer gewaesser_id = gewaesserBean.getPrimaryKeyValue();
        String queryGewIn = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, gewaesser_id);
        try {
            ArrayList gewArray = this.getMetaService().performCustomSearch(queryGewIn, this.getConnectionContext());
            if (!gewArray.isEmpty()) {
                this.deleteText = CAUSE;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Gewaesser object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

