/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.utils.datasource.DatasourcesPojoConverter;
import de.cismet.commons.utils.datasource.DatasourcesUtils;
import de.cismet.commons.utils.datasource.HtmlConverter;
import de.cismet.commons.utils.datasource.HtmlDetailConverter;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import sun.misc.BASE64Encoder;

public class DatasourceExtractor {
    private static final Logger LOG = Logger.getLogger(DatasourceExtractor.class);

    public static void extractDatasources() throws Exception {
        String[] credentialArray = null;
        Element rootObject = null;
        File file = null;
        File file2 = null;
        try {
            StringReader capabilityList = ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.DATASOURCES_CAPABILITYLIST_TEXT.getValue());
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build((Reader)capabilityList);
            rootObject = doc.getRootElement();
        }
        catch (Exception ex) {
            LOG.error((Object)"Datasource could not load the capabilities list", (Throwable)ex);
        }
        try {
            Properties credentials = ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.DATASOURCES_CREDENTIALS_PROPERTIES.getValue());
            BASE64Encoder base64 = new BASE64Encoder();
            ArrayList<String> credentialList = new ArrayList<String>();
            if (credentials.stringPropertyNames() != null && credentials.stringPropertyNames().size() > 0) {
                for (String key : credentials.stringPropertyNames()) {
                    String credential = key + ":" + credentials.getProperty(key);
                    credentialList.add(base64.encode(credential.getBytes()));
                }
                credentialArray = credentialList.toArray(new String[credentials.stringPropertyNames().size()]);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Datasource could not load the credential properties", (Throwable)ex);
        }
        try {
            Properties general = ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.DATASOURCES_GENERAL_PROPERTIES.getValue());
            String filename = general.getProperty("output_file");
            if (filename != null) {
                file = new File(filename);
                if (filename.contains(".")) {
                    file2 = new File(filename.substring(0, filename.lastIndexOf(".")) + "_neu.html");
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Datasource could not load the general properties", (Throwable)ex);
        }
        if (rootObject != null && file != null) {
            HtmlConverter converter = new HtmlConverter();
            DatasourcesUtils.createLayerListHeadless((Element)rootObject, (Element)rootObject, credentialArray, (DatasourcesPojoConverter)converter, (File)file);
            if (file2 != null) {
                converter = new HtmlDetailConverter();
                DatasourcesUtils.createLayerListHeadless((Element)rootObject, (Element)rootObject, (String[])credentialArray, (DatasourcesPojoConverter)converter, file2);
            }
        }
    }
}

