/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.utils.serverresources.DefaultServerResourcePropertiesHandler;
import org.apache.log4j.Logger;

public class PotenzialflaechenProperties
extends DefaultServerResourcePropertiesHandler {
    private static final Logger LOG = Logger.getLogger(PotenzialflaechenProperties.class);
    private static final String PROP__FILE_CACHE_DIRECTORY = "fileCacheDirectory";
    private static final String PROP__REPORTS_DIR = "reportsDirectory";
    private static final String PROP__MAP_FACTORY = "mapFactory";
    private static final String PROP__WEBDAV_URL = "webdavUrl";
    private static final String PROP__WEBDAV_USER = "webdavUser";
    private static final String PROP__WEBDAV_PASSWORD = "webdavPassword";
    private static final String PROP__SECRES_KEY = "secresKey";
    private static final String PROP__SECRES_API = "secresApi";
    private static final String PROP__PDFMERGE_CMD_TMEPLATE = "pdfmergeCmdTemplate";
    private static final String DEFAULT__PDFMERGE_CMD_TEMPLATE = "pdfunite {PDF_INPUT_FILELIST} {PDF_OUTPUT_FILE}";
    private static final String DEFAULT__MAP_FACTORY = "de.cismet.cids.custom.reports.wunda_blau.PfMapFactory";
    private static final String DEFAULT__SRS = "EPSG:25832";
    private static final double DEFAULT__HOME_X1 = 6.7;
    private static final double DEFAULT__HOME_Y1 = 49.1;
    private static final double DEFAULT__HOME_X2 = 7.1;
    private static final double DEFAULT__HOME_Y2 = 49.33;
    private static final String DEFAULT__SECRES_KEY = "potenzialflaecheReport";
    private static final String DEFAULT__SECRES_API = "http://belis-api.cismet.de";
    private static final String DEFAULT__REPORTS_DIR = "/tmp";

    public String getReportFile(String name) {
        try {
            return this.getProperties().getProperty(String.format("report_%s", name));
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("property for report_%s not found", name), (Throwable)ex);
            return null;
        }
    }

    public String getPictureCacheDirectory() {
        return this.getProperties().getProperty(PROP__FILE_CACHE_DIRECTORY, null);
    }

    public Double getHomeX1() {
        String homeX1 = this.getProperties().getProperty("homeX1");
        try {
            return homeX1 != null ? Double.parseDouble(homeX1) : 6.7;
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("error parsing '%s', returning %f as default homeX1", homeX1, 6.7), (Throwable)ex);
            return 6.7;
        }
    }

    public Double getHomeY1() {
        String homeY1 = this.getProperties().getProperty("homeY1");
        try {
            return homeY1 != null ? Double.parseDouble(homeY1) : 49.1;
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("error parsing '%s', returning %f as default homeY1", homeY1, 49.1), (Throwable)ex);
            return 49.1;
        }
    }

    public Double getHomeX2() {
        String homeX2 = this.getProperties().getProperty("homeX2");
        try {
            return homeX2 != null ? Double.parseDouble(homeX2) : 7.1;
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("error parsing '%s', returning %f as default homeX2", homeX2, 7.1), (Throwable)ex);
            return 7.1;
        }
    }

    public Double getHomeY2() {
        String homeY2 = this.getProperties().getProperty("homeY2");
        try {
            return homeY2 != null ? Double.parseDouble(homeY2) : 49.33;
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("error parsing '%s', returning %f as default homeY2", homeY2, 49.33), (Throwable)ex);
            return 49.33;
        }
    }

    public String getSrs() {
        try {
            return this.getProperties().getProperty("Srs", DEFAULT__SRS);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("returning %s as default SRS", DEFAULT__SRS), (Throwable)ex);
            return DEFAULT__SRS;
        }
    }

    public String getMapFactory() {
        try {
            return this.getProperties().getProperty(PROP__MAP_FACTORY, DEFAULT__MAP_FACTORY);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__MAP_FACTORY), (Throwable)ex);
            return null;
        }
    }

    public String getSecresKey() {
        try {
            return this.getProperties().getProperty(PROP__SECRES_KEY, DEFAULT__SECRES_KEY);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__SECRES_KEY), (Throwable)ex);
            return DEFAULT__SECRES_KEY;
        }
    }

    public String getSecresApi() {
        try {
            return this.getProperties().getProperty(PROP__SECRES_API, DEFAULT__SECRES_API);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__SECRES_API), (Throwable)ex);
            return DEFAULT__SECRES_API;
        }
    }

    public String getWebdavUrl() {
        try {
            return this.getProperties().getProperty(PROP__WEBDAV_URL, null);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__WEBDAV_URL), (Throwable)ex);
            return null;
        }
    }

    public String getWebdavUser() {
        try {
            return this.getProperties().getProperty(PROP__WEBDAV_USER, null);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__WEBDAV_USER), (Throwable)ex);
            return null;
        }
    }

    public String getWebdavPassword() {
        try {
            return this.getProperties().getProperty(PROP__WEBDAV_PASSWORD, null);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__WEBDAV_PASSWORD), (Throwable)ex);
            return null;
        }
    }

    public String getReportsDirectory() {
        try {
            return this.getProperties().getProperty(PROP__REPORTS_DIR, DEFAULT__REPORTS_DIR);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__REPORTS_DIR), (Throwable)ex);
            return DEFAULT__REPORTS_DIR;
        }
    }

    public String getPdfMergeCmdTemplate() {
        try {
            return this.getProperties().getProperty(PROP__PDFMERGE_CMD_TMEPLATE, DEFAULT__PDFMERGE_CMD_TEMPLATE);
        }
        catch (Exception ex) {
            LOG.info((Object)String.format("Property %s not set", PROP__PDFMERGE_CMD_TMEPLATE), (Throwable)ex);
            return DEFAULT__PDFMERGE_CMD_TEMPLATE;
        }
    }
}

