/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import de.aedsicad.aaaweb.rest.model.Address;
import de.aedsicad.aaaweb.rest.model.Buchungsblatt;
import de.aedsicad.aaaweb.rest.model.Buchungsstelle;
import de.aedsicad.aaaweb.rest.model.LandParcel;
import de.aedsicad.aaaweb.rest.model.Namensnummer;
import de.aedsicad.aaaweb.rest.model.Owner;
import de.cismet.cids.custom.utils.alkis.AlkisConf;
import de.cismet.cids.custom.utils.alkis.AlkisProductDescription;
import de.cismet.cids.custom.utils.alkis.AlkisPunktReportScriptlet;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.alkis.StempelfeldInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisRestAction;
import de.cismet.cids.dynamics.CidsBean;
import java.awt.Point;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class AlkisProducts {
    private static final Logger LOG = Logger.getLogger(AlkisProducts.class);
    public static final String HEADER_CONTENTTYPE_KEY = "Content-Type";
    public static final String HEADER_CONTENTTYPE_VALUE_POST = "application/x-www-form-urlencoded";
    public static final HashMap<String, String> POST_HEADER = new HashMap();
    public static final String NEWLINE = "<br>";
    public static final String LINK_SEPARATOR_TOKEN = "::";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_NRW = "custom.alkis.product.bestandsnachweis_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_KOM = "custom.alkis.product.bestandsnachweis_kom@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_KOM_INTERN = "custom.alkis.product.bestandsnachweis_kom_intern@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_STICHSTAGSBEZOGEN_NRW = "custom.alkis.product.bestandsnachweis_stichtagsbezogen_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_GRUNDSTUECKSNACHWEIS_NRW = "custom.alkis.product.grundstuecksnachweis_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKSNACHWEIS = "custom.alkis.product.flurstuecksnachweis@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_NRW = "custom.alkis.product.flurstuecks_eigentumsnachweis_nrw@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_KOM = "custom.alkis.product.flurstuecks_eigentumsnachweis_kom@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_KOM_INTERN = "custom.alkis.product.flurstuecks_eigentumsnachweis_kom_intern@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_KARTE = "custom.alkis.product.karte@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_ENABLED = "baulast.report.bescheinigung_enabled@WUNDA_BLAU";
    public static final String PRODUCT_ACTION_TAG_BAULASTBESCHEINIGUNG_DISABLED = "baulast.report.bescheinigung_disabled@WUNDA_BLAU";
    public static final String ALKIS_HTML_PRODUCTS_ENABLED = "custom.alkis.products.html.enabled";
    public static final String ALKIS_EIGENTUEMER = "custom.alkis.buchungsblatt@WUNDA_BLAU";
    public static final String ADRESS_HERKUNFT_KATASTERAMT = "Katasteramt";
    public static final String ADRESS_HERKUNFT_GRUNDBUCHAMT = "Grundbuchamt";
    private static final DateFormat DF = new SimpleDateFormat("dd.MM.yyyy");
    private final List<AlkisProductDescription> alkisMapProducts;
    private final String nachverarbeitungScript;
    private final AlkisConf alkisConf;
    private final Map<Type, String> productMap = new HashMap<Type, String>();

    public AlkisProducts(AlkisConf alkisConf, Properties productProperties, Properties formatProperties, String produktbeschreibungXml) throws Exception {
        this.alkisConf = alkisConf;
        POST_HEADER.put(HEADER_CONTENTTYPE_KEY, HEADER_CONTENTTYPE_VALUE_POST);
        ArrayList<AlkisProductDescription> mapProducts = new ArrayList<AlkisProductDescription>();
        HashMap<String, Point> formatMap = new HashMap<String, Point>();
        this.alkisMapProducts = Collections.unmodifiableList(mapProducts);
        this.nachverarbeitungScript = productProperties.getProperty("NACHVERARBEITUNG_SCRIPT");
        this.productMap.put(Type.FLURSTUECKSNACHWEIS_PDF, productProperties.getProperty("FLURSTUECKSNACHWEIS_PDF"));
        this.productMap.put(Type.FLURSTUECKSNACHWEIS_HTML, productProperties.getProperty("FLURSTUECKSNACHWEIS_HTML"));
        this.productMap.put(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF, productProperties.getProperty("FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF"));
        this.productMap.put(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML, productProperties.getProperty("FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML"));
        this.productMap.put(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF, productProperties.getProperty("FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF"));
        this.productMap.put(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML, productProperties.getProperty("FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML"));
        this.productMap.put(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF, productProperties.getProperty("FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF"));
        this.productMap.put(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML, productProperties.getProperty("FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML"));
        this.productMap.put(Type.GRUNDSTUECKSNACHWEIS_NRW_PDF, productProperties.getProperty("GRUNDSTUECKSNACHWEIS_NRW_PDF"));
        this.productMap.put(Type.GRUNDSTUECKSNACHWEIS_NRW_HTML, productProperties.getProperty("GRUNDSTUECKSNACHWEIS_NRW_HTML"));
        this.productMap.put(Type.BESTANDSNACHWEIS_NRW_PDF, productProperties.getProperty("BESTANDSNACHWEIS_NRW_PDF"));
        this.productMap.put(Type.BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF, productProperties.getProperty("BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF"));
        this.productMap.put(Type.BESTANDSNACHWEIS_NRW_HTML, productProperties.getProperty("BESTANDSNACHWEIS_NRW_HTML"));
        this.productMap.put(Type.BESTANDSNACHWEIS_KOMMUNAL_PDF, productProperties.getProperty("BESTANDSNACHWEIS_KOMMUNAL_PDF"));
        this.productMap.put(Type.BESTANDSNACHWEIS_KOMMUNAL_HTML, productProperties.getProperty("BESTANDSNACHWEIS_KOMMUNAL_HTML"));
        this.productMap.put(Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_PDF, productProperties.getProperty("BESTANDSNACHWEIS_KOMMUNAL_INTERN_PDF"));
        this.productMap.put(Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_HTML, productProperties.getProperty("BESTANDSNACHWEIS_KOMMUNAL_INTERN_HTML"));
        this.productMap.put(Type.PUNKTLISTE_PDF, productProperties.getProperty("PUNKTLISTE_PDF"));
        this.productMap.put(Type.PUNKTLISTE_HTML, productProperties.getProperty("PUNKTLISTE_HTML"));
        this.productMap.put(Type.PUNKTLISTE_TXT, productProperties.getProperty("PUNKTLISTE_TXT"));
        Document document = new SAXBuilder().build((Reader)new StringReader(produktbeschreibungXml));
        for (Object o0 : document.getRootElement().getChildren()) {
            Element category = (Element)o0;
            String catName = category.getName();
            if (!"Karte".equals(catName)) continue;
            for (Object o1 : category.getChildren()) {
                Element productClass = (Element)o1;
                if (!productClass.getName().matches(".*[Kk]lasse.*")) continue;
                String clazz = productClass.getAttribute("Name").getValue();
                for (Object o2 : productClass.getChildren()) {
                    Element guiProduct = (Element)o2;
                    String type = guiProduct.getAttribute("ProduktnameAuswertung").getValue();
                    Attribute defaultProductAttr = guiProduct.getAttribute("defaultProduct");
                    boolean defaultProduct = defaultProductAttr != null ? defaultProductAttr.getBooleanValue() : false;
                    Attribute productDefaultScaleAttr = guiProduct.getAttribute("productDefaultScale");
                    Integer productDefaultScale = productDefaultScaleAttr != null ? Integer.valueOf(productDefaultScaleAttr.getIntValue()) : null;
                    for (Object o3 : guiProduct.getChildren()) {
                        Element singleProduct = (Element)o3;
                        Attribute codeAttr = singleProduct.getAttribute("ID");
                        if (codeAttr == null) continue;
                        String code = codeAttr.getValue();
                        String dinFormatCode = singleProduct.getAttribute("Layout").getValue();
                        String layoutDim = formatProperties.getProperty(dinFormatCode);
                        int width = -1;
                        int height = -1;
                        if (layoutDim == null) {
                            Logger.getLogger(ServerAlkisProducts.class).info((Object)("Can not find format dimensions for: " + dinFormatCode));
                        } else {
                            String[] dims = layoutDim.split("(x|X)");
                            width = Integer.parseInt(dims[0]);
                            height = Integer.parseInt(dims[1]);
                            formatMap.put(dinFormatCode, new Point(width, height));
                        }
                        Element preisFaktoren = (Element)singleProduct.getChildren().get(0);
                        String dinFormat = preisFaktoren.getAttribute("DINFormat").getValue();
                        String fileFormat = preisFaktoren.getAttribute("Dateiformat").getValue();
                        Attribute massstabAttr = preisFaktoren.getAttribute("Massstab");
                        String massstab = massstabAttr != null ? preisFaktoren.getAttribute("Massstab").getValue() : "-";
                        Attribute massstabMinAttr = preisFaktoren.getAttribute("MassstabMin");
                        String massstabMin = null;
                        if (massstabMinAttr != null) {
                            massstabMin = preisFaktoren.getAttribute("MassstabMin").getValue();
                        }
                        Attribute massstabMaxAttr = preisFaktoren.getAttribute("MassstabMin");
                        String massstabMax = null;
                        if (massstabMaxAttr != null) {
                            massstabMax = preisFaktoren.getAttribute("MassstabMax").getValue();
                        }
                        StempelfeldInfo stempelfeldInfo = null;
                        Element stempelFeldInfoElement = singleProduct.getChild("Stempelfeld", singleProduct.getNamespace());
                        if (stempelFeldInfoElement != null) {
                            float fromX = stempelFeldInfoElement.getAttribute("fromX").getFloatValue();
                            float fromY = stempelFeldInfoElement.getAttribute("fromY").getFloatValue();
                            float toX = stempelFeldInfoElement.getAttribute("toX").getFloatValue();
                            float toY = stempelFeldInfoElement.getAttribute("toY").getFloatValue();
                            stempelfeldInfo = new StempelfeldInfo(fromX, fromY, toX, toY);
                        }
                        AlkisProductDescription currentProduct = new AlkisProductDescription(clazz, type, code, dinFormat, massstab, massstabMin, massstabMax, fileFormat, width, height, defaultProduct, stempelfeldInfo, productDefaultScale);
                        mapProducts.add(currentProduct);
                    }
                }
            }
        }
    }

    public List<AlkisProductDescription> getAlkisMapProducts() {
        return this.alkisMapProducts;
    }

    public String getNachverarbeitungScript() {
        return this.nachverarbeitungScript;
    }

    public String get(Type type) {
        return this.productMap.get((Object)type);
    }

    public static String getPointDataForProduct(CidsBean pointBean) {
        StringBuilder sb = new StringBuilder("AX_");
        sb.append(pointBean.getProperty("pointtype"));
        sb.append(":");
        sb.append(pointBean.getProperty("pointcode"));
        return sb.toString().replace(" ", "");
    }

    public Collection<String> getCorrespondingPointDocuments(String pointcode) {
        StringBuilder urlBuilder;
        LinkedList<String> validDocuments = new LinkedList<String>();
        if (pointcode == null || pointcode.trim().length() < 9 || pointcode.trim().length() > 15) {
            return validDocuments;
        }
        if (pointcode.trim().length() < 15) {
            String kilometerquadratPart1 = pointcode.substring(2, 4);
            String kilometerquadratPart2 = pointcode.substring(6, 8);
            urlBuilder = new StringBuilder(this.alkisConf.getApmapsHost());
            urlBuilder.append(kilometerquadratPart1);
            urlBuilder.append(kilometerquadratPart2);
            urlBuilder.append('/');
            urlBuilder.append(this.alkisConf.getApmapsPrefix());
            urlBuilder.append(pointcode);
            urlBuilder.append('.');
        } else {
            urlBuilder = new StringBuilder(this.alkisConf.getApmapsEtrsHost());
            urlBuilder.append(this.alkisConf.getApmapsPrefix());
            urlBuilder.append(pointcode);
            urlBuilder.append('.');
        }
        for (String suffix : AlkisPunktReportScriptlet.SUFFIXES) {
            validDocuments.add(urlBuilder.toString() + suffix);
        }
        return validDocuments;
    }

    public Collection<String> getCorrespondingNivPURLs(String dgkBlattnummer, String laufendeNummer) {
        LinkedList<String> validDocuments = new LinkedList<String>();
        StringBuilder urlBuilder = new StringBuilder(this.alkisConf.getNivpHost());
        urlBuilder.append(dgkBlattnummer);
        urlBuilder.append('/');
        urlBuilder.append(this.alkisConf.getNivpPrefix());
        urlBuilder.append(dgkBlattnummer);
        urlBuilder.append(AlkisProducts.getFormattedLaufendeNummerNivP(laufendeNummer));
        urlBuilder.append('.');
        String documentWithoutPrefix = urlBuilder.toString();
        for (String suffix : AlkisPunktReportScriptlet.SUFFIXES) {
            validDocuments.add(documentWithoutPrefix + suffix);
        }
        return validDocuments;
    }

    public static String getFormattedLaufendeNummerNivP(String laufendeNummer) {
        StringBuilder result = laufendeNummer == null ? new StringBuilder("000") : new StringBuilder(laufendeNummer);
        while (result.length() < 3) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public String getActionTag(String product) {
        String actionTag = this.get(Type.FLURSTUECKSNACHWEIS_PDF).equals(product) || this.get(Type.FLURSTUECKSNACHWEIS_HTML).equals(product) ? PRODUCT_ACTION_TAG_FLURSTUECKSNACHWEIS : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF).equals(product) || this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML).equals(product) ? PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_NRW : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF).equals(product) || this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML).equals(product) ? PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_KOM_INTERN : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF).equals(product) || this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML).equals(product) ? PRODUCT_ACTION_TAG_FLURSTUECKS_EIGENTUMSNACHWEIS_KOM : (this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_PDF).equals(product) || this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_HTML).equals(product) ? PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_KOM : (this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_PDF).equals(product) || this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_HTML).equals(product) ? PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_KOM_INTERN : (this.get(Type.BESTANDSNACHWEIS_NRW_PDF).equals(product) || this.get(Type.BESTANDSNACHWEIS_NRW_HTML).equals(product) ? PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_NRW : (this.get(Type.BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF).equals(product) ? PRODUCT_ACTION_TAG_BESTANDSNACHWEIS_STICHSTAGSBEZOGEN_NRW : (this.get(Type.GRUNDSTUECKSNACHWEIS_NRW_PDF).equals(product) || this.get(Type.GRUNDSTUECKSNACHWEIS_NRW_HTML).equals(product) ? PRODUCT_ACTION_TAG_GRUNDSTUECKSNACHWEIS_NRW : "3wbgW\u00a7$%Q&/"))))))));
        return actionTag;
    }

    public String getProductName(String product) {
        String downloadTitle = this.get(Type.FLURSTUECKSNACHWEIS_PDF).equals(product) || this.get(Type.FLURSTUECKSNACHWEIS_HTML).equals(product) ? "Flurst\u00fccksnachweis" : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF).equals(product) || this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML).equals(product) ? "Flurst\u00fccks- und Eigentumsnachweis NRW" : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF).equals(product) || this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML).equals(product) ? "Flurst\u00fccks- und Eigentumsnachweis (kommunal)" : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF).equals(product) || this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML).equals(product) ? "Flurst\u00fccks- und Eigentumsnachweis (NRW, intern)" : (this.get(Type.BESTANDSNACHWEIS_NRW_PDF).equals(product) || this.get(Type.BESTANDSNACHWEIS_NRW_HTML).equals(product) ? "Bestandsnachweis (NRW)" : (this.get(Type.BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF).equals(product) ? "Bestandsnachweis stichtagsbezogen (NRW)" : (this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_PDF).equals(product) || this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_HTML).equals(product) ? "Bestandsnachweis (kommunal)" : (this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_PDF).equals(product) || this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_INTERN_HTML).equals(product) ? "Bestandsnachweis (NRW, intern)" : (this.get(Type.GRUNDSTUECKSNACHWEIS_NRW_PDF).equals(product) || this.get(Type.GRUNDSTUECKSNACHWEIS_NRW_HTML).equals(product) ? "Grundst\u00fccksnachweis (NRW)" : null))))))));
        return downloadTitle;
    }

    public String getBillingKey(String product) {
        String billingKey = this.get(Type.FLURSTUECKSNACHWEIS_PDF).equals(product) ? "fsnw" : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF).equals(product) ? "fsuenw" : (this.get(Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF).equals(product) ? "fsuekom" : (this.get(Type.BESTANDSNACHWEIS_NRW_PDF).equals(product) ? "benw" : (this.get(Type.BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF).equals(product) ? "bestnw" : (this.get(Type.BESTANDSNACHWEIS_KOMMUNAL_PDF).equals(product) ? "bekom" : (this.get(Type.GRUNDSTUECKSNACHWEIS_NRW_PDF).equals(product) ? "grnw" : null))))));
        return billingKey;
    }

    public static String generateLinkFromCidsBean(CidsBean bean, String description) {
        if (bean != null && description != null) {
            int objectID = bean.getMetaObject().getId();
            StringBuilder result = new StringBuilder("<a href=\"");
            result.append(bean.getMetaObject().getMetaClass().getID()).append(LINK_SEPARATOR_TOKEN).append(objectID);
            result.append("\">");
            result.append(description);
            result.append("</a>");
            return result.toString();
        }
        return "";
    }

    public static String addressToString(Address address) {
        if (address != null) {
            StringBuilder addressStringBuilder = new StringBuilder();
            addressStringBuilder.append(AlkisProducts.getAddressBoldOpenTag(address));
            if (address.getStreet() != null) {
                addressStringBuilder.append(address.getStreet()).append(" ");
            }
            if (address.getHouseNumber() != null) {
                addressStringBuilder.append(address.getHouseNumber());
            }
            if (addressStringBuilder.length() > 0) {
                addressStringBuilder.append(NEWLINE);
            }
            if (address.getPostalCode() != null) {
                addressStringBuilder.append(address.getPostalCode()).append(" ");
            }
            if (address.getCity() != null) {
                addressStringBuilder.append(address.getCity());
            }
            if (address.getCountry() != null && !address.getCountry().equalsIgnoreCase("DEUTSCHLAND")) {
                addressStringBuilder.append(NEWLINE);
                addressStringBuilder.append(address.getCountry());
            }
            if (addressStringBuilder.length() > 0) {
                addressStringBuilder.append(NEWLINE);
            }
            addressStringBuilder.append(AlkisProducts.getAdressPostfix(address));
            addressStringBuilder.append(NEWLINE);
            addressStringBuilder.append(AlkisProducts.getAddressBoldCloseTag(address));
            return addressStringBuilder.toString();
        }
        return "";
    }

    private static String getAdressPostfix(Address address) {
        if (address.getHerkunftAdress() != null && address.getHerkunftAdress().equals(ADRESS_HERKUNFT_KATASTERAMT)) {
            return ResourceBundle.getBundle("de/cismet/cids/custom/wunda_blau/res/alkis/AdressPostfixStrings").getString("kataster");
        }
        if (address.getHerkunftAdress() != null && address.getHerkunftAdress().equals(ADRESS_HERKUNFT_GRUNDBUCHAMT)) {
            return ResourceBundle.getBundle("de/cismet/cids/custom/wunda_blau/res/alkis/AdressPostfixStrings").getString("grundbuch");
        }
        String herkunft = address.getHerkunftAdress();
        if (herkunft == null) {
            herkunft = "-";
        }
        return String.format(ResourceBundle.getBundle("de/cismet/cids/custom/wunda_blau/res/alkis/AdressPostfixStrings").getString("else"), herkunft);
    }

    private static String getAddressBoldOpenTag(Address address) {
        if (address.getHerkunftAdress() != null && address.getHerkunftAdress().equals(ADRESS_HERKUNFT_KATASTERAMT)) {
            return "<b>";
        }
        return "";
    }

    private static String getAddressBoldCloseTag(Address address) {
        if (address.getHerkunftAdress() != null && address.getHerkunftAdress().equals(ADRESS_HERKUNFT_KATASTERAMT)) {
            return "</b>";
        }
        return "";
    }

    public static String getLandparcelCodeFromParcelBeanObject(Object landParcel) {
        CidsBean cidsBean;
        Object parcelCodeObj;
        if (landParcel instanceof CidsBean && (parcelCodeObj = (cidsBean = (CidsBean)landParcel).getProperty("alkis_id")) != null) {
            return parcelCodeObj.toString();
        }
        return "";
    }

    public static List<LandParcel> getLandparcelFromBuchungsstelle(Buchungsstelle buchungsstelle) {
        ArrayList<LandParcel> result = new ArrayList<LandParcel>();
        if (buchungsstelle.getBuchungsstellen() == null && buchungsstelle.getLandParcel() == null) {
            LOG.warn((Object)("getLandparcelFromBuchungsstelle returns null. Problem on landparcel with number:" + buchungsstelle.getSequentialNumber()));
        } else {
            List landparcels = buchungsstelle.getLandParcel();
            if (landparcels != null) {
                result.addAll(landparcels);
            }
            if (buchungsstelle.getBuchungsstellen() != null) {
                for (Buchungsstelle b : buchungsstelle.getBuchungsstellen()) {
                    result.addAll(AlkisProducts.getLandparcelFromBuchungsstelle(b));
                }
            }
        }
        return result;
    }

    public static String prettyPrintLandparcelCode(String fullLandparcelCode) {
        String[] tiles = fullLandparcelCode.split("-");
        switch (tiles.length) {
            case 1: {
                String flurstueck = tiles[0];
                return AlkisProducts._prettyPrintLandparcelCode(flurstueck);
            }
            case 2: {
                String flurstueck = tiles[1];
                String flur = tiles[0];
                String result = AlkisProducts._prettyPrintLandparcelCode(flurstueck, flur);
                return result;
            }
            case 3: {
                String flurstueck = tiles[2];
                String flur = tiles[1];
                String gemarkung = tiles[0];
                return AlkisProducts._prettyPrintLandparcelCode(flurstueck, flur, gemarkung);
            }
        }
        return fullLandparcelCode;
    }

    public static String escapeHtmlSpaces(String toEscape) {
        if (toEscape != null) {
            toEscape = toEscape.replace(" ", "%20");
        }
        return toEscape;
    }

    private static String removeLeadingZeros(String in) {
        return in.replaceAll("^0*", "");
    }

    private static String normalizeNameNumber(String nameNumber) {
        String[] tokens = nameNumber.split("\\.");
        StringBuilder result = new StringBuilder();
        for (String token : tokens) {
            if ((token = AlkisProducts.removeLeadingZeros(token)).length() <= 0) continue;
            result.append(token).append(".");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
            return result.toString();
        }
        return "0";
    }

    private static String _prettyPrintLandparcelCode(String flurstueck, String flur, String gemarkung) {
        return AlkisProducts._prettyPrintLandparcelCode(flurstueck, flur) + " - Gemarkung " + gemarkung;
    }

    private static String _prettyPrintLandparcelCode(String flurstueck, String flur) {
        return AlkisProducts._prettyPrintLandparcelCode(flurstueck) + " - Flur " + AlkisProducts.removeLeadingZeros(flur);
    }

    private static String _prettyPrintLandparcelCode(String flurstueck) {
        return "Flurst\u00fcck " + AlkisProducts.prettyPrintFlurstueck(flurstueck);
    }

    private static String prettyPrintFlurstueck(String fsZahlerNenner) {
        String[] tiles = fsZahlerNenner.split("/");
        if (tiles.length == 2) {
            return AlkisProducts.removeLeadingZeros(tiles[0]) + "/" + AlkisProducts.removeLeadingZeros(tiles[1]);
        }
        if (tiles.length == 1) {
            return AlkisProducts.removeLeadingZeros(tiles[0]);
        }
        return fsZahlerNenner;
    }

    public static String getBuchungsartFromBuchungsblatt(Buchungsblatt blatt) {
        List buchungsstellen = blatt.getBuchungsstellen();
        if (buchungsstellen != null && !buchungsstellen.isEmpty()) {
            ArrayList<Buchungsstelle> alleStellen = new ArrayList<Buchungsstelle>();
            alleStellen.addAll(buchungsstellen);
            if (AlkisProducts.isListOfSameBuchungsart(alleStellen)) {
                return alleStellen.get(0).getBuchungsart();
            }
            return "diverse";
        }
        return "";
    }

    public static boolean isListOfSameBuchungsart(List<Buchungsstelle> buchungsstellen) {
        HashSet<String> set = new HashSet<String>();
        for (Buchungsstelle o : buchungsstellen) {
            if (set.isEmpty()) {
                set.add(o.getBuchungsart());
                continue;
            }
            if (!set.add(o.getBuchungsart())) continue;
            return false;
        }
        return true;
    }

    public static String prettyPrintAufteilungsnummer(String aufteilungsnummer) {
        if (aufteilungsnummer != null) {
            return "ATP Nr. " + aufteilungsnummer;
        }
        return "";
    }

    public static String prettyPrintFraction(String fraction) {
        if (fraction != null) {
            return "Anteil " + fraction;
        }
        return "";
    }

    public static String fixBuchungslattCode(String buchungsblattCode) {
        boolean useNewVersion = false;
        useNewVersion = AlkisRestAction.getAlkisAccessProvider().getAlkisRestConf().getNewRestServiceUsed() != false;
        return AlkisProducts.fixBuchungslattCode(buchungsblattCode, useNewVersion);
    }

    public static String fixBuchungslattCode(String buchungsblattCode, boolean newVersion) {
        if (buchungsblattCode != null) {
            if (newVersion) {
                StringBuffer buchungsblattCodeSB = new StringBuffer();
                if ((buchungsblattCode.length() < 14 || buchungsblattCode.endsWith(" ")) && buchungsblattCode.contains("-")) {
                    String blattCode = buchungsblattCode;
                    if (blattCode.endsWith(" ")) {
                        blattCode = blattCode.substring(0, blattCode.length() - 1);
                    }
                    buchungsblattCodeSB.append(blattCode.substring(0, blattCode.indexOf("-") + 1));
                    for (int i = 0; i < 14 - blattCode.length(); ++i) {
                        buchungsblattCodeSB.append("0");
                    }
                    buchungsblattCodeSB.append(blattCode.substring(blattCode.indexOf("-") + 1));
                    return buchungsblattCodeSB.toString();
                }
                return buchungsblattCode;
            }
            StringBuffer buchungsblattCodeSB = new StringBuffer(buchungsblattCode);
            while (buchungsblattCodeSB.length() < 14) {
                buchungsblattCodeSB.append(" ");
            }
            return buchungsblattCodeSB.toString();
        }
        return "";
    }

    private static String buchungsblattOwnersToHtml(int level, List<String> namensnummerUuids, HashMap<String, Namensnummer> namensnummernMap, HashMap<String, Owner> ownerHashMap) {
        String style = level > 0 ? "style=\"border-left: 1px solid black\"" : "";
        StringBuffer sb = new StringBuffer("<table cellspacing=\"0\" " + style + " cellpadding=\"10\" border=\"0\" align=\"left\" valign=\"top\">");
        for (String uuid : namensnummerUuids) {
            Namensnummer namensnummer = namensnummernMap.get(uuid);
            sb.append("<tr>");
            if (namensnummer.getArtRechtsgemeinschaft() != null) {
                String artRechtsgemeinschaft = namensnummer.getArtRechtsgemeinschaft().trim();
                sb.append("<td width=\"80\">").append("ohne Nr.").append("</td><td><b>").append(artRechtsgemeinschaft.equals("Sonstiges") ? "Rechtsgemeinschaft" : artRechtsgemeinschaft).append(":</b> ").append(namensnummer.getBeschriebRechtsgemeinschaft() != null ? namensnummer.getBeschriebRechtsgemeinschaft() : "").append(NEWLINE);
            } else {
                Owner owner = ownerHashMap.get(namensnummer.getEigentuemerUUId());
                sb.append(AlkisProducts.buchungsblattOwnerToHtml(namensnummer, owner));
            }
            sb.append("<td style=\"padding-left: 30px\">");
            if (namensnummer.getZaehler() != null && namensnummer.getNenner() != null) {
                String part = namensnummer.getZaehler().intValue() + "/" + namensnummer.getNenner().intValue();
                sb.append("<nobr>").append("zu ").append(part).append("</nobr>");
            }
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public static String buchungsblattOwnersToHtml(Buchungsblatt buchungsblatt) {
        HashMap<String, Owner> ownersMap = AlkisProducts.extractOwnersMap(buchungsblatt);
        HashMap<String, Namensnummer> namensnummernMap = AlkisProducts.extractNamensnummernMap(buchungsblatt);
        List<String> rootUuids = AlkisProducts.getSortedRootUuids(namensnummernMap);
        return AlkisProducts.buchungsblattOwnersToHtml(0, rootUuids, namensnummernMap, ownersMap);
    }

    private static HashMap<String, Owner> extractOwnersMap(Buchungsblatt buchungsblatt) {
        HashMap<String, Owner> ownersMap = new HashMap<String, Owner>();
        for (Owner owner : buchungsblatt.getOwners()) {
            ownersMap.put(owner.getOwnerId(), owner);
        }
        return ownersMap;
    }

    private static List<String> getSortedRootUuids(HashMap<String, Namensnummer> namensnummernMap) {
        ArrayList redirectedUuids = new ArrayList();
        for (Namensnummer namensnummer : namensnummernMap.values()) {
            String uuid = namensnummer.getUuid();
            namensnummernMap.put(uuid, namensnummer);
            List namensnummerUuids = namensnummer.getNamensnummernUUIds();
            if (namensnummerUuids == null) continue;
            redirectedUuids.addAll(namensnummerUuids);
        }
        ArrayList<String> rootUuids = new ArrayList<String>(namensnummernMap.keySet());
        Collections.sort(rootUuids, new NamensnummerComparator(namensnummernMap));
        return rootUuids;
    }

    private static HashMap<String, Namensnummer> extractNamensnummernMap(Buchungsblatt buchungsblatt) {
        HashMap<String, Namensnummer> namensnummernMap = new HashMap<String, Namensnummer>();
        for (Namensnummer namensnummer : buchungsblatt.getNamensnummern()) {
            namensnummernMap.put(namensnummer.getUuid(), namensnummer);
        }
        return namensnummernMap;
    }

    public static String buchungsblattOwnerToHtml(Namensnummer namensnummer, Owner owner) {
        List addresses;
        StringBuffer sb = new StringBuffer();
        sb.append("<td width=\"60\">");
        if (owner.getNameNumber() != null) {
            sb.append(AlkisProducts.normalizeNameNumber(namensnummer.getLaufendeNummer()));
        }
        sb.append("</td><td><p>");
        if (owner.getSalutation() != null) {
            sb.append(owner.getSalutation()).append(" ");
        }
        if (owner.getForeName() != null) {
            sb.append(owner.getForeName()).append(" ");
        }
        if (owner.getSurName() != null) {
            sb.append(owner.getSurName());
        }
        if (owner.getDateOfBirth() != null) {
            Date date;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(owner.getDateOfBirth());
            }
            catch (Exception ex) {
                date = null;
            }
            sb.append(", *").append(DF.format(date));
        }
        sb.append("</p>");
        if (owner.getNameOfBirth() != null) {
            sb.append("<p>").append("geb. ").append(owner.getNameOfBirth()).append("</p>");
        }
        if ((addresses = owner.getAddresses()) != null) {
            boolean first = true;
            for (Address address : addresses) {
                if (address != null && address.getHerkunftAdress() != null && address.getHerkunftAdress().equals(ADRESS_HERKUNFT_KATASTERAMT)) {
                    sb.append(first ? "" : NEWLINE).append("<p>").append(AlkisProducts.addressToString(address)).append("</p>");
                }
                first = false;
            }
            for (Address address : addresses) {
                if (!(address == null || address.getHerkunftAdress() != null && address.getHerkunftAdress().equals(ADRESS_HERKUNFT_KATASTERAMT))) {
                    sb.append(first ? "" : NEWLINE).append("<p>").append(AlkisProducts.addressToString(address)).append("</p>");
                }
                first = false;
            }
        }
        sb.append("</td>");
        return sb.toString();
    }

    public static String buchungsblattToHtml(CidsBean originatingFlurstueck, Buchungsblatt buchungsblatt, CidsBean buchungsblattBean) {
        String alkisId = (String)originatingFlurstueck.getProperty("alkis_id");
        String pos = "";
        List buchungsstellen = buchungsblatt.getBuchungsstellen();
        for (Buchungsstelle b : buchungsstellen) {
            for (LandParcel lp : AlkisProducts.getLandparcelFromBuchungsstelle(b)) {
                if (!lp.getLandParcelCode().equals(alkisId)) continue;
                pos = b.getSequentialNumber();
            }
        }
        List owners = buchungsblatt.getOwners();
        if (owners != null && owners.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<table cellspacing=\"0\" cellpadding=\"10\" border=\"0\" align=\"left\" valign=\"top\">");
            sb.append("<tr><td width=\"200\">Nr. ").append(pos).append(" auf  <b>").append(AlkisProducts.generateLinkFromCidsBean(buchungsblattBean, buchungsblatt.getBuchungsblattCode())).append("</b></td><td>");
            sb.append(AlkisProducts.buchungsblattOwnersToHtml(buchungsblatt));
            sb.append("</td></tr>");
            sb.append("</table>");
            return sb.toString();
        }
        return "";
    }

    private static class NamensnummerComparator
    implements Comparator<String> {
        private final HashMap<String, Namensnummer> namensnummernMap;

        public NamensnummerComparator(HashMap<String, Namensnummer> namensnummernMap) {
            this.namensnummernMap = namensnummernMap;
        }

        @Override
        public int compare(String einzelUuid1, String einzelUuid2) {
            Namensnummer n1 = this.namensnummernMap.get(einzelUuid1);
            Namensnummer n2 = this.namensnummernMap.get(einzelUuid2);
            String tmp1 = n1 == null || n1.getLaufendeNummer() == null ? "ZZZ" : n1.getLaufendeNummer();
            String tmp2 = n2 == null || n2.getLaufendeNummer() == null ? "ZZZ" : n2.getLaufendeNummer();
            String[] lfds1 = tmp1.split("\\.");
            String[] lfds2 = tmp2.split("\\.");
            for (int i = 0; i < Math.max(lfds1.length, lfds2.length); ++i) {
                String lfd2;
                String lfd1 = i < lfds1.length ? lfds1[i] : StringUtils.repeat((String)"0", (int)lfds2[i].length());
                String string = lfd2 = i < lfds2.length ? lfds2[i] : StringUtils.repeat((String)"0", (int)lfds1[i].length());
                if (lfd1.length() < lfd2.length()) {
                    lfd1 = StringUtils.repeat((String)"0", (int)(lfd2.length() - lfd1.length())) + lfd1;
                } else {
                    lfd2 = StringUtils.repeat((String)"0", (int)(lfd1.length() - lfd2.length())) + lfd2;
                }
                int compare = lfd1.compareTo(lfd2);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }

    public static enum Type {
        FLURSTUECKSNACHWEIS_PDF,
        FLURSTUECKSNACHWEIS_HTML,
        FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF,
        FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_HTML,
        FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF,
        FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_HTML,
        FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF,
        FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_HTML,
        BESTANDSNACHWEIS_NRW_PDF,
        BESTANDSNACHWEIS_STICHTAGSBEZOGEN_NRW_PDF,
        BESTANDSNACHWEIS_NRW_HTML,
        BESTANDSNACHWEIS_KOMMUNAL_PDF,
        BESTANDSNACHWEIS_KOMMUNAL_HTML,
        BESTANDSNACHWEIS_KOMMUNAL_INTERN_PDF,
        BESTANDSNACHWEIS_KOMMUNAL_INTERN_HTML,
        GRUNDSTUECKSNACHWEIS_NRW_PDF,
        GRUNDSTUECKSNACHWEIS_NRW_HTML,
        PUNKTLISTE_PDF,
        PUNKTLISTE_HTML,
        PUNKTLISTE_TXT;

    }
}

