/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.aedsicad.aaaweb.rest.model.Buchungsblatt;
import de.aedsicad.aaaweb.rest.model.Buchungsstelle;
import de.aedsicad.aaaweb.rest.model.LandParcel;
import de.cismet.cids.custom.utils.AsyncDownloadHelper;
import de.cismet.cids.custom.utils.GeneralUtils;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.BaulastenPictureFinder;
import de.cismet.cids.custom.utils.alkis.BaulastenReportGenerator;
import de.cismet.cids.custom.utils.alkis.FsMailConfigJson;
import de.cismet.cids.custom.utils.berechtigungspruefung.DownloadInfoFactory;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungBaulastInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungFlurstueckInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungGruppeInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisRestAction;
import de.cismet.cids.custom.wunda_blau.search.actions.BaulastBescheinigungReportServerAction;
import de.cismet.cids.custom.wunda_blau.search.actions.BaulastenReportServerAction;
import de.cismet.cids.custom.wunda_blau.search.server.BaulastSearchInfo;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBaulastSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.FlurstueckInfo;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class BaulastBescheinigungHelper {
    private static final Logger LOG = Logger.getLogger(BaulastBescheinigungHelper.class);
    private static final Map<String, MetaClass> METACLASS_CACHE = new HashMap<String, MetaClass>();
    private static final int LARGE_FILE_SIZE = 0xC800000;
    private final ConnectionContext connectionContext;
    private final MetaService metaService;
    private final User user;

    public BaulastBescheinigungHelper(User user, MetaService metaService, ConnectionContext connectionContext) {
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
    }

    public void fillFlurstueckeToBaulastenMaps(Collection<CidsBean> flurstuecke, Map<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBelastetMap, Map<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBeguenstigtMap, ProtocolBuffer protocolBuffer) throws Exception {
        protocolBuffer.appendLine("\n===");
        flurstueckeToBaulastenBelastetMap.putAll(this.createFlurstueckeToBaulastenMap(flurstuecke, true, protocolBuffer));
        flurstueckeToBaulastenBeguenstigtMap.putAll(this.createFlurstueckeToBaulastenMap(flurstuecke, false, protocolBuffer));
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public User getUser() {
        return this.user;
    }

    protected Collection executeSearch(CidsServerSearch serverSearch) throws Exception {
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("WUNDA_BLAU", this.getMetaService());
        serverSearch.setActiveLocalServers(localServers);
        serverSearch.setUser(this.getUser());
        if (serverSearch instanceof ConnectionContextStore) {
            ((ConnectionContextStore)serverSearch).initWithConnectionContext(this.getConnectionContext());
        }
        return serverSearch.performServerSearch();
    }

    protected MetaObject getMetaObject(int oid, int cid) throws Exception {
        return DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), oid, cid, this.getConnectionContext());
    }

    protected MetaObject[] getMetaObjects(String query) throws Exception {
        return DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), query, this.getConnectionContext());
    }

    protected MetaClass getMetaClass(String tableName) {
        if (!METACLASS_CACHE.containsKey(tableName)) {
            MetaClass mc = null;
            try {
                mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)tableName, (ConnectionContext)this.connectionContext);
            }
            catch (Exception ex) {
                LOG.error((Object)("could not get metaclass of " + tableName), (Throwable)ex);
            }
            METACLASS_CACHE.put(tableName, mc);
        }
        return METACLASS_CACHE.get(tableName);
    }

    private Map<CidsBean, Set<CidsBean>> createFlurstueckeToBaulastenMap(Collection<CidsBean> flurstuecke, boolean belastet, ProtocolBuffer protocolBuffer) throws Exception {
        String queryBeguenstigt = "SELECT %d, alb_baulast.%s \nFROM alb_baulast_flurstuecke_beguenstigt, alb_baulast, alb_flurstueck_kicker, flurstueck \nWHERE alb_baulast.id = alb_baulast_flurstuecke_beguenstigt.baulast_reference \nAND alb_baulast_flurstuecke_beguenstigt.flurstueck = alb_flurstueck_kicker.id \nAND alb_flurstueck_kicker.fs_referenz = flurstueck.id \nAND flurstueck.alkis_id ilike '%s' \nAND alb_baulast.geschlossen_am is null AND alb_baulast.loeschungsdatum is null";
        String queryBelastet = "SELECT %d, alb_baulast.%s \nFROM alb_baulast_flurstuecke_belastet, alb_baulast, alb_flurstueck_kicker, flurstueck \nWHERE alb_baulast.id = alb_baulast_flurstuecke_belastet.baulast_reference \nAND alb_baulast_flurstuecke_belastet.flurstueck = alb_flurstueck_kicker.id \nAND alb_flurstueck_kicker.fs_referenz = flurstueck.id \nAND flurstueck.alkis_id ilike '%s' \nAND alb_baulast.geschlossen_am is null AND alb_baulast.loeschungsdatum is null";
        MetaClass mcBaulast = this.getMetaClass("alb_baulast");
        String query = belastet ? "SELECT %d, alb_baulast.%s \nFROM alb_baulast_flurstuecke_belastet, alb_baulast, alb_flurstueck_kicker, flurstueck \nWHERE alb_baulast.id = alb_baulast_flurstuecke_belastet.baulast_reference \nAND alb_baulast_flurstuecke_belastet.flurstueck = alb_flurstueck_kicker.id \nAND alb_flurstueck_kicker.fs_referenz = flurstueck.id \nAND flurstueck.alkis_id ilike '%s' \nAND alb_baulast.geschlossen_am is null AND alb_baulast.loeschungsdatum is null" : "SELECT %d, alb_baulast.%s \nFROM alb_baulast_flurstuecke_beguenstigt, alb_baulast, alb_flurstueck_kicker, flurstueck \nWHERE alb_baulast.id = alb_baulast_flurstuecke_beguenstigt.baulast_reference \nAND alb_baulast_flurstuecke_beguenstigt.flurstueck = alb_flurstueck_kicker.id \nAND alb_flurstueck_kicker.fs_referenz = flurstueck.id \nAND flurstueck.alkis_id ilike '%s' \nAND alb_baulast.geschlossen_am is null AND alb_baulast.loeschungsdatum is null";
        protocolBuffer.appendLine("\nSuche der " + (belastet ? "belastenden" : "beg\u00fcnstigenden") + " Baulasten von:");
        HashMap<CidsBean, Set<CidsBean>> flurstueckeToBaulastenMap = new HashMap<CidsBean, Set<CidsBean>>();
        for (CidsBean flurstueck : flurstuecke) {
            MetaObject[] mos;
            protocolBuffer.appendLine(" * Flurst\u00fcck: " + flurstueck + " ...");
            HashSet<CidsBean> baulasten = new HashSet<CidsBean>();
            BaulastSearchInfo searchInfo = new BaulastSearchInfo();
            Integer gemarkung = Integer.parseInt(((String)flurstueck.getProperty("alkis_id")).substring(2, 6));
            String flur = (String)flurstueck.getProperty("flur");
            String zaehler = Integer.toString(Integer.parseInt((String)flurstueck.getProperty("fstck_zaehler")));
            String nenner = flurstueck.getProperty("fstck_nenner") == null ? "0" : Integer.toString(Integer.parseInt((String)flurstueck.getProperty("fstck_nenner")));
            FlurstueckInfo fsi = new FlurstueckInfo(gemarkung, flur, zaehler, nenner);
            searchInfo.setFlurstuecke(Arrays.asList(fsi));
            searchInfo.setResult(CidsBaulastSearchStatement.Result.BAULAST);
            searchInfo.setBelastet(belastet);
            searchInfo.setBeguenstigt(!belastet);
            searchInfo.setBlattnummer("");
            searchInfo.setArt("");
            CidsBaulastSearchStatement search = new CidsBaulastSearchStatement(searchInfo, mcBaulast.getId(), -1);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Collection mons = this.executeSearch((CidsServerSearch)search);
            for (MetaObjectNode mon : mons) {
                MetaObject mo = this.getMetaObject(mon.getObjectId(), mon.getClassId());
                if (mo.getBean() != null && mo.getBean() != null && (mo.getBean().getProperty("loeschungsdatum") != null || mo.getBean().getProperty("geschlossen_am") != null) || !mon.getName().startsWith("indirekt: ")) continue;
                throw new BaBeException("Zu den angegebenen Flurst\u00fccken kann aktuell keine Baulastauskunft erteilt werden, da sich einige der enthaltenen Baulasten im Bearbeitungszugriff befinden.");
            }
            String alkisId = (String)flurstueck.getProperty("alkis_id");
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            for (MetaObject mo : mos = this.getMetaObjects(String.format(query, mcBaulast.getID(), mcBaulast.getPrimaryKey(), alkisId))) {
                CidsBean baulast = mo.getBean();
                Boolean geprueft = (Boolean)baulast.getProperty("geprueft");
                if (geprueft == null || !geprueft.booleanValue()) {
                    throw new BaBeException("Zu den angegebenen Flurst\u00fccken kann aktuell keine Baulastauskunft erteilt werden, da sich einige der enthaltenen Baulasten im Bearbeitungszugriff befinden.");
                }
                protocolBuffer.appendLine("   => Baulast: " + baulast);
                baulasten.add(baulast);
            }
            flurstueckeToBaulastenMap.put(flurstueck, baulasten);
        }
        return flurstueckeToBaulastenMap;
    }

    public HashMap<String, Integer> createBilling(Map<String, Collection<CidsBean>> grundstueckeToFlurstueckeMap, Map<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBelastetMap, Map<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBeguenstigtMap, ProtocolBuffer protocolBuffer) {
        ArrayList<String> keys = new ArrayList<String>(grundstueckeToFlurstueckeMap.keySet());
        Collections.sort(keys);
        int anzahlGrundstuecke = grundstueckeToFlurstueckeMap.size();
        if (anzahlGrundstuecke == 1) {
            protocolBuffer.appendLine("\n===\n\nBescheinigungsart des Grundst\u00fccks:");
        } else {
            protocolBuffer.appendLine("\n===\n\nBescheinigungsarten der " + anzahlGrundstuecke + " ermittelten Grundst\u00fccke:");
        }
        int anzahlNegativ = 0;
        int anzahlPositiv1 = 0;
        int anzahlPositiv2 = 0;
        int anzahlPositiv3 = 0;
        block5: for (String key : keys) {
            if (!grundstueckeToFlurstueckeMap.containsKey(key)) continue;
            boolean first = true;
            Collection<CidsBean> flurstuecke = grundstueckeToFlurstueckeMap.get(key);
            HashSet<CidsBean> baulasten = new HashSet<CidsBean>();
            for (CidsBean cidsBean : flurstuecke) {
                Collection<CidsBean> baulastenBelastet = flurstueckeToBaulastenBelastetMap.get(cidsBean);
                Collection<CidsBean> baulastenBeguenstigt = flurstueckeToBaulastenBeguenstigtMap.get(cidsBean);
                baulasten.addAll(baulastenBelastet);
                baulasten.addAll(baulastenBeguenstigt);
            }
            StringBuffer sb = new StringBuffer();
            for (CidsBean baulast : baulasten) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(baulast);
            }
            String string = sb.toString();
            int numOfBaulasten = baulasten.size();
            switch (numOfBaulasten) {
                case 0: {
                    protocolBuffer.appendLine(" * Grundst\u00fcck " + key + " => Negativ-Bescheinigung");
                    ++anzahlNegativ;
                    continue block5;
                }
                case 1: {
                    protocolBuffer.appendLine(" * Grundst\u00fcck " + key + " => Positiv-Bescheinigung f\u00fcr eine Baulast (" + string + ")");
                    ++anzahlPositiv1;
                    continue block5;
                }
                case 2: {
                    protocolBuffer.appendLine(" * Grundst\u00fcck " + key + " => Positiv-Bescheinigung f\u00fcr zwei Baulasten (" + string + ")");
                    ++anzahlPositiv2;
                    continue block5;
                }
            }
            protocolBuffer.appendLine(" * Grundst\u00fcck " + key + " => Positiv-Bescheinigung f\u00fcr drei oder mehr Baulasten (" + string + ")");
            ++anzahlPositiv3;
        }
        HashMap<String, Integer> prodAmounts = new HashMap<String, Integer>();
        if (anzahlNegativ > 0) {
            prodAmounts.put("ea_blab_neg", anzahlNegativ);
        }
        if (anzahlPositiv1 > 0) {
            prodAmounts.put("ea_blab_pos_1", anzahlPositiv1);
        }
        if (anzahlPositiv2 > 0) {
            prodAmounts.put("ea_blab_pos_2", anzahlPositiv2);
        }
        if (anzahlPositiv3 > 0) {
            prodAmounts.put("ea_blab_pos_3", anzahlPositiv3);
        }
        return prodAmounts;
    }

    public Set<BerechtigungspruefungBescheinigungGruppeInfo> createBescheinigungsGruppen(Map<CidsBean, Collection<String>> flurstueckeToGrundstueckeMap, Map<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBeguenstigtMap, Map<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBelastetMap, ProtocolBuffer protocolBuffer) {
        HashMap<String, BerechtigungspruefungBescheinigungGruppeInfo> gruppeMap = new HashMap<String, BerechtigungspruefungBescheinigungGruppeInfo>();
        ArrayList<CidsBean> flurstuecke = new ArrayList<CidsBean>(flurstueckeToGrundstueckeMap.keySet());
        Collections.sort(flurstuecke, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                String s1 = o1 == null ? "" : (String)o1.getProperty("alkis_id");
                String s2 = o2 == null ? "" : (String)o2.getProperty("alkis_id");
                return s1.compareTo(s2);
            }
        });
        for (CidsBean flurstueck : flurstuecke) {
            Collection<CidsBean> baulastenBeguenstigt = flurstueckeToBaulastenBeguenstigtMap.get(flurstueck);
            Collection<CidsBean> baulastenBelastet = flurstueckeToBaulastenBelastetMap.get(flurstueck);
            BerechtigungspruefungBescheinigungGruppeInfo newGruppe = DownloadInfoFactory.createBerechtigungspruefungBescheinigungGruppeInfo(flurstueckeToGrundstueckeMap.get(flurstueck).iterator().next(), baulastenBeguenstigt, baulastenBelastet);
            String gruppeKey = newGruppe.toString();
            if (!gruppeMap.containsKey(gruppeKey)) {
                gruppeMap.put(gruppeKey, newGruppe);
            }
            BerechtigungspruefungBescheinigungGruppeInfo gruppe = (BerechtigungspruefungBescheinigungGruppeInfo)gruppeMap.get(gruppeKey);
            gruppe.getFlurstuecke().add(DownloadInfoFactory.createBerechtigungspruefungBescheinigungFlurstueckInfo(flurstueck, flurstueckeToGrundstueckeMap.get(flurstueck)));
        }
        HashSet<BerechtigungspruefungBescheinigungGruppeInfo> bescheinigungsgruppen = new HashSet<BerechtigungspruefungBescheinigungGruppeInfo>(gruppeMap.values());
        protocolBuffer.appendLine("\n===\n\nAnzahl Bescheinigungsgruppen: " + bescheinigungsgruppen.size());
        for (BerechtigungspruefungBescheinigungGruppeInfo gruppe : bescheinigungsgruppen) {
            protocolBuffer.appendLine(" * " + gruppe.toString());
        }
        return bescheinigungsgruppen;
    }

    public Map<CidsBean, Collection<String>> createFlurstueckeToGrundstueckeMap(Collection<CidsBean> flurstuecke, Map<String, Collection<CidsBean>> grundstueckeToFlurstueckeMap) {
        HashMap<CidsBean, Collection<String>> flurstueckeToGrundstueckeMap = new HashMap<CidsBean, Collection<String>>();
        for (String grundstueck : grundstueckeToFlurstueckeMap.keySet()) {
            Collection<CidsBean> gruFlu = grundstueckeToFlurstueckeMap.get(grundstueck);
            for (CidsBean flurstueck : flurstuecke) {
                if (!gruFlu.contains(flurstueck)) continue;
                if (!flurstueckeToGrundstueckeMap.containsKey(flurstueck)) {
                    flurstueckeToGrundstueckeMap.put(flurstueck, new HashSet());
                }
                Collection<String> grundstuecke = flurstueckeToGrundstueckeMap.get(flurstueck);
                grundstuecke.add(grundstueck);
            }
        }
        return flurstueckeToGrundstueckeMap;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void prepareFlurstuecke(List<CidsBean> flurstuecke, ProtocolBuffer protocolBuffer) throws Exception {
        protocolBuffer.appendLine("Baulastbescheinigungs-Protokoll f\u00fcr " + (flurstuecke.size() == 1 ? "folgendes Flurst\u00fcck" : "folgende Flurst\u00fccke") + ":");
        Collections.sort(flurstuecke, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                String s1 = o1 == null ? "" : (String)o1.getProperty("alkis_id");
                String s2 = o2 == null ? "" : (String)o2.getProperty("alkis_id");
                return s1.compareTo(s2);
            }
        });
        for (CidsBean flurstueck : flurstuecke) {
            protocolBuffer.appendLine(" * " + flurstueck);
        }
    }

    public Map<String, Collection<CidsBean>> createGrundstueckeToFlurstueckeMap(Collection<CidsBean> flurstuecke, ProtocolBuffer protocolBuffer) throws Exception {
        protocolBuffer.appendLine("\n===\n\nZuordnung der Flurst\u00fccke zu Grundst\u00fccken...");
        HashMap<String, Collection<CidsBean>> grundstueckeToFlurstueckeMap = new HashMap<String, Collection<CidsBean>>();
        block0: for (CidsBean flurstueckBean : flurstuecke) {
            ArrayList buchungsblaetter = new ArrayList(flurstueckBean.getBeanCollectionProperty("buchungsblaetter"));
            if (buchungsblaetter.size() == 1) {
                protocolBuffer.appendLine("Flurst\u00fcck: " + flurstueckBean + " (1 Buchungsblatt):");
            } else {
                protocolBuffer.appendLine("Flurst\u00fcck: " + flurstueckBean + " (" + buchungsblaetter.size() + " Buchungsbl\u00e4tter):");
            }
            Collections.sort(buchungsblaetter, new Comparator<CidsBean>(){

                @Override
                public int compare(CidsBean o1, CidsBean o2) {
                    String s1 = o1 == null ? "" : (String)o1.getProperty("buchungsblattcode");
                    String s2 = o2 == null ? "" : (String)o2.getProperty("buchungsblattcode");
                    return s1.compareTo(s2);
                }
            });
            boolean grundstueckFound = false;
            block1: for (CidsBean buchungsblattBean : buchungsblaetter) {
                if (grundstueckFound) continue block0;
                if (buchungsblattBean == null) continue;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                protocolBuffer.appendLine(" * analysiere Buchungsblatt " + buchungsblattBean + " ..");
                Buchungsblatt buchungsblatt = this.getBuchungsblatt(buchungsblattBean);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                List buchungsstellen = buchungsblatt.getBuchungsstellen();
                Collections.sort(buchungsstellen, new Comparator<Buchungsstelle>(){

                    @Override
                    public int compare(Buchungsstelle o1, Buchungsstelle o2) {
                        String s1 = o1 == null ? "" : o1.getSequentialNumber();
                        String s2 = o2 == null ? "" : o2.getSequentialNumber();
                        return s1.compareTo(s2);
                    }
                });
                for (Buchungsstelle buchungsstelle : buchungsstellen) {
                    String key;
                    if (grundstueckFound) continue block1;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    boolean flurstueckPartOfStelle = false;
                    List<LandParcel> landparcels = AlkisProducts.getLandparcelFromBuchungsstelle(buchungsstelle);
                    if (landparcels != null) {
                        for (LandParcel lp : landparcels) {
                            if (!((String)flurstueckBean.getProperty("alkis_id")).equals(lp.getLandParcelCode())) continue;
                            flurstueckPartOfStelle = true;
                            break;
                        }
                    }
                    if (!flurstueckPartOfStelle) continue;
                    String[] bbc = buchungsblatt.getBuchungsblattCode().split("-");
                    String gemarkungsnummer = bbc[0].substring(2).trim();
                    String buchungsblattnummer = bbc[1].trim();
                    MetaClass mcGemarkung = this.getMetaClass("gemarkung");
                    String pruefungQuery = "SELECT " + mcGemarkung.getID() + ", " + mcGemarkung.getTableName() + "." + mcGemarkung.getPrimaryKey() + " FROM " + mcGemarkung.getTableName() + " WHERE " + mcGemarkung.getTableName() + ".gemarkungsnummer = " + Integer.parseInt(gemarkungsnummer) + " LIMIT 1;";
                    MetaObject[] mos = this.getMetaObjects(pruefungQuery);
                    if (mos != null && mos.length > 0) {
                        CidsBean gemarkung = mos[0].getBean();
                        key = gemarkung.getProperty("name") + " " + Integer.parseInt(buchungsblattnummer.substring(0, 5)) + buchungsblattnummer.substring(5) + " / " + Integer.parseInt(buchungsstelle.getSequentialNumber());
                    } else {
                        key = "[" + gemarkungsnummer + "] " + Integer.parseInt(buchungsblattnummer.substring(0, 5)) + buchungsblattnummer.substring(5) + " / " + Integer.parseInt(buchungsstelle.getSequentialNumber());
                    }
                    String buchungsart = buchungsstelle.getBuchungsart();
                    if ("Erbbaurecht".equals(buchungsart)) {
                        protocolBuffer.appendLine("   -> ignoriere \"" + key + "\" aufgrund der Buchungsart (" + buchungsart + ")");
                        continue;
                    }
                    if (!grundstueckeToFlurstueckeMap.containsKey(key)) {
                        grundstueckeToFlurstueckeMap.put(key, new HashSet());
                    }
                    String buchungsartSuffix = "Grundst\u00fcck".equals(buchungsart) ? "" : " (" + buchungsart + ")";
                    protocolBuffer.appendLine("   => f\u00fcge Flurst\u00fcck " + flurstueckBean + " zu Grundst\u00fcck \"" + key + "\" hinzu" + buchungsartSuffix);
                    ((Collection)grundstueckeToFlurstueckeMap.get(key)).add(flurstueckBean);
                    grundstueckFound = true;
                }
            }
        }
        return grundstueckeToFlurstueckeMap;
    }

    public static List<BerechtigungspruefungBescheinigungGruppeInfo> getSortedBescheinigungsGruppen(Collection<BerechtigungspruefungBescheinigungGruppeInfo> bescheinigungsgruppen) {
        ArrayList<BerechtigungspruefungBescheinigungGruppeInfo> sortedBescheinigungsGruppen = new ArrayList<BerechtigungspruefungBescheinigungGruppeInfo>(bescheinigungsgruppen);
        Collections.sort(sortedBescheinigungsGruppen, new Comparator<BerechtigungspruefungBescheinigungGruppeInfo>(){

            @Override
            public int compare(BerechtigungspruefungBescheinigungGruppeInfo o1, BerechtigungspruefungBescheinigungGruppeInfo o2) {
                String alkisId1 = o1.getFlurstuecke().iterator().next().getAlkisId();
                String alkisId2 = o2.getFlurstuecke().iterator().next().getAlkisId();
                return alkisId1.compareTo(alkisId2);
            }
        });
        return sortedBescheinigungsGruppen;
    }

    private CidsBean loadBaulast(BerechtigungspruefungBescheinigungBaulastInfo info) throws Exception {
        String query = "SELECT %d, id FROM alb_baulast WHERE blattnummer ILIKE '%s' AND laufende_nummer ILIKE '%s'";
        MetaClass mcBaulast = this.getMetaClass("alb_baulast");
        MetaObject[] mos = this.getMetaObjects(String.format("SELECT %d, id FROM alb_baulast WHERE blattnummer ILIKE '%s' AND laufende_nummer ILIKE '%s'", mcBaulast.getID(), info.getBlattnummer(), info.getLaufende_nummer()));
        if (mos != null && mos.length > 0) {
            return mos[0].getBean();
        }
        return null;
    }

    public void writeProcotol(String protocol, ZipOutputStream zipOut) throws IOException {
        this.writeToZip("baulastbescheinigung_protokoll.txt", IOUtils.toInputStream((String)protocol, (String)"UTF-8"), zipOut);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File writeFullBescheinigung(BerechtigungspruefungBescheinigungDownloadInfo downloadInfo, File file, String transid) {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(file));){
            this.writeProcotol(downloadInfo.getProtokoll(), zipOut);
            if (downloadInfo.getBescheinigungsInfo() != null) {
                HashSet<CidsBean> allBaulasten = new HashSet<CidsBean>();
                int number = 0;
                for (BerechtigungspruefungBescheinigungGruppeInfo bescheinigungsGruppeInfo : BaulastBescheinigungHelper.getSortedBescheinigungsGruppen(downloadInfo.getBescheinigungsInfo().getBescheinigungsgruppen())) {
                    this.writeBescheinigungReport(bescheinigungsGruppeInfo, downloadInfo.getAuftragsnummer(), downloadInfo.getProduktbezeichnung(), downloadInfo.getBescheinigungsInfo().getDatum(), downloadInfo.getFertigungsVermerk(), ++number, zipOut);
                    for (BerechtigungspruefungBescheinigungBaulastInfo baulastInfo : bescheinigungsGruppeInfo.getBaulastenBelastet()) {
                        allBaulasten.add(this.loadBaulast(baulastInfo));
                    }
                    for (BerechtigungspruefungBescheinigungBaulastInfo baulastInfo : bescheinigungsGruppeInfo.getBaulastenBeguenstigt()) {
                        allBaulasten.add(this.loadBaulast(baulastInfo));
                    }
                }
                if (!allBaulasten.isEmpty()) {
                    this.writeBaulastenReports(BaulastenReportGenerator.Type.TEXTBLATT_PLAN_RASTER, allBaulasten, downloadInfo.getAuftragsnummer(), downloadInfo.getProduktbezeichnung(), zipOut);
                    this.writeAdditionalFiles(allBaulasten, zipOut);
                }
            }
            zipOut.close();
            File file2 = BaulastBescheinigungHelper.handleLargeFileIfRequired(file, transid);
            return file2;
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static File handleLargeFileIfRequired(File file, String transid) throws Exception {
        if (file.length() > 0xC800000L) {
            String fileName = file.getAbsolutePath();
            int suffixStart = file.getName().lastIndexOf(".");
            File newFileName = suffixStart != -1 ? File.createTempFile(file.getName().substring(0, suffixStart), file.getName().substring(suffixStart), file.getParentFile()) : File.createTempFile(file.getName(), null, file.getParentFile());
            File origProduct = new File(fileName);
            origProduct.renameTo(newFileName);
            origProduct = newFileName;
            byte[] preparedProduct = ServerResourcesLoader.getInstance().loadBinary(WundaBlauServerResources.FS_LARGE_PRODUCT_RESPONSE.getValue());
            FileOutputStream out = new FileOutputStream(file);
            out.write(preparedProduct);
            out.close();
            FsMailConfigJson mailConfig = (FsMailConfigJson)new ObjectMapper().readValue(ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.FS_MAIL_CONFIGURATION.getValue()), FsMailConfigJson.class);
            String content = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.FS_MAIL_CONTENT_TEMPLATE.getValue());
            if (mailConfig != null && content != null) {
                String cmdTemplate = mailConfig.getCmdTemplate();
                String betreff = mailConfig.getTopic();
                content = content.replace("{transid}", transid);
                GeneralUtils.sendMail(cmdTemplate, mailConfig.getEmailAddress(), betreff, content);
            } else {
                LOG.error((Object)"Cannot send mail to inform about a large file that must be delivered manually");
            }
            return origProduct;
        }
        return null;
    }

    private void writeToZip(String fileName, InputStream in, ZipOutputStream zipOut) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        zipOut.putNextEntry(new ZipEntry(fileName));
        while ((len = in.read(buf)) > 0) {
            zipOut.write(buf, 0, len);
        }
        zipOut.flush();
    }

    private void writeAdditionalFiles(Collection<CidsBean> baulasten, ZipOutputStream zipOut) throws Exception {
        for (URL url : BaulastenPictureFinder.getInstance().findAdditionalFiles(baulasten)) {
            this.writeToZip(url.getFile().substring(url.getFile().lastIndexOf(47) + 1), new SimpleHttpAccessHandler().doRequest(url), zipOut);
        }
    }

    private void writeBescheinigungReport(BerechtigungspruefungBescheinigungGruppeInfo bescheinigungsGruppeInfo, String auftragsNummer, String projectName, Date fertigungsDatum, String fertigungsVermerk, int number, ZipOutputStream zipOut) throws JsonProcessingException, IOException {
        List<BerechtigungspruefungBescheinigungFlurstueckInfo> fls = bescheinigungsGruppeInfo.getFlurstuecke();
        ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.BESCHEINIGUNGGRUPPE_INFO.toString(), (Object)new ObjectMapper().writeValueAsString((Object)bescheinigungsGruppeInfo)), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.FABRICATION_DATE.toString(), (Object)(fertigungsDatum != null ? fertigungsDatum : new Date()).getTime()), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.FERTIGUNGS_VERMERK.toString(), (Object)fertigungsVermerk), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.JOB_NUMBER.toString(), (Object)auftragsNummer), new ServerActionParameter(BaulastBescheinigungReportServerAction.Parameter.PROJECT_NAME.toString(), (Object)projectName)};
        BaulastBescheinigungReportServerAction serverAction = new BaulastBescheinigungReportServerAction();
        serverAction.setMetaService(this.getMetaService());
        serverAction.setUser(this.getUser());
        serverAction.initWithConnectionContext(this.getConnectionContext());
        String fileName = String.format("bescheinigung_%s%s_%d.pdf", ((BerechtigungspruefungBescheinigungFlurstueckInfo)fls.iterator().next()).getAlkisId().replace("/", "--"), fls.size() > 1 ? ".ua" : "", number);
        this.writeToZip(fileName, new ByteArrayInputStream((byte[])AsyncDownloadHelper.actionResultToByteArrayIfPossible(serverAction.execute(null, saps))), zipOut);
    }

    private void writeBaulastenReports(BaulastenReportGenerator.Type type, Collection<CidsBean> selectedBaulasten, String jobNumber, String projectName, ZipOutputStream zipOut) throws IOException {
        ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
        for (CidsBean baulastBean : selectedBaulasten) {
            mons.add(new MetaObjectNode(baulastBean));
        }
        ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(BaulastenReportServerAction.Parameter.BAULASTEN_MONS.toString(), mons), new ServerActionParameter(BaulastenReportServerAction.Parameter.JOB_NUMBER.toString(), (Object)jobNumber), new ServerActionParameter(BaulastenReportServerAction.Parameter.PROJECT_NAME.toString(), (Object)projectName), new ServerActionParameter(BaulastenReportServerAction.Parameter.TYPE.toString(), (Object)type)};
        BaulastenReportServerAction serverAction = new BaulastenReportServerAction();
        serverAction.setMetaService(this.getMetaService());
        serverAction.setUser(this.getUser());
        serverAction.initWithConnectionContext(this.getConnectionContext());
        this.writeToZip("baulasten.pdf", new ByteArrayInputStream((byte[])AsyncDownloadHelper.actionResultToByteArrayIfPossible(serverAction.execute(null, saps))), zipOut);
    }

    protected Buchungsblatt getBuchungsblatt(CidsBean buchungsblattBean) throws Exception {
        String buchungsblattcode = String.valueOf(buchungsblattBean.getProperty("buchungsblattcode"));
        if (buchungsblattcode != null && buchungsblattcode.length() > 5) {
            ServerActionParameter buchungsblattCodeSAP = new ServerActionParameter(AlkisRestAction.RETURN_VALUE.BUCHUNGSBLATT.toString(), (Object)buchungsblattcode);
            AlkisRestAction.RETURN_VALUE body = AlkisRestAction.RETURN_VALUE.BUCHUNGSBLATT;
            return (Buchungsblatt)new AlkisRestAction().execute((Object)body, buchungsblattCodeSAP);
        }
        return null;
    }

    public BerechtigungspruefungBescheinigungDownloadInfo calculateDownloadInfo(String auftragsnummer, String produktBezeichnung, String fertigungsVermerk, List<CidsBean> flurstuecke, ProtocolBuffer protocolBuffer, StatusHolder statusHolder) throws Exception {
        statusHolder.setMessage("Bescheinigung wird vorbereitet...");
        this.prepareFlurstuecke(flurstuecke, protocolBuffer);
        statusHolder.setMessage("Buchungsbl\u00e4tter werden analysiert...");
        Map<String, Collection<CidsBean>> grundstueckeToFlurstueckeMap = this.createGrundstueckeToFlurstueckeMap(flurstuecke, protocolBuffer);
        statusHolder.setMessage("Baulasten werden gesucht...");
        HashMap<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBelastetMap = new HashMap<CidsBean, Collection<CidsBean>>();
        HashMap<CidsBean, Collection<CidsBean>> flurstueckeToBaulastenBeguenstigtMap = new HashMap<CidsBean, Collection<CidsBean>>();
        this.fillFlurstueckeToBaulastenMaps(flurstuecke, flurstueckeToBaulastenBelastetMap, flurstueckeToBaulastenBeguenstigtMap, protocolBuffer);
        statusHolder.setMessage("Geb\u00fchr wird berechnet...");
        HashMap<String, Integer> prodAmounts = this.createBilling(grundstueckeToFlurstueckeMap, flurstueckeToBaulastenBelastetMap, flurstueckeToBaulastenBeguenstigtMap, protocolBuffer);
        statusHolder.setMessage("Bescheinigungsgruppen werden identifiziert...");
        Set<BerechtigungspruefungBescheinigungGruppeInfo> bescheinigungsgruppen = this.createBescheinigungsGruppen(this.createFlurstueckeToGrundstueckeMap(flurstuecke, grundstueckeToFlurstueckeMap), flurstueckeToBaulastenBeguenstigtMap, flurstueckeToBaulastenBelastetMap, protocolBuffer);
        BerechtigungspruefungBescheinigungInfo bescheinigungInfo = new BerechtigungspruefungBescheinigungInfo(new Date(), new HashSet<BerechtigungspruefungBescheinigungGruppeInfo>(bescheinigungsgruppen));
        return new BerechtigungspruefungBescheinigungDownloadInfo(auftragsnummer, produktBezeichnung, fertigungsVermerk, protocolBuffer.toString(), bescheinigungInfo, prodAmounts);
    }

    public static class ProtocolBuffer {
        private final StringBuffer buffer = new StringBuffer();

        public ProtocolBuffer appendLine(String string) {
            this.buffer.append(string).append("\n");
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    public static class StatusHolder {
        private String message;

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class BaBeException
    extends Exception {
        public BaBeException(String message) {
            super(message);
        }
    }
}

