/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.berechtigungspruefung;

import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungBaulastInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungFlurstueckInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungGruppeInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisKarteDownloadInfo;
import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DownloadInfoFactory {
    public static BerechtigungspruefungAlkisEinzelnachweisDownloadInfo createAlkisBuchungsblattnachweisDownloadInfo(String product, Date stichtag, List<String> buchungsblattCodes) {
        BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo = new BerechtigungspruefungAlkisEinzelnachweisDownloadInfo(BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.BUCHUNGSBLAETTER, product, stichtag, buchungsblattCodes);
        return downloadInfo;
    }

    public static BerechtigungspruefungAlkisEinzelnachweisDownloadInfo createAlkisBuchungsblattachweisDownloadInfo(String product, List<String> buchungsblattCodes) {
        BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo = new BerechtigungspruefungAlkisEinzelnachweisDownloadInfo(BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.BUCHUNGSBLAETTER, product, buchungsblattCodes);
        return downloadInfo;
    }

    public static BerechtigungspruefungAlkisKarteDownloadInfo createBerechtigungspruefungAlkisKarteDownloadInfo(String product, List<String> alkisCodes) {
        BerechtigungspruefungAlkisKarteDownloadInfo downloadInfo = new BerechtigungspruefungAlkisKarteDownloadInfo(BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.FLURSTUECKE, alkisCodes);
        return downloadInfo;
    }

    public static BerechtigungspruefungAlkisEinzelnachweisDownloadInfo createBerechtigungspruefungAlkisEinzelnachweisDownloadInfo(String product, List<String> alkisCodes) {
        BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo = new BerechtigungspruefungAlkisEinzelnachweisDownloadInfo(BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.FLURSTUECKE, product, alkisCodes);
        return downloadInfo;
    }

    public static BerechtigungspruefungAlkisKarteDownloadInfo createBerechtigungspruefungAlkisKarteDownloadInfo(List<String> alkisCodes) {
        BerechtigungspruefungAlkisKarteDownloadInfo downloadInfo = new BerechtigungspruefungAlkisKarteDownloadInfo(BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.FLURSTUECKE, alkisCodes);
        return downloadInfo;
    }

    public static BerechtigungspruefungBescheinigungGruppeInfo createBerechtigungspruefungBescheinigungGruppeInfo(String name, Collection<CidsBean> baulastenBeguenstigtBeans, Collection<CidsBean> baulastenBelastetBeans) {
        ArrayList<BerechtigungspruefungBescheinigungFlurstueckInfo> flurstueckeInfo = new ArrayList<BerechtigungspruefungBescheinigungFlurstueckInfo>();
        ArrayList<BerechtigungspruefungBescheinigungBaulastInfo> baulastBeguenstigtInfos = new ArrayList<BerechtigungspruefungBescheinigungBaulastInfo>();
        for (CidsBean cidsBean : baulastenBeguenstigtBeans) {
            BerechtigungspruefungBescheinigungBaulastInfo baulastBeguenstigtInfo = DownloadInfoFactory.createBerechtigungspruefungBescheinigungBaulastInfo(cidsBean);
            baulastBeguenstigtInfos.add(baulastBeguenstigtInfo);
        }
        ArrayList<BerechtigungspruefungBescheinigungBaulastInfo> baulastBelastetInfos = new ArrayList<BerechtigungspruefungBescheinigungBaulastInfo>();
        for (CidsBean baulastBelastet : baulastenBelastetBeans) {
            BerechtigungspruefungBescheinigungBaulastInfo baulastBelastetInfo = DownloadInfoFactory.createBerechtigungspruefungBescheinigungBaulastInfo(baulastBelastet);
            baulastBelastetInfos.add(baulastBelastetInfo);
        }
        Collections.sort(flurstueckeInfo, new Comparator<BerechtigungspruefungBescheinigungFlurstueckInfo>(){

            @Override
            public int compare(BerechtigungspruefungBescheinigungFlurstueckInfo o1, BerechtigungspruefungBescheinigungFlurstueckInfo o2) {
                int compareGemarkung = DownloadInfoFactory.compareString(o1.getGemarkung(), o2.getGemarkung());
                if (compareGemarkung != 0) {
                    return compareGemarkung;
                }
                int compareFlur = DownloadInfoFactory.compareString(o1.getFlur(), o2.getFlur());
                if (compareFlur != 0) {
                    return compareFlur;
                }
                int compareNummer = DownloadInfoFactory.compareString(o1.getNummer(), o2.getNummer());
                if (compareNummer != 0) {
                    return compareNummer;
                }
                return 0;
            }
        });
        Comparator<BerechtigungspruefungBescheinigungBaulastInfo> comparator = new Comparator<BerechtigungspruefungBescheinigungBaulastInfo>(){

            @Override
            public int compare(BerechtigungspruefungBescheinigungBaulastInfo o1, BerechtigungspruefungBescheinigungBaulastInfo o2) {
                int lfdN2;
                int compareBlattnummer = DownloadInfoFactory.compareString(o1.getBlattnummer(), o2.getBlattnummer());
                if (compareBlattnummer != 0) {
                    return compareBlattnummer;
                }
                Integer lfdN1 = Integer.parseInt(o1.getLaufende_nummer());
                int compareLaufendenummer = lfdN1.compareTo(lfdN2 = Integer.parseInt(o2.getLaufende_nummer()));
                if (compareLaufendenummer != 0) {
                    return compareLaufendenummer;
                }
                return 0;
            }
        };
        Collections.sort(baulastBeguenstigtInfos, comparator);
        Collections.sort(baulastBelastetInfos, comparator);
        return new BerechtigungspruefungBescheinigungGruppeInfo(name, flurstueckeInfo, baulastBeguenstigtInfos, baulastBelastetInfos);
    }

    public static BerechtigungspruefungBescheinigungFlurstueckInfo createBerechtigungspruefungBescheinigungFlurstueckInfo(CidsBean flurstueck, Collection<String> grundstuecke) {
        String lage;
        String alkisId = (String)flurstueck.getProperty("alkis_id");
        String gemarkung = (String)flurstueck.getProperty("gemarkung");
        String flur = (String)flurstueck.getProperty("flur");
        String nenner = (String)flurstueck.getProperty("fstck_nenner");
        String zaehler = (String)flurstueck.getProperty("fstck_zaehler");
        List adressen = flurstueck.getBeanCollectionProperty("adressen");
        if (adressen.isEmpty()) {
            lage = "";
        } else {
            HashSet<String> strassen = new HashSet<String>();
            HashMap hausnummernMap = new HashMap();
            for (CidsBean adresse : adressen) {
                String strasse = (String)adresse.getProperty("strasse");
                String hausnummer = (String)adresse.getProperty("nummer");
                strassen.add(strasse);
                if (hausnummer == null) continue;
                if (!hausnummernMap.containsKey(strasse)) {
                    hausnummernMap.put(strasse, new ArrayList());
                }
                List hausnummern = (List)hausnummernMap.get(strasse);
                hausnummern.add(hausnummer);
            }
            String strasse = (String)strassen.iterator().next();
            StringBuffer sb = new StringBuffer(strasse);
            boolean first = true;
            List hausnummern = (List)hausnummernMap.get(strasse);
            if (hausnummern != null) {
                Collections.sort(hausnummern);
                sb.append(" ");
                for (String hausnummer : hausnummern) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(hausnummer);
                    first = false;
                }
            }
            if (strassen.size() > 1) {
                sb.append(" u.a.");
            }
            lage = sb.toString();
        }
        return new BerechtigungspruefungBescheinigungFlurstueckInfo(alkisId, gemarkung, flur, zaehler, nenner, lage, grundstuecke);
    }

    public static BerechtigungspruefungBescheinigungBaulastInfo createBerechtigungspruefungBescheinigungBaulastInfo(CidsBean baulast) {
        String blattnummer = (String)baulast.getProperty("blattnummer");
        String laufende_nummer = (String)baulast.getProperty("laufende_nummer");
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (CidsBean art : baulast.getBeanCollectionProperty("art")) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(art.getProperty("baulast_art"));
        }
        String arten = sb.toString();
        return new BerechtigungspruefungBescheinigungBaulastInfo(blattnummer, laufende_nummer, arten);
    }

    private static int compareString(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s1.equals(s2)) {
            return 0;
        }
        return s1.compareTo(s2);
    }
}

