/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.nas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import de.cismet.cidsx.server.api.types.Action;
import de.cismet.cidsx.server.api.types.ActionResultInfo;
import de.cismet.cidsx.server.api.types.ActionTask;
import de.cismet.cidsx.server.api.types.CollectionResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class CidsActionClient {
    protected static final String ACTION_URL = "/actions";
    private static final Logger LOG = Logger.getLogger(CidsActionClient.class);
    protected String domain;
    protected String baseURL;
    private final Client client;
    private final ObjectMapper mapper = new ObjectMapper();
    private final String RESOURCE_URL = "/%1$s.%2$s/tasks/%3$s/results/%4$s";

    public CidsActionClient(String domain, String baseURL) {
        this.domain = domain;
        this.baseURL = baseURL;
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(MultiPartWriter.class);
        this.client = Client.create((ClientConfig)clientConfig);
    }

    public Client getClient() {
        return this.client;
    }

    public void setBasicAuthentication(String user, String password) {
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
    }

    private <T> T getSimpleResource(Class<T> c, String url) {
        WebResource r = this.client.resource(url);
        String jsonResult = (String)r.get(String.class);
        try {
            Object result = this.mapper.readValue(jsonResult, c);
            return (T)result;
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private <E> List<E> getCollectionResource(Class<E> c, String url) {
        try {
            String json = (String)this.client.resource(url).queryParam("domain", "cids").accept(new String[]{"application/json"}).get(String.class);
            CollectionResource resource = (CollectionResource)this.mapper.readValue(json, CollectionResource.class);
            String actionJson = this.mapper.writeValueAsString((Object)resource.get$collection());
            List result = (List)this.mapper.readValue(actionJson, new TypeReference<List<E>>(){});
            return result;
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected List<Action> getAllActions() {
        String url = this.baseURL + ACTION_URL;
        return this.getCollectionResource(Action.class, url);
    }

    protected Action getAction(String actionKey) {
        String formattedUrl = String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, "", "");
        String url = this.baseURL + ACTION_URL + formattedUrl.substring(0, formattedUrl.lastIndexOf("/tasks"));
        return this.getSimpleResource(Action.class, url);
    }

    protected List<ActionTask> getAllRunningTasks(String actionKey) {
        String formattedUrl = String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, "", "");
        String url = this.baseURL + ACTION_URL + formattedUrl.substring(0, formattedUrl.lastIndexOf("//results"));
        return this.getCollectionResource(ActionTask.class, url);
    }

    protected ActionTask.Status getTaskStatus(String actionKey, String taskKey) {
        String formattedUrl = String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, taskKey, "");
        String url = this.baseURL + ACTION_URL + formattedUrl.substring(0, formattedUrl.lastIndexOf("/results"));
        ActionTask status = this.getSimpleResource(ActionTask.class, url);
        if (status != null) {
            return status.getStatus();
        }
        return null;
    }

    protected void cancelTask(String actionKey, String taskKey) {
        String formattedUrl = String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, taskKey, "");
        String url = this.baseURL + ACTION_URL + formattedUrl.substring(0, formattedUrl.lastIndexOf("/results"));
        this.client.resource(url).delete();
    }

    protected ActionTask createTask(String actionKey, ActionTask task, File f, MediaType fileType, boolean requestResultingInstance) {
        try {
            String formattedUrl = String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, "", "");
            String url = this.baseURL + ACTION_URL + formattedUrl.substring(0, formattedUrl.lastIndexOf("//results"));
            WebResource webResource = this.client.resource(url).queryParam("requestResultingInstance", Boolean.toString(requestResultingInstance));
            FormDataMultiPart form = new FormDataMultiPart();
            form.field("taskparams", (Object)this.mapper.writeValueAsString((Object)task), MediaType.APPLICATION_JSON_TYPE);
            if (f != null) {
                form.field("file", (Object)f, fileType);
            }
            String responseJson = (String)((WebResource.Builder)webResource.type("multipart/form-data").accept(new String[]{"application/json"})).post(String.class, (Object)form);
            ActionTask resultingInstance = (ActionTask)this.mapper.readValue(responseJson, ActionTask.class);
            return resultingInstance;
        }
        catch (JsonProcessingException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    protected <T> T getTaskResult(Class<T> c, String actionKey, String taskKey, String resultKey) {
        String url = this.baseURL + ACTION_URL + String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, taskKey, resultKey);
        WebResource r = this.client.resource(url);
        return (T)r.get(c);
    }

    protected List<ActionResultInfo> getTaskResults(String actionKey, String taskKey) {
        String url = this.baseURL + ACTION_URL + String.format("/%1$s.%2$s/tasks/%3$s/results/%4$s", this.domain, actionKey, taskKey, "").substring(0, "/%1$s.%2$s/tasks/%3$s/results/%4$s".lastIndexOf("/"));
        return this.getCollectionResource(ActionResultInfo.class, url);
    }

    public static void main(String[] args) {
        CidsActionClient client = new CidsActionClient("cids", "http://s102x002:8890");
        ActionTask at = new ActionTask();
        at.setParameters(new HashMap());
        File f = new File("ci_test_klein.zip");
        ActionTask resultInstance = client.createTask("dummydxf", at, f, new MediaType("application", "zip"), true);
        System.out.println("Resulting instance: " + resultInstance.getKey());
        ActionTask.Status status = client.getTaskStatus("dummydxf", resultInstance.getKey());
        while (status != ActionTask.Status.FINISHED) {
            try {
                Thread.sleep(1000L);
                status = client.getTaskStatus("dummydxf", resultInstance.getKey());
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        File tmpFile = client.getTaskResult(File.class, "dummydxf", resultInstance.getKey(), "dxfOutput");
        File result = new File("result.dxf");
        try {
            IOUtils.copy((InputStream)new FileInputStream(tmpFile), (OutputStream)new FileOutputStream(result));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        System.out.println("Done");
    }
}

