/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.nas;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GML3Writer {
    private static final Logger LOG = Logger.getLogger(GML3Writer.class);

    public static String convertToGML(GeometryCollection geometries, String crs, String srsNameProp) {
        String rawXML = "";
        if (geometries.getSRID() == 0) {
            LOG.warn((Object)"There is no SRID set for the geometry to convert to GML. Using SRID EPSG:25832 as default");
            geometries.setSRID(25832);
        }
        try {
            JAXBContext ffo = JAXBContext.newInstance((String)"org.jvnet.ogc.gml.v_3_1_1.jts");
            StringWriter sw = new StringWriter();
            ffo.createMarshaller().marshal((Object)geometries, (Writer)sw);
            rawXML = sw.getBuffer().toString();
            rawXML = rawXML.replaceAll("ns1:", "gml:");
            ByteArrayInputStream is = new ByteArrayInputStream(rawXML.getBytes());
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(is);
            NodeList linearRingNodes = doc.getElementsByTagName("gml:LinearRing");
            for (int i = 0; i < linearRingNodes.getLength(); ++i) {
                StringBuilder poslistCoords = new StringBuilder();
                Node child = linearRingNodes.item(i).getFirstChild();
                while (child != null) {
                    if (child.getNodeName().equals("gml:pos")) {
                        poslistCoords.append(child.getTextContent());
                        poslistCoords.append(" ");
                    }
                    Node nextSibling = child.getNextSibling();
                    linearRingNodes.item(i).removeChild(child);
                    child = nextSibling;
                }
                Element newNode = doc.createElement("gml:posList");
                newNode.setTextContent(poslistCoords.toString());
                linearRingNodes.item(i).appendChild(newNode);
            }
            NodeList geometryMemberNodes = doc.getElementsByTagName("gml:geometryMember");
            for (int i = 0; i < geometryMemberNodes.getLength(); ++i) {
                Node geometryMember = geometryMemberNodes.item(i);
                Node oldPolygonNode = geometryMember.getFirstChild();
                geometryMember.removeChild(oldPolygonNode);
                Element surface = doc.createElement("gml:Surface");
                surface.setAttribute("srsName", srsNameProp);
                Element patches = doc.createElement("gml:patches");
                surface.appendChild(patches);
                patches.appendChild(oldPolygonNode);
                geometryMember.appendChild(surface);
            }
            OutputFormat format = new OutputFormat(doc);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer(stringOut, format);
            serial.serialize(doc);
            rawXML = stringOut.toString();
        }
        catch (JAXBException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        rawXML = rawXML.replaceAll("MultiGeometry", "MultiSurface");
        rawXML = rawXML.replaceAll("geometryMember", "surfaceMember");
        rawXML = rawXML.replaceAll("Polygon", "PolygonPatch");
        rawXML = rawXML.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        rawXML = rawXML.replace("xmlns:ns1=\"http://www.opengis.net/gml\"", "");
        rawXML = rawXML.replace("xmlns:ns2=\"http://www.w3.org/1999/xlink\"", "");
        rawXML = rawXML.replace("xmlns:ns3=\"http://www.w3.org/2001/SMIL20/\"", "");
        rawXML = rawXML.replace("xmlns:ns4=\"http://www.w3.org/2001/SMIL20/Language\"", "");
        rawXML = rawXML.replace("    ", "");
        rawXML = rawXML.replaceFirst("srsName=\"urn:ogc:def:crs:EPSG::25832\"", "srsName=\"" + srsNameProp + "\"");
        rawXML = rawXML.replaceAll(" srsName=\"urn:ogc:def:crs:EPSG::25832\"", "");
        return rawXML;
    }

    public static String writeGML3_2WithETRS89(GeometryCollection geometries) {
        String confluence = GML3Writer.convertToGML(geometries, "EPSG:25832", "urn:adv:crs:ETRS89_UTM32");
        return confluence;
    }
}

