/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.pointnumberreservation;

import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class PointNumberReservationRequest
implements Serializable {
    private static final Logger LOG = Logger.getLogger(PointNumberReservationRequest.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    private static final DateFormat DATE_PARSER = new SimpleDateFormat("yyyy-MM-dd");
    private String antragsnummer;
    private List<PointNumberReservation> pointNumbers = new ArrayList<PointNumberReservation>();
    private boolean successfull;
    private String protokoll;
    private List<String> errorMessages;
    private String rawResult;

    public String getRawResult() {
        return this.rawResult;
    }

    public void setRawResult(String rawResult) {
        this.rawResult = rawResult;
    }

    public String getAntragsnummer() {
        return this.antragsnummer;
    }

    public void setAntragsnummer(String antragsnummer) {
        this.antragsnummer = antragsnummer;
    }

    public List<PointNumberReservation> getPointNumbers() {
        return this.pointNumbers;
    }

    public void setPointNumbers(List<PointNumberReservation> pointNumbers) {
        this.pointNumbers = pointNumbers;
    }

    public void addPointNumberReservation(PointNumberReservation pnr) {
        this.pointNumbers.add(pnr);
    }

    public void setSuccessful(boolean wasSuccessFull) {
        this.successfull = wasSuccessFull;
    }

    public void setProtokoll(String protokoll) {
        this.protokoll = protokoll;
    }

    public boolean isSuccessfull() {
        return this.successfull;
    }

    public String getProtokoll() {
        return this.protokoll;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public String createTxtProtokoll() {
        StringBuilder contentBuilder = new StringBuilder();
        boolean isFreigabeMode = false;
        if (this.isSuccessfull() && this.getPointNumbers() != null) {
            for (PointNumberReservation pnr : this.getPointNumbers()) {
                if (pnr.getAblaufDatum() != null && !pnr.getAblaufDatum().isEmpty()) continue;
                isFreigabeMode = true;
                break;
            }
        }
        String header = "Antragsnummer: " + this.getAntragsnummer() + " erstellt am: ";
        GregorianCalendar cal = new GregorianCalendar();
        header = header + DATE_FORMAT.format(cal.getTime());
        header = header + " Anzahl ";
        header = isFreigabeMode ? header + "freigegebener" : header + "reservierter";
        header = header + " Punktnummern: " + this.getPointNumbers().size();
        contentBuilder.append(header);
        contentBuilder.append("\r\n");
        if (isFreigabeMode) {
            contentBuilder.append("freigegebene Punktnummern");
        } else {
            contentBuilder.append("reservierte Punktnummern (g\u00fcltig bis)");
        }
        contentBuilder.append("\r\n");
        contentBuilder.append("\r\n");
        for (PointNumberReservation pnr : this.getPointNumbers()) {
            contentBuilder.append(pnr.getPunktnummer());
            if (!isFreigabeMode) {
                contentBuilder.append(" (");
                try {
                    contentBuilder.append(DATE_FORMAT.format(DATE_PARSER.parse(pnr.getAblaufDatum())));
                }
                catch (ParseException ex) {
                    LOG.info((Object)"Could not parse the expiration date of a reservation. Using the string representation return by server");
                    contentBuilder.append(pnr.getAblaufDatum());
                }
                contentBuilder.append(")");
            }
            contentBuilder.append("\r\n");
        }
        return contentBuilder.toString();
    }
}

