/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vzkat;

import de.cismet.cids.dynamics.CidsBean;

public class VzkatUtils {
    public static final String ZEICHEN_TOSTRING_QUERY = "SELECT  vzkat_zeichen.*,  CASE WHEN vzkat_stvo.id IS NOT NULL THEN vzkat_stvo.name ELSE '?' END AS vzkat_stvo__name FROM  vzkat_zeichen  LEFT JOIN vzkat_stvo ON vzkat_zeichen.fk_stvo = vzkat_stvo.id %s ORDER BY schluessel ASC";
    public static final String ZEICHEN_TOSTRING_TEMPLATE = "%s (%s) - %s";
    public static final String[] ZEICHEN_TOSTRING_FIELDS = new String[]{"schluessel", "vzkat_stvo__name", "name"};

    public static String createZeichenToString(CidsBean cidsBean) {
        String name = (String)cidsBean.getProperty("name");
        String schluessel = (String)cidsBean.getProperty("schluessel");
        String stvoName = (String)cidsBean.getProperty("fk_stvo.name");
        return String.format(ZEICHEN_TOSTRING_TEMPLATE, schluessel, stvoName != null ? stvoName : "?", name);
    }

    public static String createSchildToString(CidsBean cidsBean) {
        String standort = VzkatUtils.createStandortToString((CidsBean)cidsBean.getProperty("fk_standort"));
        String richtung = (String)cidsBean.getProperty("fk_richtung.name");
        Integer position = (Integer)cidsBean.getProperty("reihenfolge");
        String zeichenSchluessel = (String)cidsBean.getProperty("fk_zeichen.schluessel");
        String stvoName = (String)cidsBean.getProperty("fk_zeichen.fk_stvo.name");
        return String.format("%s, %s %s, %s (%s)", standort, richtung, position, zeichenSchluessel, stvoName != null ? stvoName : "?");
    }

    public static String createStandortToString(CidsBean cidsBean) {
        String importId = "Standort " + String.valueOf(cidsBean.getProperty("import_id"));
        return importId;
    }

    public static String createZeichenKey(CidsBean cidsBean) {
        if (cidsBean != null) {
            return String.format("%s_%s", (String)cidsBean.getProperty("fk_stvo.schluessel"), (String)cidsBean.getProperty("schluessel"));
        }
        return null;
    }
}

