/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.StampedJasperReportServerAction;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class AlboVorgangExtReportServerAction
extends StampedJasperReportServerAction
implements ConnectionContextStore {
    public static final String TASK_NAME = "alboVorgangExtReport";
    private static final String QUERY = "select %s, %s from albo_erhebungsklasse where legende is true  order by schluessel";
    private static final String QUERY_WZ = "select %s, %s from albo_wirtschaftszweig_erhebungsklasse where legende is true order by schluessel";

    protected JasperReport getJasperReport() throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.ALBO_VORGANG_EXT_JASPER.getValue());
    }

    public Object execute(Object o, ServerActionParameter ... params) {
        try {
            byte[] imageBytes = null;
            if (params != null) {
                for (ServerActionParameter serverActionParameter : params) {
                    if (!serverActionParameter.getKey().equals(Parameter.MAP_IMAGE_BYTES.toString())) continue;
                    imageBytes = (byte[])serverActionParameter.getValue();
                }
            }
            MetaObjectNode vorgangMon = (MetaObjectNode)o;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
            if (imageBytes != null) {
                Throwable throwable = null;
                try (ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);){
                    parameters.put("MAP_IMAGE", ImageIO.read(bis));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            CidsBean bean = this.getMetaService().getMetaObject(this.getUser(), vorgangMon.getObjectId(), vorgangMon.getClassId(), this.getConnectionContext()).getBean();
            List list = bean.getBeanCollectionProperty("arr_flaechen");
            for (CidsBean tmpBean : new ArrayList(list)) {
                Boolean loeschen = (Boolean)tmpBean.getProperty("loeschen");
                if (loeschen == null || !loeschen.booleanValue()) continue;
                list.remove(tmpBean);
            }
            JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(bean));
            MetaClass erhebungsklasse = this.getMetaService().getClassByTableName(this.getUser(), "albo_erhebungsklasse", this.getConnectionContext());
            MetaObject[] allErhebungsklassen = this.getMetaService().getMetaObject(this.getUser(), String.format(QUERY, erhebungsklasse.getID(), erhebungsklasse.getPrimaryKey(), this.getConnectionContext()));
            ArrayList<CidsBean> erhebungsklassenBeans = new ArrayList<CidsBean>();
            for (MetaObject mo : allErhebungsklassen) {
                erhebungsklassenBeans.add(mo.getBean());
            }
            JRBeanCollectionDataSource dataSourceEk = new JRBeanCollectionDataSource(erhebungsklassenBeans);
            parameters.put("ERHEBUNGSKLASSEN", dataSourceEk);
            MetaClass erhebungsklasseWz = this.getMetaService().getClassByTableName(this.getUser(), "albo_wirtschaftszweig_erhebungsklasse", this.getConnectionContext());
            MetaObject[] allErhebungsklassenWz = this.getMetaService().getMetaObject(this.getUser(), String.format(QUERY_WZ, erhebungsklasseWz.getID(), erhebungsklasseWz.getPrimaryKey(), this.getConnectionContext()));
            ArrayList<CidsBean> erhebungsklassenWzBeans = new ArrayList<CidsBean>();
            for (MetaObject mo : allErhebungsklassenWz) {
                erhebungsklassenWzBeans.add(mo.getBean());
            }
            JRBeanCollectionDataSource dataSourceEkWz = new JRBeanCollectionDataSource(erhebungsklassenWzBeans);
            parameters.put("ERHEBUNGSKLASSEN_WZ", dataSourceEkWz);
            parameters.put("ERHEBUNGSKLASSEN_WZ_STRING", this.mo2String(allErhebungsklassenWz));
            parameters.put("ERHEBUNGSKLASSEN_STRING", this.mo2String(allErhebungsklassen));
            return ServerActionHelper.asyncByteArrayHelper((Object)this.generateReport(parameters, (JRDataSource)dataSource), (String)"vorgang.pdf");
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    private String mo2String(MetaObject[] schluessel) {
        StringBuilder sb = new StringBuilder();
        for (MetaObject tmp : schluessel) {
            CidsBean bean = tmp.getBean();
            sb.append(String.valueOf(bean.getProperty("schluessel"))).append(" = ").append(String.valueOf(bean.getProperty("name"))).append("\n");
        }
        return sb.toString();
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum Parameter {
        MAP_IMAGE_BYTES;

    }
}

