/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.StampedJasperReportServerAction;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.BaulastenPictureFinder;
import de.cismet.cids.custom.utils.alkis.BaulastenReportGenerator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.log4j.Logger;

public class BaulastenReportServerAction
extends StampedJasperReportServerAction
implements ConnectionContextStore,
UserAwareServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(BaulastenReportServerAction.class);
    public static final String TASK_NAME = "baulastenReport";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            Collection mons = null;
            String jobNumber = null;
            String projectName = null;
            BaulastenReportGenerator.Type type = null;
            String fertigungsVermerk = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.BAULASTEN_MONS.toString())) {
                        mons = (Collection)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.FERTIGUNGS_VERMERK.toString())) {
                        fertigungsVermerk = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.JOB_NUMBER.toString())) {
                        jobNumber = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.PROJECT_NAME.toString())) {
                        projectName = (String)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.TYPE.toString())) continue;
                    type = (BaulastenReportGenerator.Type)((Object)sap.getValue());
                }
            }
            ArrayList<CidsBean> baulstBeans = new ArrayList<CidsBean>();
            for (MetaObjectNode mon : mons) {
                CidsBean baulastBean = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext()).getBean();
                baulstBeans.add(baulastBean);
            }
            BaulastenReportGenerator generator = new BaulastenReportGenerator(BaulastenPictureFinder.getInstance());
            generator.generate(baulstBeans, type, jobNumber, projectName, fertigungsVermerk);
            JRDataSource dataSource = generator.getDataSource();
            Map parameters = generator.getParameters();
            parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
            return ServerActionHelper.asyncByteArrayHelper((Object)this.generateReport(parameters, dataSource), (String)"BaulastenReport.pdf");
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    protected JasperReport getJasperReport() throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.BAULASTEN_JASPER.getValue());
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        BAULASTEN_MONS,
        FERTIGUNGS_VERMERK,
        JOB_NUMBER,
        PROJECT_NAME,
        TYPE;

    }
}

