/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungHandler;
import de.cismet.cids.custom.utils.billing.BillingModus;
import de.cismet.cids.custom.utils.billing.BillingPrice;
import de.cismet.cids.custom.utils.billing.BillingProduct;
import de.cismet.cids.custom.utils.billing.BillingUsage;
import de.cismet.cids.custom.utils.billing.BillingUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import org.apache.log4j.Logger;

public class BerechtigungspruefungAnfrageServerAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(BerechtigungspruefungAnfrageServerAction.class);
    public static final String TASK_NAME = "berechtigungspruefungAnfrage";
    private User user = null;
    private MetaService metaService = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            String dateiname = null;
            String begruendung = null;
            String downloadinfoJson = null;
            String berechtigungsgrund = null;
            String abgeholt = null;
            String billingBerechnung = null;
            BillingPrice billingPrice = null;
            BillingModus billingModus = null;
            BillingProduct billingProduct = null;
            BillingUsage billingUsage = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(ParameterType.DATEINAME.toString())) {
                        dateiname = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.BEGRUENDUNG.toString())) {
                        begruendung = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.BERECHTIGUNGSGRUND.toString())) {
                        berechtigungsgrund = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.DOWNLOADINFO_JSON.toString())) {
                        downloadinfoJson = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.ABGEHOLT.toString())) {
                        abgeholt = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.BILLING_BERECHNUNG.toString())) {
                        billingBerechnung = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.BILLING_PRICE.toString())) {
                        billingPrice = (BillingPrice)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.BILLING_USAGE.toString())) {
                        billingUsage = (BillingUsage)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(ParameterType.BILLING_PRODUCT.toString())) {
                        billingProduct = (BillingProduct)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(ParameterType.BILLING_MODUS.toString())) continue;
                    billingModus = (BillingModus)sap.getValue();
                }
            }
            if (abgeholt != null) {
                BerechtigungspruefungHandler.getInstance().setMetaService(this.getMetaService());
                BerechtigungspruefungHandler.getInstance().closeAnfrage(abgeholt);
                return null;
            }
            byte[] data = (byte[])body;
            if (body != null && !(body instanceof byte[])) {
                throw new IllegalArgumentException("body has to be a byte array");
            }
            if (downloadinfoJson == null) {
                throw new IllegalArgumentException("aufruf enth\u00e4lt keine downloadinfo");
            }
            BerechtigungspruefungDownloadInfo downloadInfo = BerechtigungspruefungHandler.extractDownloadInfo(downloadinfoJson);
            BerechtigungspruefungHandler.getInstance().setMetaService(this.getMetaService());
            String schluessel = BerechtigungspruefungHandler.getInstance().createNewSchluessel(downloadInfo);
            String userKey = (String)this.user.getKey();
            CidsBean anfrageBean = BerechtigungspruefungHandler.getInstance().addNewAnfrage(userKey, schluessel, downloadInfo, berechtigungsgrund, begruendung, dateiname, data);
            if (downloadInfo instanceof BerechtigungspruefungBillingDownloadInfo) {
                BerechtigungspruefungBillingDownloadInfo billingDownloadInfo = (BerechtigungspruefungBillingDownloadInfo)downloadInfo;
                billingDownloadInfo.setAuftragsnummer(schluessel);
                CidsBean cb = BillingUtils.getInstance().createBilling(billingDownloadInfo.getProduktbezeichnung(), schluessel, "no.yet", billingBerechnung, billingModus, billingUsage, billingProduct, billingPrice, this.getUser(), this.getMetaService(), this.getConnectionContext());
                CidsBean persistedBillingBean = DomainServerImpl.getServerInstance().insertMetaObject(BerechtigungspruefungHandler.getInstance().getUser(), cb.getMetaObject(), this.getConnectionContext()).getBean();
                billingDownloadInfo.setBillingId(persistedBillingBean.getPrimaryKeyValue());
                anfrageBean.setProperty("downloadinfo_json", (Object)new ObjectMapper().writeValueAsString((Object)billingDownloadInfo));
                DomainServerImpl.getServerInstance().updateMetaObject(BerechtigungspruefungHandler.getInstance().getUser(), anfrageBean.getMetaObject(), this.getConnectionContext());
            }
            return schluessel;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while executing anfrage task", (Throwable)ex);
            return ex;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum ParameterType {
        ABGEHOLT,
        DATEINAME,
        BEGRUENDUNG,
        BERECHTIGUNGSGRUND,
        DOWNLOADINFO_JSON,
        BILLING_BERECHNUNG,
        BILLING_USAGE,
        BILLING_PRODUCT,
        BILLING_MODUS,
        BILLING_PRICE;

    }
}

