/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungHandler;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import org.apache.log4j.Logger;

public class BerechtigungspruefungFreigabeServerAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(BerechtigungspruefungFreigabeServerAction.class);
    public static final String TASK_NAME = "berechtigungspruefungFreigabe";
    public static final String MODUS_PRUEFUNG = "PRUEFUNG";
    public static final String MODUS_FREIGABE = "FREIGABE";
    public static final String MODUS_STORNO = "STORNO";
    private User user = null;
    private MetaService metaService = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            boolean pruefungsAbschluss;
            Boolean pruefStatus;
            String begruendung = null;
            String modus = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(ParameterType.KOMMENTAR.toString())) {
                        begruendung = (String)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(ParameterType.MODUS.toString())) continue;
                    modus = (String)sap.getValue();
                }
            }
            if (MODUS_PRUEFUNG.equals(modus)) {
                pruefStatus = null;
                pruefungsAbschluss = false;
            } else if (MODUS_FREIGABE.equals(modus)) {
                pruefStatus = true;
                pruefungsAbschluss = true;
            } else if (MODUS_STORNO.equals(modus)) {
                pruefStatus = false;
                pruefungsAbschluss = true;
            } else {
                throw new Exception("weder Freigabe noch Storno");
            }
            BerechtigungspruefungHandler.getInstance().setMetaService(this.getMetaService());
            BerechtigungspruefungFreigabeServerAction berechtigungspruefungFreigabeServerAction = this;
            synchronized (berechtigungspruefungFreigabeServerAction) {
                String schluessel = (String)body;
                String pruefer = this.getUser().getName();
                boolean already = BerechtigungspruefungHandler.getInstance().pruefung(schluessel, pruefer, pruefStatus, begruendung, pruefungsAbschluss);
                if (already) {
                    return ReturnType.ALREADY;
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while executing freigabe action", (Throwable)ex);
        }
        return ReturnType.OK;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum ReturnType {
        OK,
        PENDING,
        ALREADY;

    }

    public static enum ParameterType {
        MODUS,
        KOMMENTAR;

    }
}

