/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMauernSearchStatement;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class NasGetObjekteServerAction
implements ServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(CidsMauernSearchStatement.class);
    public static final String TASK_NAME = "nasGetObjekte";
    private static final String FLURSTUECK_STMT = "select gml_id from ax_flurstueck where st_intersects(wkb_geometry,<geom>)";
    private Connection fmeConn = null;
    private final String url;
    private final String user;
    private final String pw;
    private final boolean initError;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public NasGetObjekteServerAction() {
        boolean initError = false;
        String url = null;
        String user = null;
        String pw = null;
        try {
            if (DomainServerImpl.getServerProperties() != null && "WUNDA_BLAU".equals(DomainServerImpl.getServerProperties().getServerName())) {
                Properties serviceProperties = new Properties();
                serviceProperties.load(ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.FME_DB_CONN_PROPERTIES.getValue()));
                url = serviceProperties.getProperty("connection_url");
                user = serviceProperties.getProperty("connection_username");
                pw = serviceProperties.getProperty("connection_pw");
                this.initConnection();
            } else {
                initError = true;
            }
        }
        catch (SearchException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"error during initialisation of fme db connection.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            initError = true;
            LOG.warn((Object)"error during initialisation of fme db connection. Could not read properties file. Search disabled", (Throwable)ex);
        }
        this.initError = initError;
        this.url = url;
        this.user = user;
        this.pw = pw;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        Geometry geometry = null;
        Enum searchType = null;
        if (params != null) {
            for (ServerActionParameter sap : params) {
                if (sap.getKey().equals(Parameter.SEARCH_TYPE.toString())) {
                    searchType = (NasSearchType)((Object)sap.getValue());
                    continue;
                }
                if (!sap.getKey().equals(Parameter.GEOMETRY.toString())) continue;
                geometry = (Geometry)sap.getValue();
            }
        }
        if (this.initError) {
            LOG.warn((Object)"NasZaehlObjekteSearch initialisation error. An error during reading fme_db_con properties occured.");
            return null;
        }
        try {
            if (null != searchType) {
                switch (1.$SwitchMap$de$cismet$cids$custom$wunda_blau$search$actions$NasGetObjekteServerAction$NasSearchType[searchType.ordinal()]) {
                    case 1: {
                        return this.getFlurstueckObjects(geometry);
                    }
                }
            }
            return null;
        }
        catch (SearchException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    private String getFlurstueckObjects(Geometry geometry) throws SearchException {
        return this.getObjects(FLURSTUECK_STMT, geometry);
    }

    private synchronized String getObjects(String statement, Geometry geometry) throws SearchException {
        Statement st = null;
        try {
            if (this.fmeConn == null || this.fmeConn.isClosed()) {
                this.initConnection();
            }
            String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry);
            String finalStatement = statement.replace("<geom>", "st_buffer(st_GeometryFromText('" + geostring + "'), 0.000001)");
            st = this.fmeConn.createStatement();
            if (st != null && !this.fmeConn.isClosed() && !st.isClosed()) {
                st.execute(finalStatement);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + finalStatement));
                }
                ResultSet rs = st.getResultSet();
                StringBuffer result = null;
                while (rs.next()) {
                    if (result == null) {
                        result = new StringBuffer(rs.getString("gml_id"));
                        continue;
                    }
                    result.append(",").append(rs.getString("gml_id"));
                }
                String string = result == null ? null : result.toString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error during NasGetobjekteSearch", (Throwable)ex);
            throw new SearchException("Error during NasGetobjekteSearch");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initConnection() throws SearchException {
        try {
            this.fmeConn = DriverManager.getConnection(this.url, this.user, this.pw);
        }
        catch (SQLException ex) {
            throw new SearchException("Error during NasZaehlObjekte search.Could not create db connection to fme_import database", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum NasSearchType {
        FLURSTUECKE;

    }

    public static enum Parameter {
        GEOMETRY,
        SEARCH_TYPE;

    }
}

