/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.StampedJasperReportServerAction;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.VermessungsRissReportHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.utils.MultiPagePictureReader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class VermessungsrissReportServerAction
extends StampedJasperReportServerAction
implements ConnectionContextStore {
    public static final String TASK_NAME = "vermessungsrissReport";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        String jobNumber = null;
        String projectName = null;
        Collection reportMons = null;
        String host = null;
        try {
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.JOB_NUMBER.toString())) {
                        jobNumber = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.PROJECT_NAME.toString())) {
                        projectName = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.RISSE_MONS.toString())) {
                        reportMons = (Collection)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.HOST.toString())) continue;
                    host = (String)sap.getValue();
                }
            }
            if (reportMons != null) {
                ArrayList<CidsBean> selectedVermessungsrisse = new ArrayList<CidsBean>(reportMons.size());
                for (MetaObjectNode reportMon : reportMons) {
                    CidsBean bean = this.getMetaService().getMetaObject(this.getUser(), reportMon.getObjectId(), reportMon.getClassId(), this.getConnectionContext()).getBean();
                    selectedVermessungsrisse.add(bean);
                }
                Object[] tmp = new VermessungsRissReportHelper(this.getUser(), this.getMetaService(), this.getConnectionContext()).generateReportData(jobNumber, projectName, selectedVermessungsrisse, host, MultiPagePictureReader.class);
                Collection reportBeans = (Collection)tmp[0];
                Map parameters = (Map)tmp[1];
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(reportBeans);
                return ServerActionHelper.asyncByteArrayHelper((Object)this.generateReport(parameters, (JRDataSource)dataSource), (String)"VermessungsrissReport.pdf");
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    protected JasperReport getJasperReport() throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.VERMESSUNGSRISSE_JASPER.getValue());
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        JOB_NUMBER,
        PROJECT_NAME,
        RISSE_MONS,
        HOST;

    }
}

