/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class AdresseGebaeudeLightweightSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AdresseGebaeudeLightweightSearch.class);
    private final SearchInfo searchInfo;
    private String[] representationFields;
    private String representationPattern;
    private Integer gebaudeId;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public AdresseGebaeudeLightweightSearch() {
        this.searchInfo = new SearchInfo();
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("gebaeudeId");
        searchParameterInfo.setType(Type.INTEGER);
        searchParameterInfo.setArray(true);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("representationFields");
        searchParameterInfo.setType(Type.STRING);
        searchParameterInfo.setArray(true);
        parameterDescription.add(searchParameterInfo);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("representationPattern");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.ENTITY_REFERENCE);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaClass mc;
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        try {
            mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"alkis_adresse", (ConnectionContext)this.getConnectionContext());
        }
        catch (Exception ex) {
            throw new SearchException("error while loading metaclass", (Throwable)ex);
        }
        String query = "select id,strasse,nummer from alkis_adresse where gebaeude = " + this.getGebaudeId() + " order by strasse,nummer";
        try {
            if (this.getRepresentationPattern() != null) {
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern(), this.getConnectionContext()));
            }
            return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getConnectionContext()));
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public Integer getGebaudeId() {
        return this.gebaudeId;
    }

    public void setGebaudeId(Integer gebaudeId) {
        this.gebaudeId = gebaudeId;
    }
}

