/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.wunda_blau.search.server.AlboFlaecheErhebungsnummerSearch;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AlboFlaecheNummerUniqueSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlboFlaecheErhebungsnummerSearch.class);
    private static final String ERH_NR_QUERY = "SELECT id from albo_flaeche where id <> %1$s and erhebungsnummer = '%2$s'";
    private static final String GEO_NR_QUERY = "SELECT id from albo_flaeche where id <> %1$s and geodaten_id = '%2$s'";
    private final String nummer;
    private final Integer id;
    private final boolean checkErhebungsnummer;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public AlboFlaecheNummerUniqueSearch(String nummer, Integer id, boolean checkErhebungsnummer) {
        this.nummer = nummer;
        this.checkErhebungsnummer = checkErhebungsnummer;
        this.id = id;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                ArrayList nr = this.checkErhebungsnummer ? ms.performCustomSearch(String.format(ERH_NR_QUERY, this.id, this.nummer), this.getConnectionContext()) : ms.performCustomSearch(String.format(GEO_NR_QUERY, this.id, this.nummer), this.getConnectionContext());
                return nr;
            }
            catch (RemoteException ex) {
                LOG.error((Object)"Error while checking number", (Throwable)ex);
            }
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

