/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BPlanAPISearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BPlanAPISearch.class);
    private static final PreparableStatement QUERY = new PreparableStatement("select * from bplanapisearch(?,?,?,?)", new int[]{12, 12, 4, 12});
    private static final String DOMAIN = "WUNDA_BLAU";
    private final SearchInfo searchInfo;
    private String wktString;
    private String status;
    private Integer srs;
    private String urlprefix;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public BPlanAPISearch() {
        this.searchInfo = new SearchInfo();
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("BPlan Search to use in Geoportal 3");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo wktStringParameterInfo = new SearchParameterInfo();
        wktStringParameterInfo.setKey("wktString");
        wktStringParameterInfo.setType(Type.STRING);
        parameterDescription.add(wktStringParameterInfo);
        SearchParameterInfo statusParameterInfo = new SearchParameterInfo();
        statusParameterInfo.setKey("status");
        statusParameterInfo.setType(Type.STRING);
        parameterDescription.add(statusParameterInfo);
        SearchParameterInfo srsParameterInfo = new SearchParameterInfo();
        srsParameterInfo.setKey("srs");
        srsParameterInfo.setType(Type.INTEGER);
        parameterDescription.add(srsParameterInfo);
        SearchParameterInfo urlPrefixParameterInfo = new SearchParameterInfo();
        urlPrefixParameterInfo.setKey("urlprefix");
        urlPrefixParameterInfo.setType(Type.STRING);
        parameterDescription.add(urlPrefixParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.JAVA_CLASS);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        try {
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (this.status == null) {
                this.status = "";
            }
            if (metaService != null) {
                QUERY.setObjects(new Object[]{this.wktString, this.status, this.srs, this.urlprefix});
                ArrayList results = metaService.performCustomSearch(QUERY, this.getConnectionContext());
                return results;
            }
            LOG.error((Object)"active local server not found");
            return null;
        }
        catch (Exception ex) {
            throw new SearchException("error while loading verfahren objects", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getWktString() {
        return this.wktString;
    }

    public void setWktString(String wktString) {
        this.wktString = wktString;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getSrs() {
        return this.srs;
    }

    public void setSrs(Integer srs) {
        this.srs = srs;
    }

    public String getUrlprefix() {
        return this.urlprefix;
    }

    public void setUrlprefix(String urlprefix) {
        this.urlprefix = urlprefix;
    }
}

