/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.newuser.User;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BillingStatisticsReportServerSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BillingStatisticsReportServerSearch.class);
    public static final String BRANCHEN_AMOUNTS = "branchenAmounts";
    public static final String ANTRAEGE_AMOUNTS = "antraegeAmounts";
    public static final String DOWNLOADS_AMOUNTS = "downloadAmounts";
    public static final String KUNDEN_UMSATZ = "kundenUmsatz";
    public static final String PRODUKTE_COMMON_DOWNLOADS = "produkteCommonDownloads";
    public static final String PRODUKTE_DOWNLOADS = "produkteDownloads";
    public static final String PRODUKTE_EINNAHMEN = "produkteEinnahmen";
    public static final String EINNAHMEN = "einnahmen";
    private final String whereClause = "WHERE b.id IN ($bean_ids$) ";
    private final String fromBillingJoinTillKunde = "FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id ";
    private final String queryKundenBranche = "with tempTabel as (SELECT count(b.username), billing_branche.name FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) GROUP BY billing_branche.name,b.username ORDER BY billing_branche.name DESC) select count(name) as anzahl,name from tempTabel group by name order by anzahl desc;";
    private final String queryKundenAntraege = "with tempTable as ( select kunde.name,geschaeftsbuchnummer FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) group by kunde.name,geschaeftsbuchnummer order by kunde.name) select count(name) as Anzahl,name from tempTable group by name order by Anzahl desc limit 10;";
    private final String queryKundenAnzahlDownloads = "select count (*) as amount,kunde.name FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) group by kunde.name order by amount desc limit 10;";
    private final String queryKundenUmsatz = "select sum(netto_summe) as summe, kunde.name FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) group by kunde.name order by summe desc limit 10";
    private final String queryProdukteCommonDownloads = "select count(*) as anzahl, produktbezeichnung, produktkey         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktkey,produktbezeichnung order by anzahl  desc   limit 10;";
    private final String queryProdukteDownloads = "select count(*) as anzahl, produktbezeichnung, produktkey         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktkey,produktbezeichnung order by produktbezeichnung  asc;";
    private final String queryProdukteEinnahmen = "select sum(brutto_summe) as summe, produktbezeichnung, count(brutto_summe) as anzahlProdukte         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktbezeichnung order by summe  desc;";
    private final String queryEinnahmen = "select y.gesum,y.gesum/360*2 as minsum,z.produktbezeichnung,z.summe,z.anzahl from  (select sum(summe) as gesum from  (select produktbezeichnung,sum(brutto_summe) as summe,count(brutto_summe) as anzahl         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktbezeichnung) x) y, (select produktbezeichnung,sum(brutto_summe) as summe,count(brutto_summe) as anzahl         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktbezeichnung) z where z.summe > y.gesum/360*2 order by z.summe desc;";
    private final String billingBeanIds;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public BillingStatisticsReportServerSearch(String billingBeanIds) {
        this.billingBeanIds = billingBeanIds;
    }

    public BillingStatisticsReportServerSearch(User user, String billingBeanIds) {
        this(billingBeanIds);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                HashMap<String, ArrayList> results = new HashMap<String, ArrayList>();
                this.excuteQueryAndConvertResults(ms, results, "with tempTabel as (SELECT count(b.username), billing_branche.name FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) GROUP BY billing_branche.name,b.username ORDER BY billing_branche.name DESC) select count(name) as anzahl,name from tempTabel group by name order by anzahl desc;", BRANCHEN_AMOUNTS);
                this.excuteQueryAndConvertResults(ms, results, "with tempTable as ( select kunde.name,geschaeftsbuchnummer FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) group by kunde.name,geschaeftsbuchnummer order by kunde.name) select count(name) as Anzahl,name from tempTable group by name order by Anzahl desc limit 10;", ANTRAEGE_AMOUNTS);
                this.excuteQueryAndConvertResults(ms, results, "select count (*) as amount,kunde.name FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) group by kunde.name order by amount desc limit 10;", DOWNLOADS_AMOUNTS);
                this.excuteQueryAndConvertResults(ms, results, "select sum(netto_summe) as summe, kunde.name FROM billing_billing AS b JOIN billing_kunden_logins AS login ON b.angelegt_durch = login.id JOIN billing_kunde AS kunde ON login.kunde = kunde.id JOIN billing_branche ON kunde.branche = billing_branche.id WHERE b.id IN ($bean_ids$) group by kunde.name order by summe desc limit 10", KUNDEN_UMSATZ);
                this.excuteQueryAndConvertResults(ms, results, "select count(*) as anzahl, produktbezeichnung, produktkey         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktkey,produktbezeichnung order by anzahl  desc   limit 10;", PRODUKTE_COMMON_DOWNLOADS);
                this.excuteQueryAndConvertResults(ms, results, "select count(*) as anzahl, produktbezeichnung, produktkey         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktkey,produktbezeichnung order by produktbezeichnung  asc;", PRODUKTE_DOWNLOADS);
                this.excuteQueryAndConvertResults(ms, results, "select sum(brutto_summe) as summe, produktbezeichnung, count(brutto_summe) as anzahlProdukte         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktbezeichnung order by summe  desc;", PRODUKTE_EINNAHMEN);
                this.excuteEinnahmenQuery(ms, results);
                ArrayList<HashMap<String, ArrayList>> resultWrapper = new ArrayList<HashMap<String, ArrayList>>(1);
                resultWrapper.add(results);
                return resultWrapper;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return null;
    }

    private void excuteQueryAndConvertResults(MetaService ms, HashMap<String, ArrayList> results, String query, String key) throws RemoteException {
        ArrayList lists = ms.performCustomSearch(query.replace("$bean_ids$", this.billingBeanIds), this.getConnectionContext());
        if (lists != null && !lists.isEmpty()) {
            ArrayList<BrancheAmountBean> beans = new ArrayList<BrancheAmountBean>();
            for (ArrayList row : lists) {
                BrancheAmountBean bean = new BrancheAmountBean();
                bean.setNumber((Number)row.get(0));
                bean.setName((String)row.get(1));
                if (row.size() == 3) {
                    bean.setInfo(row.get(2));
                }
                beans.add(bean);
            }
            results.put(key, beans);
        }
    }

    private void excuteEinnahmenQuery(MetaService ms, HashMap<String, ArrayList> results) throws RemoteException {
        ArrayList lists = ms.performCustomSearch("select y.gesum,y.gesum/360*2 as minsum,z.produktbezeichnung,z.summe,z.anzahl from  (select sum(summe) as gesum from  (select produktbezeichnung,sum(brutto_summe) as summe,count(brutto_summe) as anzahl         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktbezeichnung) x) y, (select produktbezeichnung,sum(brutto_summe) as summe,count(brutto_summe) as anzahl         from                 billing_billing as b WHERE b.id IN ($bean_ids$) group by produktbezeichnung) z where z.summe > y.gesum/360*2 order by z.summe desc;".replace("$bean_ids$", this.billingBeanIds), this.getConnectionContext());
        if (lists != null && !lists.isEmpty()) {
            ArrayList<EinnahmenBean> beans = new ArrayList<EinnahmenBean>();
            for (ArrayList row : lists) {
                EinnahmenBean bean = new EinnahmenBean();
                bean.setGesum((Double)row.get(0));
                bean.setMinsum((Double)row.get(1));
                bean.setProduktbezeichnung((String)row.get(2));
                bean.setSumme((Double)row.get(3));
                bean.setAnzahl((Long)row.get(4));
                beans.add(bean);
            }
            results.put(EINNAHMEN, beans);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public class BrancheAmountBean
    implements Serializable {
        private Number number = 0L;
        private String name = "";
        private Object info = "";

        public Number getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public Object getInfo() {
            return this.info;
        }

        public void setNumber(Number number) {
            this.number = number;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setInfo(Object info) {
            this.info = info;
        }
    }

    public class EinnahmenBean
    implements Serializable {
        private Double gesum;
        private Double minsum;
        private Double summe;
        private String produktbezeichnung;
        private Long anzahl;

        public Double getGesum() {
            return this.gesum;
        }

        public Double getMinsum() {
            return this.minsum;
        }

        public Double getSumme() {
            return this.summe;
        }

        public String getProduktbezeichnung() {
            return this.produktbezeichnung;
        }

        public Long getAnzahl() {
            return this.anzahl;
        }

        public void setGesum(Double gesum) {
            this.gesum = gesum;
        }

        public void setMinsum(Double minsum) {
            this.minsum = minsum;
        }

        public void setSumme(Double summe) {
            this.summe = summe;
        }

        public void setProduktbezeichnung(String produktbezeichnung) {
            this.produktbezeichnung = produktbezeichnung;
        }

        public void setAnzahl(Long anzahl) {
            this.anzahl = anzahl;
        }
    }
}

