/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.custom.wunda_blau.search.server.StorableSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class CidsMauernSearchStatement
extends RestApiMonGeometrySearch
implements StorableSearch<Configuration> {
    private static final Logger LOG = Logger.getLogger(CidsMauernSearchStatement.class);
    private static final String SQL_STMT = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ilike 'mauer') as class_id, m.id AS object_id, m.lagebezeichnung as name FROM %s WHERE %s";
    private static final String JOIN_GEOM = "geom AS g ON m.georeferenz = g.id";
    private static final String JOIN_LASTKLASSE = "mauer_lastklasse AS l ON l.id = m.lastklasse";
    private static final String JOIN_EIGENTUEMER = "mauer_eigentuemer AS e ON e.id = m.eigentuemer";
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Configuration configuration;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsMauernSearchStatement() {
        this(new Configuration());
    }

    public CidsMauernSearchStatement(Configuration configuration) {
        this(configuration, null);
    }

    public CidsMauernSearchStatement(Configuration configuration, Geometry geom) {
        this.configuration = configuration;
        this.setGeometry(geom);
    }

    @Override
    public String getName() {
        return "mauer";
    }

    @Override
    public void setConfiguration(String configurationJson) throws Exception {
        this.setConfiguration((Configuration)this.getConfigurationMapper().readValue(configurationJson, Configuration.class));
    }

    @Override
    public ObjectMapper getConfigurationMapper() {
        return OBJECT_MAPPER;
    }

    @Override
    public String createQuery() {
        LinkedHashSet<String> joins = new LinkedHashSet<String>();
        LinkedHashSet<String> wheres = new LinkedHashSet<String>();
        Geometry geom = this.getGeometry();
        Configuration configuration = this.getConfiguration();
        SearchMode searchMode = configuration != null ? configuration.getSearchMode() : null;
        List<Integer> eigentuemer = configuration != null ? configuration.getEigentuemer() : null;
        List<Integer> lastKlasseIds = configuration != null ? configuration.getLastKlasseIds() : null;
        MassnahmenInfo massnahmen = configuration != null ? configuration.getMassnahmen() : null;
        ZustaendeInfo zustaende = configuration != null ? configuration.getZustaende() : null;
        Integer sanierung = configuration != null ? configuration.getSanierung() : null;
        joins.add("mauer AS m");
        if (geom != null) {
            joins.add(JOIN_GEOM);
            String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geom);
            ArrayList<String> conditions = new ArrayList<String>();
            conditions.add(String.format("g.geo_field && st_GeometryFromText('%s')", geostring));
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                conditions.add(String.format(" st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_buffer(st_GeometryFromText('%s'), " + INTERSECTS_BUFFER + "))", geostring));
            } else {
                conditions.add(String.format(" and st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_GeometryFromText('%s'))", geostring));
            }
            wheres.add(String.join((CharSequence)" AND ", conditions));
        }
        if (eigentuemer != null && !eigentuemer.isEmpty()) {
            joins.add(JOIN_EIGENTUEMER);
            wheres.add(String.format(" m.eigentuemer in (%s)", String.join((CharSequence)", ", eigentuemer.stream().map(new Function<Integer, String>(){

                @Override
                public String apply(Integer value) {
                    return value != null ? Integer.toString(value) : null;
                }
            }).collect(Collectors.toList()))));
        }
        if (lastKlasseIds != null && !lastKlasseIds.isEmpty()) {
            joins.add(JOIN_LASTKLASSE);
            wheres.add(String.format("m.lastklasse in (%s)", String.join((CharSequence)", ", lastKlasseIds.stream().map(new Function<Integer, String>(){

                @Override
                public String apply(Integer value) {
                    return value != null ? Integer.toString(value) : null;
                }
            }).collect(Collectors.toList()))));
        }
        if (massnahmen != null) {
            Boolean erledigt;
            Boolean erledigt2;
            Integer gewerk;
            Date bis;
            Date von;
            MassnahmeInfo massnahme;
            if (this.isNotAllNull(massnahmen.getErstePruefung())) {
                massnahme = massnahmen.getErstePruefung();
                wheres.add(CidsMauernSearchStatement.createWhereFor("m.datum_erste_pruefung", massnahme.getVon(), massnahme.getBis()));
            }
            if (this.isNotAllNull(massnahmen.getLetztePruefung())) {
                massnahme = massnahmen.getLetztePruefung();
                wheres.add(CidsMauernSearchStatement.createWhereFor("m.datum_letzte_pruefung", massnahme.getVon(), massnahme.getBis()));
            }
            if (this.isNotAllNull(massnahmen.getPruefung())) {
                massnahme = massnahmen.getPruefung();
                wheres.add(CidsMauernSearchStatement.createWhereFor("m.datum_naechste_pruefung", massnahme.getVon(), massnahme.getBis()));
            }
            if (this.isNotAllNull(massnahmen.getSanierungDurchgefuehrt())) {
                massnahme = massnahmen.getSanierungDurchgefuehrt();
                von = massnahme.getVon();
                bis = massnahme.getBis();
                gewerk = massnahme.getGewerk();
                erledigt2 = massnahme.getErledigt();
                joins.add("mauer_massnahme AS mm1 ON m.id = mm1.fk_mauer");
                joins.add("mauer_massnahme_art AS mma1 ON mm1.fk_art = mma1.id");
                wheres.add("mma1.schluessel LIKE 'durchgefuehrte_sanierung'");
                wheres.add(CidsMauernSearchStatement.createWhereFor("mm1.ziel", von, bis));
                wheres.add(gewerk != null ? String.format("mm1.fk_objekt = %d", gewerk) : null);
                wheres.add(erledigt2 != null ? (erledigt2.booleanValue() ? "mm1.erledigt IS TRUE" : "mm1.erledigt IS NOT TRUE") : null);
            }
            if (this.isNotAllNull(massnahmen.getSanierungGeplant())) {
                massnahme = massnahmen.getSanierungGeplant();
                von = massnahme.getVon();
                bis = massnahme.getBis();
                gewerk = massnahme.getGewerk();
                erledigt2 = massnahme.getErledigt();
                joins.add("mauer_massnahme AS mm2 ON m.id = mm2.fk_mauer");
                joins.add("mauer_massnahme_art AS mma2 ON mm2.fk_art = mma2.id");
                wheres.add("mma2.schluessel LIKE 'durchzufuehrende_sanierung'");
                wheres.add(CidsMauernSearchStatement.createWhereFor("mm2.ziel", von, bis));
                wheres.add(gewerk != null ? String.format("(mm2.fk_objekt = %d)", gewerk) : null);
                wheres.add(erledigt2 != null ? (erledigt2.booleanValue() ? "mm2.erledigt IS TRUE" : "mm2.erledigt IS NOT TRUE") : null);
            }
            if (this.isNotAllNull(massnahmen.getBauwerksbesichtigung())) {
                massnahme = massnahmen.getBauwerksbesichtigung();
                von = massnahme.getVon();
                bis = massnahme.getBis();
                erledigt = massnahme.getErledigt();
                joins.add("mauer_massnahme AS mm3 ON m.id = mm3.fk_mauer");
                joins.add("mauer_massnahme_art AS mma3 ON mm3.fk_art = mma3.id");
                wheres.add("mma3.schluessel LIKE 'bauwerksbesichtigung'");
                wheres.add(CidsMauernSearchStatement.createWhereFor("mm3.ziel", von, bis));
                wheres.add(erledigt != null ? (erledigt.booleanValue() ? "mm3.erledigt IS TRUE" : "mm3.erledigt IS NOT TRUE") : null);
            }
            if (this.isNotAllNull(massnahmen.getBauwerksbegehung())) {
                massnahme = massnahmen.getBauwerksbegehung();
                von = massnahme.getVon();
                bis = massnahme.getBis();
                erledigt = massnahme.getErledigt();
                joins.add("mauer_massnahme AS mm4 ON m.id = mm4.fk_mauer");
                joins.add("mauer_massnahme_art AS mma4 ON mm4.fk_art = mma4.id");
                wheres.add("mma4.schluessel LIKE 'bauwerksbegehung'");
                wheres.add(CidsMauernSearchStatement.createWhereFor("mm4.ziel", von, bis));
                wheres.add(erledigt != null ? (erledigt.booleanValue() ? "mm4.erledigt IS TRUE" : "mm4.erledigt IS NOT TRUE") : null);
            }
        }
        wheres.add(CidsMauernSearchStatement.createWhereFor("m.hoehe_max", configuration.getHoeheVon(), configuration.getHoeheBis()));
        if (zustaende != null) {
            if (this.isNotAllNull(zustaende.getGelaende())) {
                joins.add("mauer_zustand AS z_gelaende ON m.fk_zustand_gelaende = z_gelaende.id");
                wheres.add(CidsMauernSearchStatement.createWhereFor("z_gelaende.gesamt", zustaende.getGelaende().getVon(), zustaende.getGelaende().getBis()));
            }
            if (this.isNotAllNull(zustaende.getAnsicht())) {
                joins.add("mauer_zustand AS z_ansicht ON m.fk_zustand_ansicht = z_ansicht.id");
                wheres.add(CidsMauernSearchStatement.createWhereFor("z_ansicht.gesamt", zustaende.getAnsicht().getVon(), zustaende.getAnsicht().getBis()));
            }
            if (this.isNotAllNull(zustaende.getGelaender())) {
                joins.add("mauer_zustand AS z_gelaender ON m.fk_zustand_gelaender = z_gelaender.id");
                wheres.add(CidsMauernSearchStatement.createWhereFor("z_gelaender.gesamt", zustaende.getGelaender().getVon(), zustaende.getGelaender().getBis()));
            }
            if (this.isNotAllNull(zustaende.getWandkopf())) {
                joins.add("mauer_zustand AS z_kopf ON m.fk_zustand_kopf = z_kopf.id");
                wheres.add(CidsMauernSearchStatement.createWhereFor("z_kopf.gesamt", zustaende.getWandkopf().getVon(), zustaende.getWandkopf().getBis()));
            }
            if (this.isNotAllNull(zustaende.getGruendung())) {
                joins.add("mauer_zustand AS z_gruendung ON m.fk_zustand_gruendung = z_gruendung.id");
                wheres.add(CidsMauernSearchStatement.createWhereFor("z_gruendung.gesamt", zustaende.getGruendung().getVon(), zustaende.getGruendung().getBis()));
            }
            if (this.isNotAllNull(zustaende.getGelaendeOben())) {
                joins.add("mauer_zustand AS z_gelaende_oben ON m.fk_zustand_gelaende_oben = z_gelaende_oben.id");
                wheres.add(CidsMauernSearchStatement.createWhereFor("z_gelaende_oben.gesamt", zustaende.getGelaendeOben().getVon(), zustaende.getGelaendeOben().getBis()));
            }
            if (this.isNotAllNull(zustaende.getBausubstanz())) {
                wheres.add(CidsMauernSearchStatement.createWhereFor("(m.zustand_gesamt)", zustaende.getBausubstanz().getVon(), zustaende.getBausubstanz().getBis()));
            }
        }
        if (sanierung != null) {
            wheres.add(String.format("m.sanierung = %d", sanierung));
        }
        wheres.remove(null);
        String sql = String.format(SQL_STMT, String.join((CharSequence)" LEFT OUTER JOIN ", joins), wheres.isEmpty() ? "TRUE" : String.join((CharSequence)(searchMode == SearchMode.AND ? " AND " : " OR "), wheres));
        return sql;
    }

    private boolean isNotAllNull(ZustandInfo zustand) {
        return zustand != null && (zustand.getVon() != null || zustand.getBis() != null);
    }

    private boolean isNotAllNull(MassnahmeInfo massnahme) {
        return massnahme != null && (massnahme.getVon() != null || massnahme.getBis() != null || massnahme.getGewerk() != null || massnahme.getErledigt() != null);
    }

    @Override
    public void setConfiguration(Object searchConfiguration) {
        this.configuration = searchConfiguration instanceof Configuration ? (Configuration)searchConfiguration : null;
    }

    @Override
    public void setConfiguration(Configuration searchConfiguration) {
        this.configuration = searchConfiguration;
    }

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() throws SearchException {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService == null) {
                LOG.error((Object)"Could not retrieve MetaService 'WUNDA_BLAU'.");
                return result;
            }
            String query = this.createQuery();
            if (query == null) {
                return result;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Executing SQL statement '%s'.", query));
            }
            ArrayList resultset = metaService.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList mauer : resultset) {
                int classID = (Integer)mauer.get(0);
                int objectID = (Integer)mauer.get(1);
                String name = (String)mauer.get(2);
                MetaObjectNode node = new MetaObjectNode(DOMAIN, objectID, classID, name, null, null);
                result.add(node);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String createWhereFor(String property, Date von, Date bis) {
        ArrayList<String> conditions = new ArrayList<String>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (von != null) {
            conditions.add(String.format("%s >= '%s'", property, df.format(von)));
        }
        if (bis != null) {
            conditions.add(String.format("%s <= '%s'", property, df.format(bis)));
        }
        if (!conditions.isEmpty()) {
            return String.format("(%s)", String.join((CharSequence)" AND ", conditions));
        }
        return null;
    }

    private static String createWhereFor(String property, Double von, Double bis) {
        ArrayList<String> conditions = new ArrayList<String>();
        if (von != null) {
            conditions.add(String.format(Locale.US, "%s >= %f", property, von));
        }
        if (bis != null) {
            conditions.add(String.format(Locale.US, "%s <= %f", property, bis));
        }
        if (!conditions.isEmpty()) {
            return String.format(Locale.US, "(%s)", String.join((CharSequence)" AND ", conditions));
        }
        return null;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class MassnahmeInfo
    implements Serializable {
        @JsonProperty
        private Date von;
        @JsonProperty
        private Date bis;
        @JsonProperty
        private Integer gewerk;
        @JsonProperty
        private Boolean erledigt;

        public MassnahmeInfo(Date von, Date bis) {
            this.von = von;
            this.bis = bis;
        }

        public MassnahmeInfo(Date von, Date bis, Integer gewerk, Boolean erledigt) {
            this.von = von;
            this.bis = bis;
            this.gewerk = gewerk;
            this.erledigt = erledigt;
        }

        public Date getVon() {
            return this.von;
        }

        public Date getBis() {
            return this.bis;
        }

        public Integer getGewerk() {
            return this.gewerk;
        }

        public Boolean getErledigt() {
            return this.erledigt;
        }

        public void setVon(Date von) {
            this.von = von;
        }

        public void setBis(Date bis) {
            this.bis = bis;
        }

        public void setGewerk(Integer gewerk) {
            this.gewerk = gewerk;
        }

        public void setErledigt(Boolean erledigt) {
            this.erledigt = erledigt;
        }

        public MassnahmeInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class MassnahmenInfo
    implements Serializable {
        @JsonProperty
        private MassnahmeInfo erstePruefung;
        @JsonProperty
        private MassnahmeInfo letztePruefung;
        @JsonProperty
        private MassnahmeInfo pruefung;
        @JsonProperty
        private MassnahmeInfo sanierungDurchgefuehrt;
        @JsonProperty
        private MassnahmeInfo sanierungGeplant;
        @JsonProperty
        private MassnahmeInfo bauwerksbegehung;
        @JsonProperty
        private MassnahmeInfo bauwerksbesichtigung;

        public MassnahmeInfo getErstePruefung() {
            return this.erstePruefung;
        }

        public MassnahmeInfo getLetztePruefung() {
            return this.letztePruefung;
        }

        public MassnahmeInfo getPruefung() {
            return this.pruefung;
        }

        public MassnahmeInfo getSanierungDurchgefuehrt() {
            return this.sanierungDurchgefuehrt;
        }

        public MassnahmeInfo getSanierungGeplant() {
            return this.sanierungGeplant;
        }

        public MassnahmeInfo getBauwerksbegehung() {
            return this.bauwerksbegehung;
        }

        public MassnahmeInfo getBauwerksbesichtigung() {
            return this.bauwerksbesichtigung;
        }

        public void setErstePruefung(MassnahmeInfo erstePruefung) {
            this.erstePruefung = erstePruefung;
        }

        public void setLetztePruefung(MassnahmeInfo letztePruefung) {
            this.letztePruefung = letztePruefung;
        }

        public void setPruefung(MassnahmeInfo pruefung) {
            this.pruefung = pruefung;
        }

        public void setSanierungDurchgefuehrt(MassnahmeInfo sanierungDurchgefuehrt) {
            this.sanierungDurchgefuehrt = sanierungDurchgefuehrt;
        }

        public void setSanierungGeplant(MassnahmeInfo sanierungGeplant) {
            this.sanierungGeplant = sanierungGeplant;
        }

        public void setBauwerksbegehung(MassnahmeInfo bauwerksbegehung) {
            this.bauwerksbegehung = bauwerksbegehung;
        }

        public void setBauwerksbesichtigung(MassnahmeInfo bauwerksbesichtigung) {
            this.bauwerksbesichtigung = bauwerksbesichtigung;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ZustandInfo
    implements Serializable {
        @JsonProperty
        private Double von;
        @JsonProperty
        private Double bis;

        public ZustandInfo(Double von, Double bis) {
            this.von = von;
            this.bis = bis;
        }

        public Double getVon() {
            return this.von;
        }

        public Double getBis() {
            return this.bis;
        }

        public void setVon(Double von) {
            this.von = von;
        }

        public void setBis(Double bis) {
            this.bis = bis;
        }

        public ZustandInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ZustaendeInfo
    implements Serializable {
        @JsonProperty
        private ZustandInfo gelaender;
        @JsonProperty
        private ZustandInfo ansicht;
        @JsonProperty
        private ZustandInfo wandkopf;
        @JsonProperty
        private ZustandInfo gruendung;
        @JsonProperty
        private ZustandInfo gelaendeOben;
        @JsonProperty
        private ZustandInfo gelaende;
        @JsonProperty
        private ZustandInfo bausubstanz;

        public ZustandInfo getGelaender() {
            return this.gelaender;
        }

        public ZustandInfo getAnsicht() {
            return this.ansicht;
        }

        public ZustandInfo getWandkopf() {
            return this.wandkopf;
        }

        public ZustandInfo getGruendung() {
            return this.gruendung;
        }

        public ZustandInfo getGelaendeOben() {
            return this.gelaendeOben;
        }

        public ZustandInfo getGelaende() {
            return this.gelaende;
        }

        public ZustandInfo getBausubstanz() {
            return this.bausubstanz;
        }

        public void setGelaender(ZustandInfo gelaender) {
            this.gelaender = gelaender;
        }

        public void setAnsicht(ZustandInfo ansicht) {
            this.ansicht = ansicht;
        }

        public void setWandkopf(ZustandInfo wandkopf) {
            this.wandkopf = wandkopf;
        }

        public void setGruendung(ZustandInfo gruendung) {
            this.gruendung = gruendung;
        }

        public void setGelaendeOben(ZustandInfo gelaendeOben) {
            this.gelaendeOben = gelaendeOben;
        }

        public void setGelaende(ZustandInfo gelaende) {
            this.gelaende = gelaende;
        }

        public void setBausubstanz(ZustandInfo bausubstanz) {
            this.bausubstanz = bausubstanz;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Configuration
    implements StorableSearch.Configuration {
        @JsonProperty
        private SearchMode searchMode = SearchMode.AND;
        @JsonProperty
        private List<Integer> eigentuemer = new ArrayList<Integer>();
        @JsonProperty
        private List<Integer> lastKlasseIds = new ArrayList<Integer>();
        @JsonProperty
        private ZustaendeInfo zustaende = new ZustaendeInfo();
        @JsonProperty
        private MassnahmenInfo massnahmen = new MassnahmenInfo();
        @JsonProperty
        private Integer sanierung;
        @JsonProperty
        private Double hoeheVon;
        @JsonProperty
        private Double hoeheBis;

        public SearchMode getSearchMode() {
            return this.searchMode;
        }

        public List<Integer> getEigentuemer() {
            return this.eigentuemer;
        }

        public List<Integer> getLastKlasseIds() {
            return this.lastKlasseIds;
        }

        public ZustaendeInfo getZustaende() {
            return this.zustaende;
        }

        public MassnahmenInfo getMassnahmen() {
            return this.massnahmen;
        }

        public Integer getSanierung() {
            return this.sanierung;
        }

        public Double getHoeheVon() {
            return this.hoeheVon;
        }

        public Double getHoeheBis() {
            return this.hoeheBis;
        }

        public void setSearchMode(SearchMode searchMode) {
            this.searchMode = searchMode;
        }

        public void setEigentuemer(List<Integer> eigentuemer) {
            this.eigentuemer = eigentuemer;
        }

        public void setLastKlasseIds(List<Integer> lastKlasseIds) {
            this.lastKlasseIds = lastKlasseIds;
        }

        public void setZustaende(ZustaendeInfo zustaende) {
            this.zustaende = zustaende;
        }

        public void setMassnahmen(MassnahmenInfo massnahmen) {
            this.massnahmen = massnahmen;
        }

        public void setSanierung(Integer sanierung) {
            this.sanierung = sanierung;
        }

        public void setHoeheVon(Double hoeheVon) {
            this.hoeheVon = hoeheVon;
        }

        public void setHoeheBis(Double hoeheBis) {
            this.hoeheBis = hoeheBis;
        }
    }

    public static enum SearchMode {
        AND,
        OR;

    }
}

