/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class NextNumberSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(NextNumberSearch.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo;
    private Collection<String> where = new ArrayList<String>();
    private String table;
    private String representationPattern;
    private String[] representationFields;

    public NextNumberSearch() {
        this.searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("id", Type.INTEGER), new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    }

    public NextNumberSearch(String representationPattern, String[] representationFields, Collection<String> where, String table) {
        this();
        this.setRepresentationPattern(representationPattern);
        this.setRepresentationFields(representationFields);
        this.setTable(table);
        this.setWhere(where);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (this.representationFields != null) {
            fields.addAll(Arrays.asList(this.representationFields));
        }
        String query = "SELECT (SELECT c.id FROM cs_class c WHERE table_name ILIKE '" + this.table + "') AS class_id, id" + (fields.isEmpty() ? "" : ", " + String.join((CharSequence)", ", fields)) + " FROM " + this.table + (this.where.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", this.where));
        try {
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)this.table, (ConnectionContext)this.getConnectionContext());
            ArrayList resultList = metaService.performCustomSearch(query, this.getConnectionContext());
            return resultList;
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Collection<String> getWhere() {
        return this.where;
    }

    public void setWhere(Collection<String> where) {
        this.where = where;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }
}

