/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.ActionService;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.actions.PotenzialflaecheReportServerAction;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.custom.wunda_blau.search.server.StorableSearch;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PotenzialflaecheSearch
extends RestApiMonGeometrySearch
implements StorableSearch<Configuration> {
    private static final transient Logger LOG = Logger.getLogger(PotenzialflaecheSearch.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Configuration configuration;
    private final boolean monSearch;

    public PotenzialflaecheSearch() {
        this.initBuffer();
        this.monSearch = false;
        this.setSearchInfo(new SearchInfo(this.getClass().getName(), this.getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation PotenzialflaecheSearchStatement to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("filters", Type.UNDEFINED)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true)));
    }

    public PotenzialflaecheSearch(boolean monSearch) {
        this.initBuffer();
        this.monSearch = true;
        this.setSearchInfo(null);
    }

    public PotenzialflaecheSearch(Configuration searchConfiguration, Geometry geom) {
        this(true);
        this.configuration = searchConfiguration;
        this.setGeometry(geom);
    }

    @Override
    public String getName() {
        return "pf_potenzialflaeche";
    }

    private void initBuffer() {
        String searchPropBuffer = SearchProperties.getInstance().getIntersectsBuffer();
        if (searchPropBuffer != null) {
            try {
                this.setBuffer(Double.parseDouble(searchPropBuffer));
            }
            catch (Exception ex) {
                LOG.warn((Object)String.format("could not set buffer to %s", searchPropBuffer), (Throwable)ex);
            }
        }
    }

    public Collection performServerSearch() {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            Properties properties = new Properties();
            ActionService as = (ActionService)this.getActiveLocalServers().get("WUNDA_BLAU");
            properties.load(new StringReader((String)as.executeTask(this.getUser(), "getServerResource", (Object)WundaBlauServerResources.POTENZIALFLAECHEN_PROPERTIES.getValue(), this.getConnectionContext(), new ServerActionParameter[0])));
            String query = this.createQuery();
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    if (this.isMonSearch()) {
                        result.add(new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null));
                        continue;
                    }
                    result.add(new LightweightMetaObject(cid, oid, "WUNDA_BLAU", this.getUser()));
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for potenzialflaeche", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String createQuery() {
        String where;
        LinkedHashSet<String> leftJoins = new LinkedHashSet<String>();
        LinkedHashSet<String> wheresMain = new LinkedHashSet<String>();
        leftJoins.add("geom ON pf_potenzialflaeche.geometrie = geom.id");
        leftJoins.add("pf_restriktionen ON pf_potenzialflaeche.id = pf_restriktionen.pf_potenzialflaeche_reference");
        leftJoins.add("pf_brachflaechen ON pf_potenzialflaeche.id = pf_brachflaechen.pf_potenzialflaeche_reference");
        leftJoins.add("pf_potenzialflaechen_umgebungsnutzung ON pf_potenzialflaeche.id = pf_potenzialflaechen_umgebungsnutzung.pf_potenzialflaeche_reference");
        leftJoins.add("pf_empfohlene_nutzungen_wohnen ON pf_potenzialflaeche.id = pf_empfohlene_nutzungen_wohnen.pf_potenzialflaeche_reference");
        leftJoins.add("pf_potenzialflaechen_pf_regionalplan ON pf_potenzialflaeche.id = pf_potenzialflaechen_pf_regionalplan.pf_potenzialflaeche_reference");
        leftJoins.add("pf_naehen_zu ON pf_potenzialflaeche.id = pf_naehen_zu.pf_potenzialflaeche_reference");
        leftJoins.add("pf_potenzialflaechen_bisherige_nutzung ON pf_potenzialflaeche.id = pf_potenzialflaechen_bisherige_nutzung.pf_potenzialflaeche_reference");
        leftJoins.add("pf_eigentuemer_arr ON pf_potenzialflaeche.id = pf_eigentuemer_arr.pf_potenzialflaeche_reference");
        leftJoins.add("pf_empfohlene_nutzungen ON pf_potenzialflaeche.id = pf_empfohlene_nutzungen.pf_potenzialflaeche_reference");
        leftJoins.add("pf_kampagne ON pf_potenzialflaeche.kampagne = pf_kampagne.id");
        leftJoins.add("pf_entwicklungsaussichten ON pf_potenzialflaeche.fk_entwicklungsaussichten = pf_entwicklungsaussichten.id");
        leftJoins.add("pf_baulueckenart ON pf_potenzialflaeche.fk_baulueckenart = pf_baulueckenart.id");
        leftJoins.add("pf_handlungsprioritaet ON pf_potenzialflaeche.fk_handlungsprioritaet = pf_handlungsprioritaet.id");
        leftJoins.add("pf_verwertbarkeit ON pf_potenzialflaeche.fk_verwertbarkeit = pf_verwertbarkeit.id");
        leftJoins.add("pf_wohneinheiten ON pf_potenzialflaeche.fk_wohneinheiten = pf_wohneinheiten.id");
        leftJoins.add("pf_entwicklungsstand ON pf_potenzialflaeche.fk_entwicklungsstand = pf_entwicklungsstand.id");
        leftJoins.add("pf_aktivierbarkeit ON pf_potenzialflaeche.aktivierbarkeit = pf_aktivierbarkeit.id");
        leftJoins.add("pf_ausrichtung ON pf_potenzialflaeche.fk_ausrichtung = pf_ausrichtung.id");
        leftJoins.add("pf_oepnv ON pf_potenzialflaeche.fk_oepnv = pf_oepnv.id");
        leftJoins.add("pf_handlungsdruck ON pf_potenzialflaeche.handlungsdruck = pf_handlungsdruck.id");
        leftJoins.add("pf_verfuegbarkeit ON pf_potenzialflaeche.verfuegbarkeit = pf_verfuegbarkeit.id");
        leftJoins.add("pf_topografie ON pf_potenzialflaeche.topografie = pf_topografie.id");
        leftJoins.add("pf_aeussere_erschliessung ON pf_potenzialflaeche.fk_aeussere_erschliessung = pf_aeussere_erschliessung.id");
        leftJoins.add("pf_revitalisierung ON pf_potenzialflaeche.fk_revitalisierung = pf_revitalisierung.id");
        leftJoins.add("pf_siedlungsraeumliche_lage ON pf_potenzialflaeche.fk_siedlungsraeumliche_lage = pf_siedlungsraeumliche_lage.id");
        leftJoins.add("pf_lagebewertung_verkehr ON pf_potenzialflaeche.fk_lagebewertung_verkehr = pf_lagebewertung_verkehr.id");
        leftJoins.add("pf_potenzialart ON pf_potenzialflaeche.fk_potenzialart = pf_potenzialart.id");
        leftJoins.add("pf_versiegelung ON pf_potenzialflaeche.fk_versiegelung = pf_versiegelung.id");
        leftJoins.add("pf_bauordnungsrecht_baulast ON pf_potenzialflaeche.fk_bauordnungsrecht_baulast = pf_bauordnungsrecht_baulast.id");
        leftJoins.add("pf_bauordnungsrecht_genehmigung ON pf_potenzialflaeche.fk_bauordnungsrecht_genehmigung = pf_bauordnungsrecht_genehmigung.id");
        leftJoins.add("pf_klimainformationen ON pf_potenzialflaeche.fk_klimainformationen = pf_klimainformationen.id");
        leftJoins.add("pf_veroeffentlichkeitsstatus ON pf_kampagne.veroeffentlichkeitsstatus = pf_veroeffentlichkeitsstatus.id");
        leftJoins.add("pf_nutzung AS bisherige_nutzung ON pf_potenzialflaechen_bisherige_nutzung.nutzung = bisherige_nutzung.id");
        leftJoins.add("pf_nutzung AS umgebungs_nutzung ON pf_potenzialflaechen_umgebungsnutzung.nutzung = umgebungs_nutzung.id");
        leftJoins.add("pf_regionalplan ON pf_potenzialflaechen_pf_regionalplan.regionalplan = pf_regionalplan.id");
        leftJoins.add("pf_restriktion ON pf_restriktionen.fk_restriktion = pf_restriktion.id");
        leftJoins.add("pf_empfohlene_nutzung ON pf_empfohlene_nutzungen.fk_empfohlene_nutzung = pf_empfohlene_nutzung.id");
        leftJoins.add("pf_brachflaeche ON pf_brachflaechen.fk_brachflaeche = pf_brachflaeche.id");
        leftJoins.add("pf_eigentuemer ON pf_eigentuemer_arr.fk_eigentuemer = pf_eigentuemer.id");
        leftJoins.add("pf_empfohlene_nutzung_wohnen ON pf_empfohlene_nutzungen_wohnen.fk_empfohlene_nutzung_wohnen = pf_empfohlene_nutzung_wohnen.id");
        leftJoins.add("pf_naehe_zu ON pf_naehen_zu.fk_naehe_zu = pf_naehe_zu.id");
        SearchMode searchMode = SearchMode.AND;
        if (this.getConfiguration() != null && this.getConfiguration().getFilters() != null) {
            searchMode = this.getConfiguration().getSearchMode();
            for (FilterInfo filterInfo : this.getConfiguration().getFilters()) {
                if (filterInfo == null) continue;
                Object value = filterInfo.getValue();
                PotenzialflaecheReportServerAction.Property property = filterInfo.getProperty();
                if (property == null) continue;
                if (PotenzialflaecheReportServerAction.Property.GROESSE.equals((Object)property)) {
                    if (value instanceof Date) {
                        wheresMain.add(String.format("st_area(geom.geo_field) = %s", Double.toString((Double)value)));
                        continue;
                    }
                    if (!(value instanceof Double[])) continue;
                    Double[] doubles = (Double[])value;
                    String conditionFrom = doubles[0] != null ? String.format(Locale.US, "st_area(geom.geo_field) >= %f", doubles[0]) : "TRUE";
                    String conditionTo = doubles[1] != null ? String.format(Locale.US, "st_area(geom.geo_field) <= %f", doubles[1]) : "TRUE";
                    wheresMain.add(String.format("(%s AND %s)", conditionFrom, conditionTo));
                    continue;
                }
                if (property.getValue() instanceof PotenzialflaecheReportServerAction.PathReportProperty) {
                    PotenzialflaecheReportServerAction.PathReportProperty pathProp = (PotenzialflaecheReportServerAction.PathReportProperty)property.getValue();
                    String path = String.format("pf_potenzialflaeche.%s", pathProp.getPath());
                    if (value != null) {
                        PotenzialflaecheReportServerAction.ReportProperty reportProperty = property.getValue();
                        if (reportProperty instanceof PotenzialflaecheReportServerAction.SimpleFieldReportProperty) {
                            String conditionTo;
                            Object conditionFrom;
                            String className = ((PotenzialflaecheReportServerAction.SimpleFieldReportProperty)reportProperty).getClassName();
                            if (String.class.getCanonicalName().equals(className)) {
                                wheresMain.add(String.format("%s LIKE '%%%s%%'", path, value));
                                continue;
                            }
                            if (Integer.class.getCanonicalName().equals(className)) {
                                if (value instanceof Integer) {
                                    wheresMain.add(String.format("%s = %d", path, (Integer)value));
                                    continue;
                                }
                                if (!(value instanceof Integer[])) continue;
                                Integer[] integers = (Integer[])value;
                                conditionFrom = integers[0] != null ? String.format("%s >= %d", path, integers[0]) : "TRUE";
                                conditionTo = integers[1] != null ? String.format("%s <= %d", path, integers[1]) : "TRUE";
                                wheresMain.add(String.format("(%s AND %s)", conditionFrom, conditionTo));
                                continue;
                            }
                            if (Date.class.getCanonicalName().equals(className)) {
                                if (value instanceof Date) {
                                    wheresMain.add(String.format("%s = '%s'", path, new SimpleDateFormat("yyyy-MM-dd").format((Date)value)));
                                    continue;
                                }
                                if (!(value instanceof Date[])) continue;
                                Date[] dates = (Date[])value;
                                conditionFrom = dates[0] != null ? String.format("%s >= '%s'", path, new SimpleDateFormat("yyyy-MM-dd").format(dates[0])) : "TRUE";
                                conditionTo = dates[1] != null ? String.format("%s <= '%s'", path, new SimpleDateFormat("yyyy-MM-dd").format(dates[1])) : "TRUE";
                                wheresMain.add(String.format("(%s AND %s)", conditionFrom, conditionTo));
                                continue;
                            }
                            wheresMain.add(String.format("%s = %s", path, String.valueOf(value)));
                            continue;
                        }
                        if (reportProperty instanceof PotenzialflaecheReportServerAction.MultiKeytableReportProperty) {
                            PotenzialflaecheReportServerAction.MultiKeytableReportProperty mkrp = (PotenzialflaecheReportServerAction.MultiKeytableReportProperty)reportProperty;
                            if (value instanceof Collection) {
                                ArrayList<String> ids = new ArrayList<String>();
                                for (MetaObjectNode mon : (Collection)value) {
                                    ids.add(String.valueOf(mon.getObjectId()));
                                }
                                wheresMain.add(String.format("%s IN (%s)", mkrp.getFilterPath(), String.join((CharSequence)",", ids)));
                                continue;
                            }
                            wheresMain.add(String.format("%s = %d", mkrp.getFilterPath(), ((MetaObjectNode)value).getObjectId()));
                            continue;
                        }
                        if (!(reportProperty instanceof PotenzialflaecheReportServerAction.KeytableReportProperty)) continue;
                        if (value instanceof Collection) {
                            ArrayList<String> ids = new ArrayList<String>();
                            for (MetaObjectNode mon : (Collection)value) {
                                ids.add(String.valueOf(mon.getObjectId()));
                            }
                            wheresMain.add(String.format("%s IN (%s)", path, String.join((CharSequence)",", ids)));
                            continue;
                        }
                        wheresMain.add(String.format("%s = %d", path, ((MetaObjectNode)value).getObjectId()));
                        continue;
                    }
                    wheresMain.add(String.format("%s IS NULL", path, value));
                    continue;
                }
                if (!(property.getValue() instanceof PotenzialflaecheReportServerAction.MonSearchReportProperty)) continue;
                String subject = null;
                switch (property) {
                    case WOHNLAGEN: {
                        subject = "wohnlage_kategorie.id";
                        leftJoins.add("( SELECT wohnlage_kategorie.id, sub_geom.geo_field FROM wohnlage_flaeche LEFT JOIN geom sub_geom ON sub_geom.id = wohnlage_flaeche.fk_geom LEFT JOIN wohnlage_kategorie ON wohnlage_kategorie.id = wohnlage_flaeche.fk_wohnlage_kategorie ) wohnlage_kategorie ON wohnlage_kategorie.geo_field && geom.geo_field AND st_intersects(wohnlage_kategorie.geo_field, geom.geo_field)");
                        break;
                    }
                    case STADTRAUMTYPEN: {
                        subject = "srt_kategorie.id";
                        leftJoins.add("( SELECT srt_kategorie.id, sub_geom.geo_field FROM srt_kategorie LEFT JOIN srt_flaeche ON srt_flaeche.fk_kategorie = srt_kategorie.id LEFT JOIN geom sub_geom ON sub_geom.id = srt_flaeche.fk_geom ) srt_kategorie ON srt_kategorie.geo_field && geom.geo_field AND st_intersects(srt_kategorie.geo_field, geom.geo_field)");
                        break;
                    }
                    case QUARTIER: {
                        subject = "kst_quartier.id";
                        leftJoins.add("( SELECT kst_quartier.id, sub_geom.geo_field FROM kst_quartier LEFT JOIN geom sub_geom ON sub_geom.id = kst_quartier.georeferenz ) kst_quartier ON kst_quartier.geo_field && geom.geo_field AND st_intersects(kst_quartier.geo_field, geom.geo_field)");
                        break;
                    }
                    case STADTBEZIRK: {
                        subject = "kst_stadtbezirk.id";
                        leftJoins.add("( SELECT kst_stadtbezirk.id, sub_geom.geo_field FROM kst_stadtbezirk LEFT JOIN geom sub_geom ON sub_geom.id = kst_stadtbezirk.georeferenz ) kst_stadtbezirk ON kst_stadtbezirk.geo_field && geom.geo_field AND st_intersects(kst_stadtbezirk.geo_field, geom.geo_field)");
                        break;
                    }
                    case FLAECHENNUTZUNGSPLAN: {
                        subject = "fnp_hn_kategorie.id";
                        leftJoins.add("( SELECT fnp_hn_kategorie.id, sub_geom.geo_field FROM fnp_hn_kategorie LEFT JOIN fnp_hn_flaeche ON fnp_hn_flaeche.fk_fnp_hn_kategorie = fnp_hn_kategorie.id LEFT JOIN geom sub_geom ON sub_geom.id = fnp_hn_flaeche.fk_geom) fnp_hn_kategorie ON fnp_hn_kategorie.geo_field && geom.geo_field AND st_intersects(fnp_hn_kategorie.geo_field, geom.geo_field)");
                        break;
                    }
                    case REGIONALPLAN: {
                        subject = "rpd_kategorie.id";
                        leftJoins.add("( SELECT rpd_kategorie.id, sub_geom.geo_field FROM rpd_flaeche LEFT JOIN rpd_kategorie ON rpd_flaeche.fk_kategorie = rpd_kategorie.id LEFT JOIN geom sub_geom ON sub_geom.id = rpd_flaeche.fk_geom ) rpd_kategorie ON rpd_kategorie.geo_field && geom.geo_field AND st_intersects(rpd_kategorie.geo_field, geom.geo_field)");
                    }
                }
                if (value instanceof Collection) {
                    ArrayList<String> subWheres = new ArrayList<String>();
                    for (MetaObjectNode mon : (Collection)value) {
                        subWheres.add(String.format("%s = %d", subject, mon.getObjectId()));
                    }
                    wheresMain.add(String.format("(%s)", String.join((CharSequence)" OR ", subWheres)));
                    continue;
                }
                if (!(value instanceof MetaObjectNode)) continue;
                wheresMain.add(String.format("%s = %d", subject, ((MetaObjectNode)value).getObjectId()));
            }
        }
        switch (searchMode) {
            case AND: {
                where = !wheresMain.isEmpty() ? String.join((CharSequence)" AND ", wheresMain) : "TRUE";
                break;
            }
            case OR: {
                where = !wheresMain.isEmpty() ? String.join((CharSequence)" OR ", wheresMain) : "FALSE";
                break;
            }
            default: {
                where = "TRUE";
            }
        }
        String geomCondition = this.getGeomCondition();
        if (geomCondition != null) {
            wheresMain.add(geomCondition);
        }
        String select = String.format("DISTINCT %s AS class_id, %s AS object_id, %s AS object_name", "(SELECT id FROM cs_class WHERE table_name ILIKE 'pf_potenzialflaeche')", "pf_potenzialflaeche.id", "pf_potenzialflaeche.bezeichnung");
        String from = String.format("pf_potenzialflaeche %s", !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "");
        String whereWithGeomCondition = String.format("(%s) AND %s", where, geomCondition != null ? geomCondition : "TRUE");
        String query = String.format("SELECT %s FROM %s WHERE %s", select, from, whereWithGeomCondition);
        return query;
    }

    @Override
    public void setConfiguration(Object searchConfiguration) {
        this.configuration = searchConfiguration instanceof Configuration ? (Configuration)searchConfiguration : null;
    }

    @Override
    public ObjectMapper getConfigurationMapper() {
        return OBJECT_MAPPER;
    }

    @Override
    public void setConfiguration(String configurationJson) throws Exception {
        this.setConfiguration((Configuration)this.getConfigurationMapper().readValue(configurationJson, Configuration.class));
    }

    @Override
    public void setConfiguration(Configuration searchConfiguration) {
        this.configuration = searchConfiguration;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isMonSearch() {
        return this.monSearch;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(FilterInfo.class, (JsonDeserializer)new FilterInfoDeserializer());
        module.addSerializer(FilterInfo.class, (JsonSerializer)new FilterInfoSerializer());
        OBJECT_MAPPER.registerModule((Module)module);
    }

    public static class FilterInfoDeserializer
    extends StdDeserializer<FilterInfo> {
        private final ObjectMapper defaultMapper = new ObjectMapper();

        public FilterInfoDeserializer() {
            super(FilterInfo.class);
            this.defaultMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        public FilterInfo deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            MetaObjectNode value;
            ObjectNode on = (ObjectNode)jp.readValueAsTree();
            String propertyName = (String)this.defaultMapper.treeToValue((TreeNode)on.get("property"), String.class);
            PotenzialflaecheReportServerAction.Property property = PotenzialflaecheReportServerAction.Property.valueOf(propertyName);
            if (property != null) {
                PotenzialflaecheReportServerAction.ReportProperty repProp = property.getValue();
                if (repProp instanceof PotenzialflaecheReportServerAction.KeytableReportProperty || repProp instanceof PotenzialflaecheReportServerAction.MonSearchReportProperty) {
                    JsonNode node = on.get("value");
                    try {
                        MetaObjectNode mon;
                        if (node instanceof ArrayNode) {
                            ArrayNode arrayNode = (ArrayNode)node;
                            MetaObjectNode mons = new ArrayList();
                            Iterator iterator = arrayNode.elements();
                            while (iterator.hasNext()) {
                                JsonNode subNode;
                                JsonNode valueNode = subNode = (JsonNode)iterator.next();
                                MetaObjectNode mon2 = new MetaObjectNode(valueNode.get("domain").asText(), valueNode.get("objectId").asInt(), valueNode.get("classId").asInt());
                                mons.add(mon2);
                            }
                            value = mons;
                        }
                        JsonNode valueNode = node;
                        value = mon = new MetaObjectNode(valueNode.get("domain").asText(), valueNode.get("objectId").asInt(), valueNode.get("classId").asInt());
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage(), ex);
                    }
                } else if (repProp instanceof PotenzialflaecheReportServerAction.SimpleFieldReportProperty) {
                    try {
                        value = this.defaultMapper.treeToValue((TreeNode)on.get("value"), Class.forName(((PotenzialflaecheReportServerAction.SimpleFieldReportProperty)repProp).getClassName()));
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage(), ex);
                    }
                } else {
                    value = null;
                }
            } else {
                value = null;
            }
            FilterInfo filterInfo = new FilterInfo(property, value);
            return filterInfo;
        }
    }

    public static class FilterInfoSerializer
    extends StdSerializer<FilterInfo> {
        private final ObjectMapper defaultMapper = new ObjectMapper();

        public FilterInfoSerializer() {
            super(FilterInfo.class);
            this.defaultMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        public void serialize(FilterInfo filterInfo, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonGenerationException {
            PotenzialflaecheReportServerAction.Property property = filterInfo.getProperty();
            Object value = filterInfo.getValue();
            jg.writeStartObject();
            jg.writeStringField("property", property != null ? property.name() : null);
            if (value instanceof Collection) {
                jg.writeArrayFieldStart("value");
                for (Object subValue : (Collection)value) {
                    if (!(subValue instanceof MetaObjectNode)) continue;
                    MetaObjectNode mon = (MetaObjectNode)subValue;
                    jg.writeStartObject();
                    jg.writeNumberField("classId", mon.getClassId());
                    jg.writeNumberField("objectId", mon.getObjectId());
                    jg.writeStringField("domain", mon.getDomain());
                    jg.writeEndObject();
                }
                jg.writeEndArray();
            } else if (value instanceof MetaObjectNode) {
                MetaObjectNode mon = (MetaObjectNode)value;
                jg.writeObjectFieldStart("value");
                jg.writeNumberField("classId", mon.getClassId());
                jg.writeNumberField("objectId", mon.getObjectId());
                jg.writeStringField("domain", mon.getDomain());
                jg.writeEndObject();
            }
            jg.writeEndObject();
        }
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class FilterInfo
    implements Serializable {
        @JsonProperty
        private final Object value;
        @JsonProperty
        private final PotenzialflaecheReportServerAction.Property property;

        public FilterInfo(PotenzialflaecheReportServerAction.Property property, Object value) {
            this.property = property;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public PotenzialflaecheReportServerAction.Property getProperty() {
            return this.property;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Configuration
    implements StorableSearch.Configuration {
        @JsonProperty
        private SearchMode searchMode = SearchMode.AND;
        @JsonProperty
        private Collection<FilterInfo> filters = new ArrayList<FilterInfo>();

        public void addFilter(PotenzialflaecheReportServerAction.Property property, Object value) {
            this.filters.add(new FilterInfo(property, value));
        }

        public SearchMode getSearchMode() {
            return this.searchMode;
        }

        public Collection<FilterInfo> getFilters() {
            return this.filters;
        }

        public void setSearchMode(SearchMode searchMode) {
            this.searchMode = searchMode;
        }

        public void setFilters(Collection<FilterInfo> filters) {
            this.filters = filters;
        }
    }

    public static enum SearchMode {
        AND,
        OR;

    }
}

