/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.utils.vzkat.VzkatUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class VzkatZeichenLightweightSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(VzkatZeichenLightweightSearch.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("stvoId", Type.INTEGER), new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    private Integer stvoId;
    private String representationPattern;
    private String[] representationFields;

    public VzkatZeichenLightweightSearch() {
        this(null, "%s (%s) - %s", VzkatUtils.ZEICHEN_TOSTRING_FIELDS);
    }

    public VzkatZeichenLightweightSearch(Integer stvoId, String representationPattern, String[] representationFields) {
        this.setStvoId(stvoId);
        this.setRepresentationPattern(representationPattern);
        this.setRepresentationFields(representationFields);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        Integer stvoId = this.getStvoId();
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        ArrayList<String> conditions = new ArrayList<String>();
        if (stvoId != null) {
            conditions.add(String.format("fk_stvo = %d", stvoId));
        }
        String queryTemplate = "SELECT  vzkat_zeichen.*,  CASE WHEN vzkat_stvo.id IS NOT NULL THEN vzkat_stvo.name ELSE '?' END AS vzkat_stvo__name FROM  vzkat_zeichen  LEFT JOIN vzkat_stvo ON vzkat_zeichen.fk_stvo = vzkat_stvo.id %s ORDER BY schluessel ASC";
        String query = String.format("SELECT  vzkat_zeichen.*,  CASE WHEN vzkat_stvo.id IS NOT NULL THEN vzkat_stvo.name ELSE '?' END AS vzkat_stvo__name FROM  vzkat_zeichen  LEFT JOIN vzkat_stvo ON vzkat_zeichen.fk_stvo = vzkat_stvo.id %s ORDER BY schluessel ASC", conditions.isEmpty() ? "" : " wHERE " + String.join((CharSequence)" AND ", conditions));
        try {
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"vzkat_zeichen", (ConnectionContext)this.getConnectionContext());
            if (this.getRepresentationPattern() != null) {
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern(), this.getConnectionContext()));
            }
            return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getConnectionContext()));
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Integer getStvoId() {
        return this.stvoId;
    }

    public void setStvoId(Integer stvoId) {
        this.stvoId = stvoId;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }
}

