/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PoiLocationinstanceDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(PoiLocationinstanceDeletionProvider.class);
    private static final String TABLE_NAME = "poi_locationinstance";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_locationinstance";
    private static final String TABLE_NAME_SEARCH = "poi_zoomdefinition";
    private static final String DELETE_TEXT = "Dieser Poi kann nicht gel\u00f6scht werden, da dieser bei einer Zoomdefinition verwendet wird.";
    private String deleteText = "Dieser Poi kann nicht gel\u00f6scht werden.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean poiBean = metaObject.getBean();
        Integer poi_id = (Integer)poiBean.getProperty(FIELD__ID);
        String query = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, poi_id);
        try {
            ArrayList poiArray = this.getMetaService().performCustomSearch(query, this.getConnectionContext());
            if (!poiArray.isEmpty()) {
                this.deleteText = DELETE_TEXT;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete poi object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

