/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.alkis.ServerAlkisConf;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.security.handler.ExtendedAccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VermessungPictureFinder
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VermessungPictureFinder.class);
    public static final String SEP = "/";
    private static final String[] ENDINGS = new String[]{".pdf", ".tif", ".jpg", ".jpm", ".tiff", ".jpeg", ".TIF", ".JPG"};
    public static final String LINKEXTENSION = ".txt";
    private static final String PREFIX_GRENZNIEDERSCHRIFT = "GN";
    private static final String PREFIX_VERMESSUNGSRISS = "VR";
    private static final String PREFIX_ERGAENZUNGSKARTEN = "GN";
    private static final String PREFIX_FLURBUECHER = "FB";
    private static final String PREFIX_LIEGENSCHAFTSBUECHER = "LB";
    private static final String PREFIX_LIEGENSCHAFTSKARTEN = "LK";
    private static final String PREFIX_NAMENSVERZEICHNIS = "NV";
    private static final String SCHLUESSEL_INSELKARTEN = "516";
    private static final String SCHLUESSEL_ERGAENZUNGSKARTEN = "518";
    private static final String SCHLUESSEL_FLURBUECHER1 = "536";
    private static final String SCHLUESSEL_FLURBUECHER2 = "537";
    private static final String SCHLUESSEL_LIEGENSCHAFTSBUECHER1 = "546";
    private static final String SCHLUESSEL_LIEGENSCHAFTSBUECHER2 = "547";
    private static final String SCHLUESSEL_NAMENSVERZEICHNIS = "566";
    private static final String PATH_PLATZHALTER = "platzhalter";
    private static Map<String, CidsBean> FILE_ENDINGS = new HashMap<String, CidsBean>();
    private final ExtendedAccessHandler accessHandler = new SimpleHttpAccessHandler();
    private final ServerAlkisConf alkisConf = ServerAlkisConf.getInstance();
    private final User user;
    private final MetaService metaService;
    private final ConnectionContext connectionContext;
    private final MetaClass fileEndingMc;

    public VermessungPictureFinder(User user, MetaService metaService, ConnectionContext connectionContext) {
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
        MetaClass fileEndingMc = null;
        try {
            fileEndingMc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"vermessung_fileending_cache", (ConnectionContext)connectionContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.fileEndingMc = fileEndingMc;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String findVermessungsrissPicture(String riss, Integer gemarkung, String flur, String blatt) {
        String picturePath = this.getVermessungsrissFilename(riss, gemarkung, flur, blatt);
        return this.identifyFullFilename(picturePath, false);
    }

    public String findBuchwerkPicture(String schluessel, CidsBean gemarkung, Integer steuerbezirk, String bezeichner, boolean historisch) {
        String fileName = this.getBuchwerkFilename(schluessel, gemarkung, steuerbezirk, bezeichner, historisch);
        return this.identifyFullFilename(fileName, true);
    }

    public String findGewannenPicture(CidsBean gemarkung, Integer kmquadrat, boolean liste) {
        String fileName = this.getGewannenFilename(gemarkung, kmquadrat, liste);
        return this.identifyFullFilename(fileName, true);
    }

    public String findGebaeudebeschreibungPicture(String ordner, Integer nummer) {
        String fileName = this.getGebaeudebeschreibungFilename(ordner, nummer);
        return this.identifyFullFilename(fileName, true);
    }

    public String findInselkartePicture(String schluessel, CidsBean gemarkung, String flur, String blatt, String version) {
        String fileName = this.getInselkarteFilename(schluessel, gemarkung, flur, blatt, version);
        return this.identifyFullFilename(fileName, true);
    }

    public String findGrenzniederschriftPicture(String riss, Integer gemarkung, String flur, String blatt) {
        String picturePath = this.getGrenzniederschriftFilename(riss, gemarkung, flur, blatt);
        return this.identifyFullFilename(picturePath, false);
    }

    public String getGrenzniederschriftFilename(String riss, Integer gemarkung, String flur, String blatt) {
        return this.getVermessungsrissFilename(true, true, riss, gemarkung, flur, blatt);
    }

    private String getVermessungsrissFilename(boolean withPath, boolean isGrenzniederschrift, String schluessel, Integer gemarkung, String flur, String blatt) {
        boolean isErganzungskarte = SCHLUESSEL_ERGAENZUNGSKARTEN.equals(schluessel);
        StringBuffer buf = new StringBuffer();
        if (isGrenzniederschrift) {
            buf.append("GN");
        } else {
            buf.append(PREFIX_VERMESSUNGSRISS);
        }
        buf.append("_");
        buf.append(StringUtils.leftPad((String)schluessel, (int)3, (char)'0'));
        buf.append("-");
        buf.append(String.format("%04d", gemarkung));
        buf.append("-");
        buf.append(StringUtils.leftPad((String)flur, (int)3, (char)'0'));
        buf.append("-");
        buf.append(StringUtils.leftPad((String)blatt, (int)8, (char)'0'));
        StringBuffer b = new StringBuffer();
        if (withPath) {
            b.append(this.getRissFolder(isErganzungskarte, isGrenzniederschrift, gemarkung));
            b.append(SEP);
        }
        b.append(buf.toString());
        return b.toString();
    }

    public String getVermessungsrissLinkFilename(String link) {
        return this.getObjectPath(false, link);
    }

    public String getGrenzniederschriftLinkFilename(String link) {
        return this.getObjectPath(true, link);
    }

    private String getObjectPath(boolean isGrenzNiederschrift, String filename) {
        if (filename.startsWith(PATH_PLATZHALTER)) {
            return (isGrenzNiederschrift ? this.alkisConf.getVermessungHostGrenzniederschriften() : this.alkisConf.getVermessungHostBilder()) + filename;
        }
        boolean isErganzungskarte = filename.contains((isGrenzNiederschrift ? PREFIX_VERMESSUNGSRISS : "GN") + "_" + SCHLUESSEL_ERGAENZUNGSKARTEN + "-");
        String[] splittedFilename = filename.split("-");
        Integer gemarkung = Integer.parseInt(splittedFilename[1]);
        String filenameWithPrefix = (isGrenzNiederschrift ? "GN" : PREFIX_VERMESSUNGSRISS) + "_" + filename;
        return new StringBuffer(this.getRissFolder(isErganzungskarte, isGrenzNiederschrift, gemarkung)).append(SEP).append(filenameWithPrefix).toString();
    }

    public String getVermessungsrissFilename(String riss, Integer gemarkung, String flur, String blatt) {
        return this.getVermessungsrissFilename(true, false, riss, gemarkung, flur, blatt);
    }

    public String getBuchwerkFilename(String schluessel, CidsBean gemarkung, Integer steuerbezirk, String bezeichner, boolean historisch) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getBuchwerkFolder(schluessel, gemarkung));
        if (SCHLUESSEL_ERGAENZUNGSKARTEN.equals(schluessel)) {
            buf.append("GN").append("_");
        } else if (SCHLUESSEL_FLURBUECHER1.equals(schluessel) || SCHLUESSEL_FLURBUECHER2.equals(schluessel)) {
            buf.append(PREFIX_FLURBUECHER).append("_");
        } else if (SCHLUESSEL_LIEGENSCHAFTSBUECHER1.equals(schluessel) || SCHLUESSEL_LIEGENSCHAFTSBUECHER2.equals(schluessel)) {
            buf.append(PREFIX_LIEGENSCHAFTSBUECHER).append("_");
        } else if (SCHLUESSEL_NAMENSVERZEICHNIS.equals(schluessel)) {
            buf.append(PREFIX_NAMENSVERZEICHNIS).append("_");
        }
        buf.append(StringUtils.leftPad((String)schluessel, (int)3, (char)'0')).append("-").append(String.format("%04d", (Integer)gemarkung.getProperty("id"))).append("-").append(historisch ? "001" : "000").append("-").append(steuerbezirk).append(StringUtils.leftPad((String)bezeichner, (int)7, (char)'0'));
        return buf.toString();
    }

    public String getGewannenFilename(CidsBean gemarkung, Integer kmquadrat, boolean liste) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getGewannenFolder());
        if (liste) {
            buf.append("Gewanne_").append(((String)gemarkung.getProperty("name")).replaceAll("\u00c4", "Ae").replaceAll("\u00dc", "Ue").replaceAll("\u00d6", "Oe").replaceAll("\u00e4", "ae").replaceAll("\u00fc", "ue").replaceAll("\u00f6", "oe").replaceAll("\u00df", "ss"));
        } else {
            buf.append(Integer.toString(kmquadrat)).append("-Gewanne");
        }
        return buf.toString();
    }

    public String getGebaeudebeschreibungFilename(String ordner, Integer nummer) {
        return new StringBuffer().append(this.getGebaeudebeschreibungenFolder()).append(ordner).append(SEP).append(String.format("%08d", nummer)).toString();
    }

    public String getInselkarteFilename(String schluessel, CidsBean gemarkung, String flur, String blatt, String version) {
        StringBuffer buf = new StringBuffer(this.getInselkartenFolder(gemarkung)).append(PREFIX_LIEGENSCHAFTSKARTEN).append("_").append(StringUtils.leftPad((String)schluessel, (int)3, (char)'0')).append("-").append(String.format("%04d", (Integer)gemarkung.getProperty("id"))).append("-").append("000").append("-").append(StringUtils.leftPad((String)flur, (int)3, (char)'0')).append(StringUtils.leftPad((String)blatt, (int)2, (char)'0')).append(StringUtils.leftPad((String)version, (int)3, (char)'0'));
        return buf.toString();
    }

    private String identifyFullFilename(String fileWithoutSuffix, boolean buchwerk) {
        return this.identifyFullFilename(fileWithoutSuffix, buchwerk, 0);
    }

    private String identifyFilenameWithEnding(final String fileWithoutEnding) {
        CidsBean firstGuess;
        LinkedHashSet<String> endings;
        block16: {
            endings = new LinkedHashSet<String>();
            if (FILE_ENDINGS.containsKey(fileWithoutEnding)) {
                firstGuess = FILE_ENDINGS.get(fileWithoutEnding);
                if (firstGuess == null) {
                    return null;
                }
            } else {
                firstGuess = null;
            }
            if (firstGuess == null) {
                try {
                    if (this.fileEndingMc != null) {
                        String query = String.format("SELECT %d, %s FROM %s WHERE name = '%s';", this.fileEndingMc.getID(), this.fileEndingMc.getPrimaryKey(), this.fileEndingMc.getTableName(), fileWithoutEnding);
                        MetaObject[] results = this.getMetaService().getMetaObject(this.getUser(), query, this.getConnectionContext());
                        if (results != null && results.length > 0) {
                            firstGuess = results[0].getBean();
                        }
                    }
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block16;
                    LOG.debug((Object)ex, (Throwable)ex);
                }
            }
        }
        if (firstGuess != null) {
            String ending = (String)firstGuess.getProperty("ending");
            endings.add(ending);
        }
        endings.addAll(Arrays.asList(ENDINGS));
        for (final String ending : endings) {
            String fileWithEnding = fileWithoutEnding + ending;
            try {
                CidsBean cidsBean;
                URL objectURL = this.alkisConf.getDownloadUrlForDocument(fileWithEnding);
                if (this.accessHandler.checkIfURLaccessible(objectURL)) {
                    if (!FILE_ENDINGS.containsKey(fileWithoutEnding)) {
                        if (this.fileEndingMc != null) {
                            cidsBean = this.fileEndingMc.getEmptyInstance(this.getConnectionContext()).getBean();
                            FILE_ENDINGS.put(fileWithoutEnding, cidsBean);
                            new SwingWorker<Void, Object>(){

                                @Override
                                protected Void doInBackground() throws Exception {
                                    try {
                                        cidsBean.setProperty("name", (Object)fileWithoutEnding);
                                        cidsBean.setProperty("ending", (Object)ending);
                                        VermessungPictureFinder.this.getMetaService().insertMetaObject(VermessungPictureFinder.this.getUser(), cidsBean.getMetaObject(), VermessungPictureFinder.this.getConnectionContext());
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)ex, (Throwable)ex);
                                    }
                                    return null;
                                }
                            }.execute();
                        }
                    } else {
                        cidsBean = FILE_ENDINGS.get(fileWithoutEnding);
                        new SwingWorker<Void, Object>(){

                            @Override
                            protected Void doInBackground() throws Exception {
                                try {
                                    cidsBean.setProperty("ending", (Object)ending);
                                    VermessungPictureFinder.this.getMetaService().updateMetaObject(VermessungPictureFinder.this.getUser(), cidsBean.getMetaObject(), VermessungPictureFinder.this.getConnectionContext());
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)ex, (Throwable)ex);
                                }
                                return null;
                            }
                        }.execute();
                    }
                    return fileWithEnding;
                }
                if (!FILE_ENDINGS.containsKey(fileWithoutEnding) || !ending.equals((String)(cidsBean = FILE_ENDINGS.get(fileWithoutEnding)).getProperty("ending"))) continue;
                new SwingWorker<Void, Object>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            VermessungPictureFinder.this.getMetaService().deleteMetaObject(VermessungPictureFinder.this.getUser(), cidsBean.getMetaObject(), VermessungPictureFinder.this.getConnectionContext());
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                        return null;
                    }
                }.execute();
            }
            catch (Exception ex) {
                LOG.error((Object)("Problem occured, during checking for " + fileWithEnding), (Throwable)ex);
            }
        }
        FILE_ENDINGS.put(fileWithoutEnding, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String identifyFullFilename(String fileWithoutSuffix, boolean buchwerk, int recursionDepth) {
        String fullSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for picture: " + fileWithoutSuffix));
        }
        if ((fullSize = this.identifyFilenameWithEnding(fileWithoutSuffix)) != null) {
            return fullSize;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No picture file found. Check for Links");
        }
        if (recursionDepth < 3) {
            InputStream urlStream = null;
            try {
                URL objectURL = this.alkisConf.getDownloadUrlForDocument(fileWithoutSuffix + LINKEXTENSION);
                if (!this.accessHandler.checkIfURLaccessible(objectURL) || (urlStream = this.accessHandler.doRequest(objectURL)) == null) return null;
                String link = IOUtils.toString((InputStream)urlStream).trim();
                if (buchwerk) {
                    String string = this.identifyFullFilename(fileWithoutSuffix.substring(0, fileWithoutSuffix.lastIndexOf(SEP)) + SEP + link, buchwerk, recursionDepth + 1);
                    return string;
                }
                boolean isGrenzNiederschrift = fileWithoutSuffix.contains("GN");
                String string = this.identifyFullFilename(this.getObjectPath(isGrenzNiederschrift, link), buchwerk, recursionDepth + 1);
                return string;
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return null;
            }
            finally {
                if (urlStream != null) {
                    try {
                        urlStream.close();
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error during closing InputStream.", (Throwable)ex);
                    }
                }
            }
        }
        LOG.error((Object)"No hop,hop,hop possible within this logic. Seems to be an endless loop, sorry.", (Throwable)new Exception("JustTheStackTrace"));
        return null;
    }

    private String getRissFolder(boolean isErgaenzungskarte, boolean isGrenzniederschrift, Integer gemarkung) {
        StringBuffer buf = isErgaenzungskarte ? new StringBuffer(this.alkisConf.getVermessungHostErgaenzungskarten()) : (isGrenzniederschrift ? new StringBuffer(this.alkisConf.getVermessungHostGrenzniederschriften()) : new StringBuffer(this.alkisConf.getVermessungHostBilder()));
        if (!isErgaenzungskarte) {
            buf.append(String.format("%04d", gemarkung));
        }
        return buf.toString();
    }

    private String getBuchwerkFolder(String schluessel, CidsBean gemarkung) {
        StringBuffer buf = new StringBuffer();
        if (SCHLUESSEL_NAMENSVERZEICHNIS.equals(schluessel)) {
            buf.append(this.alkisConf.getVermessungHostNamensverzeichnis()).append(SEP).append(PREFIX_NAMENSVERZEICHNIS).append("_").append(StringUtils.leftPad((String)schluessel, (int)3, (char)'0')).append("-").append(String.format("%04d", (Integer)gemarkung.getProperty("id")));
        } else if (SCHLUESSEL_FLURBUECHER1.equals(schluessel) || SCHLUESSEL_FLURBUECHER2.equals(schluessel)) {
            buf.append(this.alkisConf.getVermessungHostFlurbuecher());
        } else if (SCHLUESSEL_LIEGENSCHAFTSBUECHER1.equals(schluessel) || SCHLUESSEL_LIEGENSCHAFTSBUECHER2.equals(schluessel)) {
            buf.append(this.alkisConf.getVermessungHostLiegenschaftsbuecher()).append((String)gemarkung.getProperty("name")).append(SEP);
        }
        return buf.toString();
    }

    private String getGewannenFolder() {
        return new StringBuffer().append(this.alkisConf.getVermessungHostGewannen()).append(SEP).toString();
    }

    private String getGebaeudebeschreibungenFolder() {
        return new StringBuffer().append(this.alkisConf.getVermessungHostGebaeudebeschreibungen()).append(SEP).toString();
    }

    private String getInselkartenFolder(CidsBean gemarkung) {
        return new StringBuffer().append(this.alkisConf.getVermessungHostInselkarten()).append(SEP).append(String.format("%04d", (Integer)gemarkung.getProperty("id"))).append(SEP).toString();
    }

    public ExtendedAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    public ServerAlkisConf getAlkisConf() {
        return this.alkisConf;
    }

    public User getUser() {
        return this.user;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }
}

