/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.butler;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.newuser.User;
import Sirius.server.property.ServerProperties;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.utils.butler.ButlerRequestInfo;
import de.cismet.cids.custom.utils.nas.CidsActionClient;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cidsx.server.api.types.ActionTask;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;

public class ButlerProductGenerator {
    private static ButlerProductGenerator instance;
    private static final Logger LOG;
    private static final String FILE_APPENDIX = ".but";
    private static final String SEPERATOR = ";";
    private static final String EASTING = "$RECHTSWERT$";
    private static final String NORTHING = "$HOCHWERT$";
    private static final String BOX_SIZE = "$VORLAGE$";
    private static final String RESOLUTION = "$AUFLOESUNG$";
    private static final String FORMAT = "$AUSGABEFORMAT$";
    private static final String FILE_NAME = "$DATEINAME$";
    private static final String LAYER = "$LAYER$";
    private static final String ETRS89_LAYER = "39";
    private static final String GK_LAYER = "36";
    private static final String MAP_SCALE = "$SCALE$";
    private static final String PDF_OPTIONS_VAR = "$PDF_OPTIONS$";
    private static final String PDF_OPTIONS = "mode=\"ACTIVEVIEW\" showpdflayers=\"false\"";
    File openOrdersLogFile;
    private String ACTION_SERVICE;
    private String ACTION_DOMAIN;
    private String ACTION_USER;
    private String ACTION_PASSWORD;
    private HashMap<Integer, HashMap<String, ButlerRequestInfo>> openOrderMap = new HashMap();
    private String requestFolder;
    private String butlerBasePath;
    private String BUTLER_TEMPLATES_RES_PATH = "/butler/";
    private boolean initError = false;
    private WmpsCidsAction wmpsActionClient;

    private ButlerProductGenerator() {
        try {
            ServerProperties serverProps = DomainServerImpl.getServerProperties();
            String resPath = serverProps.getServerResourcesBasePath();
            this.BUTLER_TEMPLATES_RES_PATH = resPath + this.BUTLER_TEMPLATES_RES_PATH;
            Properties butlerProperties = new Properties();
            butlerProperties.load(ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.BUTLER_PROPERTIES.getValue()));
            this.butlerBasePath = butlerProperties.getProperty("butlerBasePath");
            this.requestFolder = this.butlerBasePath + System.getProperty("file.separator") + butlerProperties.getProperty("butler1RequestPath");
            this.ACTION_DOMAIN = butlerProperties.getProperty("actionDomain");
            this.ACTION_SERVICE = butlerProperties.getProperty("actionServiceURL");
            this.ACTION_USER = butlerProperties.getProperty("actionServiceUser");
            this.ACTION_PASSWORD = butlerProperties.getProperty("actionServicePassword");
            if (this.ACTION_DOMAIN == null || this.ACTION_SERVICE == null || this.ACTION_SERVICE == null || this.ACTION_PASSWORD == null) {
                LOG.warn((Object)"Butler initialisation Error. Can not read properties for connecting to WMPS Action");
                this.initError = true;
            }
            this.wmpsActionClient = new WmpsCidsAction(this.ACTION_DOMAIN, this.ACTION_SERVICE);
            this.wmpsActionClient.setBasicAuthentication(this.ACTION_USER, this.ACTION_PASSWORD);
            StringBuilder fileNameBuilder = new StringBuilder(this.butlerBasePath);
            fileNameBuilder.append(System.getProperty("file.separator"));
            this.openOrdersLogFile = new File(fileNameBuilder.toString() + "openOrders.json");
            if (!this.openOrdersLogFile.exists()) {
                this.openOrdersLogFile.createNewFile();
                this.updateJsonLogFiles();
            }
            if (!this.openOrdersLogFile.isFile() || !this.openOrdersLogFile.canWrite()) {
                LOG.warn((Object)("Can not write to Butler open order log file (" + this.openOrdersLogFile.getPath() + "). This might cause problems in Wunda_Blau Butler functionality"));
                this.initError = true;
            }
            this.loadOpenOrdersFromJsonFile();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Could not load butler properties. This might cause problems in Wunda_Blau Butler functionality", (Throwable)ex);
            this.initError = true;
        }
        if (!this.initError && !this.checkFolders()) {
            this.initError = true;
        }
    }

    public static ButlerProductGenerator getInstance() {
        if (instance == null) {
            instance = new ButlerProductGenerator();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createButlerRequest(String orderNumber, User user, ButlerProduct product, double minX, double minY, double maxX, double maxY, boolean isGeoTiff) {
        if (!this.initError) {
            File reqeustFile = null;
            OutputStreamWriter fw = null;
            String filename = this.determineRequestFileName(user, orderNumber);
            this.addToOpenOrderMap(user, filename, orderNumber, product);
            try {
                reqeustFile = new File(this.requestFolder + System.getProperty("file.separator") + filename + FILE_APPENDIX);
                if (reqeustFile.exists()) {
                    LOG.error((Object)"butler 1 request file already exists");
                    String string = null;
                    return string;
                }
                fw = new FileWriter(reqeustFile);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(this.getRequestLine(product.getKey(), minX, minY, maxX, maxY, product.getColorDepth(), product.getResolution().getKey(), isGeoTiff, product.getFormat().getKey()));
                bw.close();
                String string = filename;
                return string;
            }
            catch (IOException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createButler2Request(String orderNumber, User user, ButlerProduct product, boolean isEtrsBlattscnitt, String boxSize, double middleE, double middleN) {
        if (!this.initError || product == null) {
            BufferedWriter bw = null;
            String filename = this.determineRequestFileName(user, orderNumber);
            String request = this.getButler2RequestLine(product, isEtrsBlattscnitt, middleE, middleN, boxSize, filename);
            if (request == null) {
                LOG.error((Object)"The generated Butler 2 reqeust is null.");
                return null;
            }
            try {
                File requestFile = File.createTempFile(filename, "xml");
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(requestFile), "ISO-8859-1"));
                bw.write(request);
                bw.close();
                ActionTask at = this.wmpsActionClient.createWmpsActionTask(filename, requestFile);
                if (at != null) {
                    this.addToOpenOrderMap(user, filename, orderNumber, product);
                    String string = filename;
                    return string;
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"Could not write the request file for alkis datenausgabe", (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)"Could not create WMPS action, Alkis Datenausgabe equest is aborted", (Throwable)ex);
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"", (Throwable)ex);
                }
            }
        }
        return null;
    }

    public HashMap<String, ButlerRequestInfo> getAllOpenUserRequests(User user) {
        if (this.initError) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ButlerPrdocutGenerator doesnt work hence there was an error during the initialisation.");
            }
            return null;
        }
        if (this.openOrderMap.keySet().contains(user.getId())) {
            HashMap<String, ButlerRequestInfo> result = new HashMap<String, ButlerRequestInfo>();
            result.putAll((Map)this.openOrderMap.get(user.getId()));
            return result;
        }
        return null;
    }

    private boolean checkFolders() {
        File requestDir = new File(this.requestFolder);
        if (!requestDir.exists()) {
            requestDir.mkdirs();
        }
        if (!requestDir.isDirectory() || !requestDir.canWrite()) {
            LOG.error((Object)("could not write to the given butler request directory " + requestDir));
            return false;
        }
        return true;
    }

    private String determineRequestFileName(User user, String requestId) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        String filename = user.getName() + "_" + requestId + "_" + cal.get(11) + "_" + cal.get(12) + "_" + cal.get(13);
        filename = filename.replaceAll("\u00d6", "oe");
        filename = filename.replaceAll("\u00f6", "oe");
        filename = filename.replaceAll("\u00c4", "ae");
        filename = filename.replaceAll("\u00e4", "ae");
        filename = filename.replaceAll("\u00dc", "ue");
        filename = filename.replaceAll("\u00fc", "ue");
        filename = filename.replaceAll("\u00df", "ss");
        return filename;
    }

    private String getRequestLine(String productId, double minX, double minY, double maxX, double maxY, int colorDepth, String resolution, boolean geoTiff, String format) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(productId);
        buffer.append(SEPERATOR);
        buffer.append(minX);
        buffer.append(SEPERATOR);
        buffer.append(minY);
        buffer.append(SEPERATOR);
        buffer.append(maxX);
        buffer.append(SEPERATOR);
        buffer.append(maxY);
        buffer.append(SEPERATOR);
        buffer.append(colorDepth);
        buffer.append(SEPERATOR);
        double res = 0.0;
        if (resolution.equals("ohne")) {
            buffer.append("0");
        } else {
            Double d = Double.parseDouble(resolution);
            res = d / 100.0;
            buffer.append(res);
        }
        buffer.append(SEPERATOR);
        if (geoTiff) {
            buffer.append("yes");
        } else {
            buffer.append("no");
        }
        buffer.append(SEPERATOR);
        buffer.append(format);
        return buffer.toString();
    }

    private String getButler2RequestLine(ButlerProduct product, boolean isEtrsBlattschnitt, double x, double y, String box_size, String filename) {
        String productKey = product.getKey();
        String template = this.loadTemplate(productKey);
        if (productKey.startsWith("0903")) {
            template = isEtrsBlattschnitt ? template.replace(LAYER, GK_LAYER) : template.replace(LAYER, ETRS89_LAYER);
            template = template.replace(MAP_SCALE, product.getScale());
        }
        template = template.replace(EASTING, "" + x);
        template = template.replace(NORTHING, "" + y);
        template = template.replace(BOX_SIZE, "" + box_size);
        template = template.replace(RESOLUTION, product.getResolution().getKey());
        if (product.getFormat() == null || product.getFormat().getKey() == null) {
            LOG.error((Object)"No Format for Butler Product is specified. can not create a correct request file");
            return null;
        }
        if (product.getFormat().getKey().equals("pdf")) {
            template = template.replace(PDF_OPTIONS_VAR, PDF_OPTIONS);
        } else if (product.getFormat().getKey().equals("tif")) {
            template = template.replace(PDF_OPTIONS_VAR, "");
        }
        template = template.replace(FORMAT, product.getFormat().getKey());
        template = template.replace(FILE_NAME, filename);
        return template;
    }

    private String loadTemplate(String productKey) {
        try {
            StringBuffer templateBuffer = new StringBuffer();
            BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.BUTLER_TEMPLATES_RES_PATH + "template_" + productKey + ".xml"), "ISO-8859-1"));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = fr.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                templateBuffer.append(readData);
            }
            fr.close();
            return templateBuffer.toString();
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)("Could not access Butler tempalte file: " + this.BUTLER_TEMPLATES_RES_PATH + "template_" + productKey + ".xml"), (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)("Could not access Butler tempalte file: " + this.BUTLER_TEMPLATES_RES_PATH + "template_" + productKey + ".xml"), (Throwable)ex);
        }
        return null;
    }

    private void addToOpenOrderMap(User user, String requestId, String userOrderId, ButlerProduct product) {
        HashMap<String, ButlerRequestInfo> openUserOrders = this.openOrderMap.get(user.getId());
        if (openUserOrders == null) {
            openUserOrders = new HashMap();
            this.openOrderMap.put(user.getId(), openUserOrders);
        }
        openUserOrders.put(requestId, new ButlerRequestInfo(userOrderId, product));
        this.updateJsonLogFiles();
    }

    private void removeFromOpenOrders(User user, String requestId) {
        HashMap<String, ButlerRequestInfo> openUserOrders = this.openOrderMap.get(user.getId());
        if (openUserOrders != null) {
            openUserOrders.remove(requestId);
            if (openUserOrders.isEmpty()) {
                this.openOrderMap.remove(user.getId());
            }
        }
        this.updateJsonLogFiles();
    }

    private void updateJsonLogFiles() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        try {
            HashMap<Integer, OpenOrderMapWrapper> mapToSerialize = new HashMap<Integer, OpenOrderMapWrapper>();
            for (Integer i : this.openOrderMap.keySet()) {
                OpenOrderMapWrapper openuserOders = new OpenOrderMapWrapper(this.openOrderMap.get(i));
                mapToSerialize.put(i, openuserOders);
            }
            writer.writeValue(this.openOrdersLogFile, mapToSerialize);
        }
        catch (IOException ex) {
            LOG.error((Object)"error during writing open butler orders to log file", (Throwable)ex);
        }
    }

    private void loadOpenOrdersFromJsonFile() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap wrapperMap = (HashMap)mapper.readValue(this.openOrdersLogFile, (TypeReference)new TypeReference<HashMap<Integer, OpenOrderMapWrapper>>(){});
            for (Integer i : wrapperMap.keySet()) {
                this.openOrderMap.put(i, ((OpenOrderMapWrapper)wrapperMap.get(i)).getMap());
            }
        }
        catch (JsonParseException ex) {
            LOG.error((Object)"Could not parse nas order log files", (Throwable)ex);
        }
        catch (JsonMappingException ex) {
            LOG.error((Object)"error while json mapping/unmarshalling of nas order log file", (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)"error while loading nas order log file", (Throwable)ex);
        }
    }

    public void removeOrder(User user, String requestId) {
        if (this.initError) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ButlerPrdocutGenerator doesnt work hence there was an error during the initialisation.");
            }
            return;
        }
        this.removeFromOpenOrders(user, requestId);
    }

    static {
        LOG = Logger.getLogger(ButlerProductGenerator.class);
    }

    private final class WmpsCidsAction
    extends CidsActionClient {
        private static final String ACTION_KEY = "wmps";

        public WmpsCidsAction(String domain, String baseURL) {
            super(domain, baseURL);
        }

        public ActionTask createWmpsActionTask(String filename, File requestFile) {
            ActionTask task = new ActionTask();
            HashMap params = new HashMap();
            task.setParameters(params);
            return super.createTask(ACTION_KEY, task, requestFile, MediaType.APPLICATION_XML_TYPE, true);
        }
    }

    private static final class OpenOrderMapWrapper {
        private HashMap<String, ButlerRequestInfo> map;

        public OpenOrderMapWrapper() {
        }

        public OpenOrderMapWrapper(HashMap<String, ButlerRequestInfo> map) {
            this.map = map;
        }

        public HashMap<String, ButlerRequestInfo> getMap() {
            return this.map;
        }

        public void setMap(HashMap<String, ButlerRequestInfo> map) {
            this.map = map;
        }
    }
}

