/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.nas;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.newuser.User;
import Sirius.server.property.ServerProperties;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.aed_sicad.www.namespaces.svr.AM_AuftragServer;
import de.aed_sicad.www.namespaces.svr.AuftragsManagerLocator;
import de.aed_sicad.www.namespaces.svr.AuftragsManagerSoap;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.nas.DXFConverterAction;
import de.cismet.cids.custom.utils.nas.GML3Writer;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.custom.utils.nas.NasProductInfo;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cidsx.server.api.types.ActionTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NASProductGenerator {
    private static final String FILE_APPENDIX = ".xml";
    private static NASProductGenerator instance;
    private static final int REQUEST_PERIOD = 3000;
    private static final String REQUEST_PLACE_HOLDER = "REQUEST-ID";
    private static final String PROFILKENNUNG_PLACE_HOLDER = "PROFILKENNUNG";
    private static final String PROFILKENNUNG_DEFAULT_VALUE = "WUNDA";
    private static final String DATA_FORMAT_STD = "<datenformat>1000</datenformat>";
    private static final String DATA_FORMAT_500 = "<datenformat>NAS_500m</datenformat>";
    private File openOrdersLogFile;
    private File undeliveredOrdersLogFile;
    private final transient Logger log = Logger.getLogger(this.getClass());
    private AuftragsManagerSoap manager;
    private String SERVICE_URL;
    private String USER;
    private String PW;
    private String OUTPUT_DIR;
    private String ACTION_SERVICE;
    private String ACTION_DOMAIN;
    private String ACTION_USER;
    private String ACTION_PASSWORD;
    private String PROFIL_KENNUNG;
    private HashMap<String, HashMap<String, NasProductInfo>> openOrderMap = new HashMap();
    private HashMap<String, HashMap<String, NasProductInfo>> undeliveredOrderMap = new HashMap();
    private HashMap<String, NasProductDownloader> downloaderMap = new HashMap();
    private boolean initSucces = this.init();
    private DXFConverterAction dxfConverter;

    private NASProductGenerator() {
    }

    public final boolean init() {
        if (!this.initSucces) {
            Properties serviceProperties = new Properties();
            try {
                serviceProperties.load(ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.NAS_SERVER_PROPERTIES.getValue()));
                this.SERVICE_URL = serviceProperties.getProperty("service");
                this.USER = serviceProperties.getProperty("user");
                this.PW = serviceProperties.getProperty("pw");
                this.OUTPUT_DIR = serviceProperties.getProperty("outputDir");
                this.ACTION_DOMAIN = serviceProperties.getProperty("actionDomain");
                this.ACTION_SERVICE = serviceProperties.getProperty("actionServiceURL");
                this.ACTION_USER = serviceProperties.getProperty("actionServiceUser");
                this.ACTION_PASSWORD = serviceProperties.getProperty("actionServicePassword");
                this.PROFIL_KENNUNG = serviceProperties.getProperty("profilKennung", PROFILKENNUNG_DEFAULT_VALUE);
                if (this.OUTPUT_DIR == null || this.OUTPUT_DIR.isEmpty()) {
                    this.log.info((Object)"Could not read nas nas output dir property. using server working dir as fallback");
                    this.OUTPUT_DIR = ".";
                }
                if (this.SERVICE_URL == null || this.SERVICE_URL.isEmpty() || this.USER == null || this.USER.isEmpty() || this.PW == null || this.PW.isEmpty()) {
                    this.log.warn((Object)"NAS Datenabgabe initialisation Error. Could not read all properties for connecting 3A Server. NAS support is disabled");
                    return false;
                }
                File outputDir = new File(this.OUTPUT_DIR);
                if (!outputDir.exists()) {
                    outputDir.mkdirs();
                }
                if (!outputDir.isDirectory() || !outputDir.canWrite()) {
                    this.log.warn((Object)("NAS Datenabgabe initialisation Error. Could not write to the given nas output directory: " + outputDir));
                    return false;
                }
                if (this.ACTION_DOMAIN == null || this.ACTION_SERVICE == null || this.ACTION_SERVICE == null || this.ACTION_PASSWORD == null) {
                    this.log.warn((Object)"NAS Datenabgabe initialisation Error. Can not read properties for connecting to DXF converter Action");
                    return false;
                }
                this.dxfConverter = new DXFConverterAction(this.ACTION_DOMAIN, this.ACTION_SERVICE);
                this.dxfConverter.setBasicAuthentication(this.ACTION_USER, this.ACTION_PASSWORD);
                StringBuilder fileNameBuilder = new StringBuilder(this.OUTPUT_DIR);
                fileNameBuilder.append(System.getProperty("file.separator"));
                this.openOrdersLogFile = new File(fileNameBuilder.toString() + "openOrdersMap.json");
                this.undeliveredOrdersLogFile = new File(fileNameBuilder.toString() + "undeliveredOrdersMap.json");
                if (!this.openOrdersLogFile.exists()) {
                    this.openOrdersLogFile.createNewFile();
                }
                if (!this.undeliveredOrdersLogFile.exists()) {
                    this.undeliveredOrdersLogFile.createNewFile();
                    this.updateJsonLogFiles();
                }
                if (!(this.openOrdersLogFile.isFile() && this.openOrdersLogFile.canWrite() && this.undeliveredOrdersLogFile.isFile() && this.undeliveredOrdersLogFile.canWrite())) {
                    this.log.warn((Object)"NAS Datenabgabe initialisation Error. Could not write to NAS order log files. NAS support is disabled");
                    return false;
                }
                this.initFromOrderLogFiles();
            }
            catch (Exception ex) {
                this.log.warn((Object)"NAS Datenabgabe initialisation Error! NAS support is disabled", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public static NASProductGenerator instance() {
        if (instance == null) {
            instance = new NASProductGenerator();
        }
        return instance;
    }

    private void initFromOrderLogFiles() {
        this.loadFromLogFile(this.openOrderMap, this.openOrdersLogFile);
        this.loadFromLogFile(this.undeliveredOrderMap, this.undeliveredOrdersLogFile);
        for (String userId : this.openOrderMap.keySet()) {
            HashMap<String, NasProductInfo> hashMap = this.openOrderMap.get(userId);
        }
    }

    public boolean reInitFromOrderLogFiles() {
        this.openOrderMap = new HashMap();
        this.undeliveredOrderMap = new HashMap();
        this.initFromOrderLogFiles();
        return true;
    }

    private InputStream generateQuery(GeometryCollection geom, InputStream templateFile, String requestName, String profilKennung) {
        int gmlId = 0;
        try {
            String xmlGeom = GML3Writer.writeGML3_2WithETRS89(geom);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(templateFile);
            NodeList intersectNodes = doc.getElementsByTagName("ogc:Intersects");
            if (intersectNodes.getLength() == 0) {
                intersectNodes = doc.getElementsByTagName("fes:Intersects");
            }
            Document doc2 = dBuilder.parse(new InputSource(new StringReader(xmlGeom)));
            Element newPolygonNode = doc2.getDocumentElement();
            for (int i = 0; i < intersectNodes.getLength(); ++i) {
                Node oldPolygonNode = null;
                for (Node child = intersectNodes.item(i).getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!child.getNodeName().equals("gml:Polygon")) continue;
                    oldPolygonNode = child;
                    break;
                }
                if (oldPolygonNode == null) {
                    this.log.error((Object)"corrupt query template file, could not find a geometry node");
                }
                newPolygonNode.setAttribute("gml:id", "G" + gmlId);
                ++gmlId;
                NodeList surfaceNodes = newPolygonNode.getElementsByTagName("gml:Surface");
                for (int j = 0; j < surfaceNodes.getLength(); ++j) {
                    Element surfaceNode = (Element)surfaceNodes.item(j);
                    surfaceNode.setAttribute("gml:id", "G" + gmlId);
                    ++gmlId;
                }
                Node importedNode = doc.importNode(newPolygonNode, true);
                intersectNodes.item(i).removeChild(oldPolygonNode);
                intersectNodes.item(i).appendChild(importedNode);
            }
            OutputFormat format = new OutputFormat(doc);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer(stringOut, format);
            serial.serialize(doc);
            String request = stringOut.toString();
            request = request.replaceAll(REQUEST_PLACE_HOLDER, requestName);
            request = request.replaceAll(PROFILKENNUNG_PLACE_HOLDER, profilKennung != null ? profilKennung : this.PROFIL_KENNUNG);
            if (this.isOrderSplitted(geom)) {
                request = request.replaceAll(DATA_FORMAT_STD, DATA_FORMAT_500);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)request);
            }
            return new ByteArrayInputStream(request.getBytes());
        }
        catch (ParserConfigurationException ex) {
            this.log.error((Object)"Parser Configuration Error", (Throwable)ex);
        }
        catch (SAXException ex) {
            this.log.error((Object)"Error during parsing document", (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)"Error while openeing nas template file", (Throwable)ex);
        }
        return null;
    }

    private InputStream loadTemplateFile(NasProduct product) {
        FileInputStream templateFile = null;
        try {
            if (product != null && product.getTemplate() != null) {
                ServerProperties serverProps = DomainServerImpl.getServerProperties();
                String resPath = serverProps.getServerResourcesBasePath();
                templateFile = new FileInputStream(resPath + product.getTemplate());
            }
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)("Could not read template template file for Template :" + product.toString()), (Throwable)ex);
        }
        return templateFile;
    }

    public String executeAsynchQuery(NasProduct product, GeometryCollection geoms, User user, String requestName, String profilKennung) {
        if (!this.init()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NASProductGenerator doesnt work hence there was an error during the initialisation.");
            }
            return null;
        }
        try {
            InputStream templateFile = this.loadTemplateFile(product);
            if (templateFile == null) {
                this.log.error((Object)"Error laoding the NAS template file.");
                return null;
            }
            if (geoms == null) {
                this.log.error((Object)"geometry is null, cannot execute nas query");
                return null;
            }
            String requestId = this.getRequestId(user, requestName);
            InputStream preparedQuery = this.generateQuery(geoms, templateFile, requestId, profilKennung);
            this.initAmManager();
            int sessionID = this.manager.login(this.USER, this.PW);
            String orderId = this.manager.registerGZip(sessionID, this.gZipFile(preparedQuery));
            boolean isSplitted = this.isOrderSplitted(geoms);
            boolean isDXF = product.getFormat().equals(NasProduct.Format.DXF.toString());
            this.addToOpenOrders(this.determineUserPrefix(user), orderId, new NasProductInfo(isSplitted, requestName, isDXF));
            this.addToUndeliveredOrders(this.determineUserPrefix(user), orderId, new NasProductInfo(isSplitted, requestName, isDXF));
            NasProductDownloader downloader = new NasProductDownloader(this.determineUserPrefix(user), orderId, isDXF, product.getParams());
            this.downloaderMap.put(orderId, downloader);
            Thread workerThread = new Thread(downloader);
            workerThread.start();
            return orderId;
        }
        catch (Exception ex) {
            this.log.error((Object)"could not create conenction to 3A Server", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResultToFileforRequest(InputStream query, File file) {
        block44: {
            try {
                if (!this.init()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"NASProductGenerator doesnt work hence there was an error during the initialisation.");
                    }
                    return;
                }
                this.initAmManager();
                int sessionID = this.manager.login(this.USER, this.PW);
                String orderId = this.manager.registerGZip(sessionID, this.gZipFile(query));
                AM_AuftragServer amServer = this.manager.listAuftrag(sessionID, orderId);
                while (this.manager.getResultCount(sessionID, orderId) < 1 && this.manager.getProtocolGZip(sessionID, orderId) == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                int resCount = this.manager.getResultCount(sessionID, orderId);
                if (resCount > 1) {
                    ArrayList<byte[]> resultFiles = new ArrayList<byte[]>();
                    for (int i = 0; i < resCount; ++i) {
                        resultFiles.add(this.manager.getNResultGZip(sessionID, orderId, i));
                    }
                    ArrayList<byte[]> unzippedFileCollection = new ArrayList<byte[]>();
                    for (byte[] zipFile : resultFiles) {
                        unzippedFileCollection.add(this.gunzip(zipFile));
                    }
                    FileOutputStream fos = null;
                    ZipOutputStream zos = null;
                    try {
                        fos = new FileOutputStream(file);
                        zos = new ZipOutputStream(fos);
                        for (int i = 0; i < unzippedFileCollection.size(); ++i) {
                            byte[] unzippedFile = (byte[])unzippedFileCollection.get(i);
                            String fileEntryName = orderId + "#" + i + FILE_APPENDIX;
                            zos.putNextEntry(new ZipEntry(fileEntryName));
                            zos.write(unzippedFile);
                            zos.closeEntry();
                        }
                        break block44;
                    }
                    catch (IOException ex) {
                        this.log.warn((Object)"error during creation of zip file");
                        break block44;
                    }
                    finally {
                        try {
                            if (zos != null) {
                                zos.close();
                            }
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                InputStream is = null;
                OutputStream os = null;
                try {
                    byte[] data;
                    if (resCount == 0) {
                        this.log.error((Object)("it seems that there is an error with NAS order: " + orderId + ". Writing protocol to file " + file));
                        this.log.error((Object)("Protocol for NAS order " + orderId + ": " + new String(this.gunzip(this.manager.getProtocolGZip(sessionID, orderId)))));
                        data = this.manager.getProtocolGZip(sessionID, orderId);
                    } else {
                        data = this.manager.getResultGZip(sessionID, orderId);
                    }
                    if (data == null) {
                        this.log.error((Object)("result of nas order " + orderId + " is null"));
                        return;
                    }
                    is = new GZIPInputStream(new ByteArrayInputStream(this.manager.getResultGZip(sessionID, orderId)));
                    os = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    int length = is.read(buffer, 0, 8192);
                    while (length != -1) {
                        os.write(buffer, 0, length);
                        length = is.read(buffer, 0, 8192);
                    }
                }
                catch (IOException ex) {
                    this.log.error((Object)"error during gunzip of nas response files", (Throwable)ex);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (RemoteException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initAmManager() {
        try {
            AuftragsManagerLocator am = new AuftragsManagerLocator();
            this.manager = am.getAuftragsManagerSoap(new URL(this.SERVICE_URL));
        }
        catch (Exception ex) {
            this.log.error((Object)"error creating 3AServer interface", (Throwable)ex);
            return;
        }
    }

    public byte[] getResultForOrder(String orderId, User user) {
        if (!this.init()) {
            this.log.error((Object)"NASProductGenerator doesnt work hence there was an error during the initialisation.");
            return null;
        }
        HashMap<String, NasProductInfo> openUserOrders = this.openOrderMap.get(this.determineUserPrefix(user));
        if (openUserOrders != null && openUserOrders.keySet().contains(orderId)) {
            return new byte[0];
        }
        HashMap<String, NasProductInfo> undeliveredUserOrders = this.undeliveredOrderMap.get(this.determineUserPrefix(user));
        if (undeliveredUserOrders == null || undeliveredUserOrders.isEmpty()) {
            this.log.error((Object)("there are no undelivered nas orders for the user " + user.toString()));
            return null;
        }
        if (!undeliveredUserOrders.keySet().contains(orderId)) {
            this.log.error((Object)("there is no order for user " + user.toString() + " with order id " + orderId));
            return null;
        }
        NasProductInfo productInfo = undeliveredUserOrders.get(orderId);
        this.removeFromUndeliveredOrders(this.determineUserPrefix(user), orderId);
        String fileExtension = FILE_APPENDIX;
        if (productInfo.isDxf()) {
            fileExtension = ".dxf";
        } else if (productInfo.isIsSplittet()) {
            fileExtension = ".zip";
        }
        return this.loadFile(this.determineUserPrefix(user), orderId, fileExtension);
    }

    public File getNasFileForOrder(String orderId, String userId, boolean isZipped) {
        if (!this.init()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NASProductGenerator doesnt work hence there was an error during the initialisation.");
            }
            return null;
        }
        return new File(this.determineFileName(userId, orderId, isZipped ? ".zip" : FILE_APPENDIX));
    }

    public HashMap<String, NasProductInfo> getUndeliveredOrders(User user) {
        HashMap<String, NasProductInfo> result = new HashMap<String, NasProductInfo>();
        if (!this.init()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NASProductGenerator doesnt work hence there was an error during the initialisation.");
            }
            return result;
        }
        HashMap<String, NasProductInfo> undeliveredOrders = this.undeliveredOrderMap.get(this.determineUserPrefix(user));
        if (undeliveredOrders != null && !undeliveredOrders.isEmpty()) {
            for (String undeliveredOrderId : undeliveredOrders.keySet()) {
                NasProductInfo pInfo = undeliveredOrders.get(undeliveredOrderId);
                result.put(undeliveredOrderId, new NasProductInfo(pInfo.isIsSplittet(), new String(pInfo.getRequestName()), pInfo.isDxf()));
            }
        }
        return result;
    }

    public void cancelOrder(String orderId, User user) {
        if (!this.init()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NASProductGenerator doesnt work hence there was an error during the initialisation.");
            }
            return;
        }
        String userKey = this.determineUserPrefix(user);
        NasProductDownloader downloader = this.downloaderMap.get(orderId);
        if (downloader != null) {
            downloader.setInterrupted(true);
            this.downloaderMap.remove(orderId);
        }
        this.removeFromOpenOrders(userKey, orderId);
        this.removeFromUndeliveredOrders(userKey, orderId);
        this.deleteFileIfExists(orderId, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] gZipFile(InputStream is) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream zipOut = null;
        try {
            zipOut = new GZIPOutputStream(bos);
            byte[] buffer = new byte[8192];
            int length = is.read(buffer, 0, 8192);
            while (true) {
                if (length == -1) {
                    is.close();
                    ((OutputStream)zipOut).close();
                    return bos.toByteArray();
                }
                ((OutputStream)zipOut).write(buffer, 0, length);
                length = is.read(buffer, 0, 8192);
            }
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)"error during gzip of gile", (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            this.log.error((Object)"error during gzip of gile", (Throwable)ex);
            return null;
        }
    }

    private void logProtocol(byte[] protocol) {
        byte[] unzippedProtocol = this.gunzip(protocol);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Nas Protokoll " + new String(unzippedProtocol)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gunzip(byte[] data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPInputStream is = null;
        try {
            is = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] buffer = new byte[8192];
            int length = ((InputStream)is).read(buffer, 0, 8192);
            while (length != -1) {
                bos.write(buffer, 0, length);
                length = ((InputStream)is).read(buffer, 0, 8192);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            this.log.error((Object)"error during gunzip of nas response files", (Throwable)ex);
        }
        finally {
            try {
                bos.close();
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveZipFileOfUnzippedFileCollection(String userKey, String orderId, ArrayList<byte[]> zippedFiles) {
        ArrayList<byte[]> unzippedFileCollection = new ArrayList<byte[]>();
        for (byte[] zipFile : zippedFiles) {
            unzippedFileCollection.add(this.gunzip(zipFile));
        }
        String filename = this.determineFileName(userKey, orderId);
        File file = new File(filename.replace(FILE_APPENDIX, ".zip"));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(file);
            zos = new ZipOutputStream(fos);
            for (int i = 0; i < unzippedFileCollection.size(); ++i) {
                byte[] unzippedFile = (byte[])unzippedFileCollection.get(i);
                String fileEntryName = orderId + "#" + i + FILE_APPENDIX;
                zos.putNextEntry(new ZipEntry(fileEntryName));
                zos.write(unzippedFile);
                zos.closeEntry();
            }
        }
        catch (IOException ex) {
            this.log.warn((Object)"error during creation of zip file");
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipAndSaveFile(String userKey, String orderId, byte[] data) {
        if (data == null) {
            this.log.error((Object)("result of nas order " + orderId + " is null"));
            return;
        }
        File file = new File(this.determineFileName(userKey, orderId));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new GZIPInputStream(new ByteArrayInputStream(data));
            os = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            int length = is.read(buffer, 0, 8192);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer, 0, 8192);
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"error during gunzip of nas response files", (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String userKey, String orderId, String fileExtension) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            is = new FileInputStream(this.determineFileName(userKey, orderId, fileExtension));
            byte[] buffer = new byte[8192];
            int length = is.read(buffer, 0, 8192);
            while (length != -1) {
                bos.write(buffer, 0, length);
                length = is.read(buffer, 0, 8192);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)("could not find result file for order id " + orderId), (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)("error during loading result file for order id " + orderId), (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                bos.close();
            }
            catch (IOException ex) {}
        }
        return null;
    }

    private String determineFileName(String userKey, String orderId) {
        return this.determineFileName(userKey, orderId, FILE_APPENDIX);
    }

    private String determineFileName(String userKey, String orderId, String fileExtension) {
        StringBuilder fileNameBuilder = new StringBuilder(this.OUTPUT_DIR);
        fileNameBuilder.append(System.getProperty("file.separator"));
        fileNameBuilder.append(userKey);
        fileNameBuilder.append(System.getProperty("file.separator"));
        fileNameBuilder.append(orderId);
        fileNameBuilder.append(fileExtension);
        return fileNameBuilder.toString();
    }

    private String determineUserPrefix(User user) {
        String prefix = user.getId() + "_" + user.getName();
        prefix = prefix.replaceAll("\u00d6", "oe");
        prefix = prefix.replaceAll("\u00f6", "oe");
        prefix = prefix.replaceAll("\u00c4", "ae");
        prefix = prefix.replaceAll("\u00e4", "ae");
        prefix = prefix.replaceAll("\u00dc", "ue");
        prefix = prefix.replaceAll("\u00fc", "ue");
        prefix = prefix.replaceAll("\u00df", "ss");
        return prefix;
    }

    private void addToOpenOrders(String userKey, String orderId, NasProductInfo pInfo) {
        HashMap<String, NasProductInfo> openUserOders = this.openOrderMap.get(userKey);
        if (openUserOders == null) {
            openUserOders = new HashMap();
            this.openOrderMap.put(userKey, openUserOders);
        }
        openUserOders.put(orderId, pInfo);
        this.updateJsonLogFiles();
    }

    private void removeFromOpenOrders(String userKey, String orderId) {
        HashMap<String, NasProductInfo> openUserOrders = this.openOrderMap.get(userKey);
        if (openUserOrders == null) {
            this.log.info((Object)("there are no undelivered nas orders for the user with id " + userKey));
            return;
        }
        openUserOrders.remove(orderId);
        if (openUserOrders.isEmpty()) {
            this.openOrderMap.remove(userKey);
        }
        this.updateJsonLogFiles();
    }

    private void addToUndeliveredOrders(String userKey, String orderId, NasProductInfo pInfo) {
        HashMap<String, NasProductInfo> undeliveredUserOders = this.undeliveredOrderMap.get(userKey);
        if (undeliveredUserOders == null) {
            undeliveredUserOders = new HashMap();
            this.undeliveredOrderMap.put(userKey, undeliveredUserOders);
        }
        undeliveredUserOders.put(orderId, pInfo);
        this.updateJsonLogFiles();
    }

    private void removeFromUndeliveredOrders(String userKey, String orderId) {
        HashMap<String, NasProductInfo> undeliveredUserOders = this.undeliveredOrderMap.get(userKey);
        if (undeliveredUserOders == null) {
            this.log.info((Object)("there are no undelivered nas orders for the user with id " + userKey));
            return;
        }
        undeliveredUserOders.remove(orderId);
        if (undeliveredUserOders.isEmpty()) {
            this.undeliveredOrderMap.remove(userKey);
        }
        this.updateJsonLogFiles();
    }

    private synchronized void updateJsonLogFiles() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        try {
            HashMap<String, MapWrapper> openOrdersToSerialize = new HashMap<String, MapWrapper>();
            for (String i : this.openOrderMap.keySet()) {
                MapWrapper openuserOders = new MapWrapper(this.openOrderMap.get(i));
                openOrdersToSerialize.put(i, openuserOders);
            }
            writer.writeValue(this.openOrdersLogFile, openOrdersToSerialize);
            HashMap<String, MapWrapper> undeliveredOrdersToSerialize = new HashMap<String, MapWrapper>();
            for (String i : this.undeliveredOrderMap.keySet()) {
                MapWrapper openuserOders = new MapWrapper(this.undeliveredOrderMap.get(i));
                undeliveredOrdersToSerialize.put(i, openuserOders);
            }
            writer.writeValue(this.undeliveredOrdersLogFile, undeliveredOrdersToSerialize);
        }
        catch (IOException ex) {
            this.log.error((Object)"error during writing open butler orders to log file", (Throwable)ex);
        }
    }

    private void deleteFileIfExists(String orderId, User user) {
        String userKey = this.determineUserPrefix(user);
        File file = new File(this.determineFileName(userKey, orderId));
        if (file.exists() && !file.delete()) {
            this.log.warn((Object)("could not delete file " + file.toString()));
        }
    }

    private String getRequestId(User user, String requestId) {
        return user.getName() + "_" + requestId;
    }

    private boolean isOrderSplitted(GeometryCollection geoms) {
        Envelope env = geoms.getEnvelopeInternal();
        double xSize = env.getMaxX() - env.getMinX();
        double ySize = env.getMaxY() - env.getMinY();
        return xSize > 500.0 && ySize > 500.0;
    }

    private void loadFromLogFile(HashMap<String, HashMap<String, NasProductInfo>> map, File openOrdersLogFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            HashMap wrapperMap = (HashMap)mapper.readValue(openOrdersLogFile, (TypeReference)new TypeReference<HashMap<String, MapWrapper>>(){});
            for (String s : wrapperMap.keySet()) {
                map.put(s, ((MapWrapper)wrapperMap.get(s)).getMap());
            }
        }
        catch (JsonParseException ex) {
            this.log.warn((Object)"Could not parse nas order log files", (Throwable)ex);
        }
        catch (JsonMappingException ex) {
            this.log.warn((Object)"error while json mapping/unmarshalling of nas order log file", (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.warn((Object)"error while loading nas order log file", (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File("/home/daniel/Documents/punktreservierung/Wunda_Reservierung2/Muster-Dateien/A_AMGR000000003012_Ben_Auftr_alle_PKZ_alt.xml"));
            File f = new File("/home/daniel/Desktop/result.xml");
            NASProductGenerator.instance().writeResultToFileforRequest(fis, f);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static final class MapWrapper {
        private HashMap<String, NasProductInfo> map;

        public MapWrapper() {
        }

        public MapWrapper(HashMap<String, NasProductInfo> map) {
            this.map = map;
        }

        public HashMap<String, NasProductInfo> getMap() {
            return this.map;
        }

        public void setMap(HashMap<String, NasProductInfo> map) {
            this.map = map;
        }
    }

    private class NasProductDownloader
    implements Runnable {
        final HashMap<String, Object> params;
        private String orderId;
        private String userId;
        private boolean isDxf;
        private boolean interrupted = false;

        public NasProductDownloader(String userId, String orderId, boolean dxfFormat, Map<String, Object> params) {
            this.orderId = orderId;
            this.userId = userId;
            this.isDxf = dxfFormat;
            this.params = new HashMap();
            if (params != null) {
                this.params.putAll(params);
            }
        }

        @Override
        public void run() {
            try {
                NASProductGenerator.this.initAmManager();
                final int sessionId = NASProductGenerator.this.manager.login(NASProductGenerator.this.USER, NASProductGenerator.this.PW);
                final Timer t = new Timer();
                t.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        block14: {
                            try {
                                AM_AuftragServer amServer = null;
                                if (NasProductDownloader.this.interrupted) {
                                    NASProductGenerator.this.log.info((Object)("interrupting the dowload of nas order " + NasProductDownloader.this.orderId));
                                    t.cancel();
                                    return;
                                }
                                amServer = NASProductGenerator.this.manager.listAuftrag(sessionId, NasProductDownloader.this.orderId);
                                if (amServer.getWannBeendet() == null) {
                                    return;
                                }
                                t.cancel();
                                NASProductGenerator.this.logProtocol(NASProductGenerator.this.manager.getProtocolGZip(sessionId, NasProductDownloader.this.orderId));
                                boolean isZip = false;
                                if (!NasProductDownloader.this.interrupted) {
                                    int resCount = NASProductGenerator.this.manager.getResultCount(sessionId, NasProductDownloader.this.orderId);
                                    if (resCount > 1) {
                                        ArrayList<byte[]> resultFiles = new ArrayList<byte[]>();
                                        for (int i = 0; i < resCount; ++i) {
                                            resultFiles.add(NASProductGenerator.this.manager.getNResultGZip(sessionId, NasProductDownloader.this.orderId, i));
                                        }
                                        NASProductGenerator.this.saveZipFileOfUnzippedFileCollection(NasProductDownloader.this.userId, NasProductDownloader.this.orderId, resultFiles);
                                        isZip = true;
                                    } else {
                                        NASProductGenerator.this.unzipAndSaveFile(NasProductDownloader.this.userId, NasProductDownloader.this.orderId, NASProductGenerator.this.manager.getResultGZip(sessionId, NasProductDownloader.this.orderId));
                                    }
                                    if (NasProductDownloader.this.isDxf) {
                                        try {
                                            ActionTask at = NASProductGenerator.this.dxfConverter.createDxfActionTask(NasProductDownloader.this.params, NASProductGenerator.this.getNasFileForOrder(NasProductDownloader.this.orderId, NasProductDownloader.this.userId, isZip), isZip);
                                            if (at.getKey() == null) {
                                                return;
                                            }
                                            Future<File> converterFuture = NASProductGenerator.this.dxfConverter.getResult(at.getKey());
                                            File dxfFile = converterFuture.get();
                                            File resultDxfFile = new File(NASProductGenerator.this.determineFileName(NasProductDownloader.this.userId, NasProductDownloader.this.orderId, ".dxf"));
                                            IOUtils.copy((InputStream)new FileInputStream(dxfFile), (OutputStream)new FileOutputStream(resultDxfFile));
                                        }
                                        catch (InterruptedException ex) {
                                            NASProductGenerator.this.log.error((Object)"DXF Converter Thread was interrupted", (Throwable)ex);
                                        }
                                        catch (ExecutionException ex) {
                                            NASProductGenerator.this.log.error((Object)"Error during the execution of the dxf converter thread", (Throwable)ex);
                                        }
                                        catch (Exception ex) {
                                            NASProductGenerator.this.log.error((Object)ex.getMessage(), (Throwable)ex);
                                        }
                                    }
                                    NASProductGenerator.this.removeFromOpenOrders(NasProductDownloader.this.userId, NasProductDownloader.this.orderId);
                                    NASProductGenerator.this.downloaderMap.remove(NasProductDownloader.this.orderId);
                                    break block14;
                                }
                                NASProductGenerator.this.log.info((Object)("interrupting the download of nas order " + NasProductDownloader.this.orderId));
                            }
                            catch (RemoteException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }, 3000L, 3000L);
            }
            catch (Exception ex) {
                NASProductGenerator.this.log.warn((Object)"Could not connect to 3A server", (Throwable)ex);
            }
        }

        public void setInterrupted(boolean interrupted) {
            this.interrupted = interrupted;
        }
    }
}

