/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenAnfrageBean;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenJob;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenJobInfoWrapper;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenProperties;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenException;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class VermessungsunterlagenHandler
implements ConnectionContextProvider {
    private static final transient Logger LOG = Logger.getLogger(VermessungsunterlagenHandler.class);
    public static final String ALLOWED_TASKS_CONFIG_ATTR = "vup.tasks_allowed";
    public static final NasProduct NAS_PRODUCT_KOMPLETT;
    public static final NasProduct NAS_PRODUCT_OHNE_EIGENTUEMER;
    public static final NasProduct NAS_PRODUCT_PUNKTE;
    private static final Map<String, VermessungsunterlagenJobInfoWrapper> JOB_MAP;
    public static int MAX_BEAN_LOADING;
    private final MetaService metaService;
    private final User user;
    private final VermessungsunterlagenProperties vermessungsunterlagenProperties = VermessungsunterlagenProperties.fromServerResources();
    private final ConnectionContext connectionContext;

    public VermessungsunterlagenHandler(User user, MetaService metaService, ConnectionContext connectionContext) {
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
    }

    public VermessungsunterlagenProperties getProperties() {
        return this.vermessungsunterlagenProperties;
    }

    public String createJob(String executeJobContent) {
        return this.createJob(executeJobContent, false);
    }

    public String createJob(String executeJobContent, boolean test) {
        try {
            VermessungsunterlagenAnfrageBean anfrageBean = VermessungsunterlagenUtils.createAnfrageBean(executeJobContent);
            anfrageBean.setTest(test);
            String jobKey = anfrageBean.getZulassungsnummerVermessungsstelle() + "_" + anfrageBean.getGeschaeftsbuchnummer() + "_" + this.generateUniqueJobKey();
            VermessungsunterlagenJob job = new VermessungsunterlagenJob(jobKey, anfrageBean, this.getProperties(), this.getUser(), this.getMetaService(), this.getConnectionContext());
            try {
                this.persistJobCidsBean(job, executeJobContent);
                CismetExecutors.newSingleThreadExecutor().execute(job);
            }
            catch (Exception ex) {
                LOG.info((Object)"error while persisting Job", (Throwable)ex);
                job.setStatus(VermessungsunterlagenJob.Status.ERROR);
                job.setException(new VermessungsunterlagenException("Der Datensatz konnte nicht abgespeichert werden.", ex));
            }
            JOB_MAP.put(jobKey, new VermessungsunterlagenJobInfoWrapper(job));
            return jobKey;
        }
        catch (Exception ex) {
            LOG.error((Object)"Unexpected error while creating job !", (Throwable)ex);
            return null;
        }
    }

    public CidsBean loadCidsBean(LightweightMetaObject lwmo) throws Exception {
        return this.getMetaService().getMetaObject(this.getUser(), lwmo.getObjectID(), lwmo.getClassID(), this.getConnectionContext()).getBean();
    }

    public CidsBean loadCidsBean(MetaObjectNode mon) throws Exception {
        return this.getMetaService().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext()).getBean();
    }

    private String generateUniqueJobKey() throws Exception {
        String jobKey;
        while (this.isJobKeyAlreadyExisting(jobKey = RandomStringUtils.randomAlphanumeric((int)8))) {
        }
        return jobKey;
    }

    private boolean isJobKeyAlreadyExisting(String jobKey) throws Exception {
        if (JOB_MAP.containsKey(jobKey)) {
            return true;
        }
        MetaClass mc_VERMESSUNGSUNTERLAGENAUFTRAG = this.getMetaService().getClassByTableName(this.getUser(), "vermessungsunterlagenauftrag", this.getConnectionContext());
        ArrayList result = this.getMetaService().performCustomSearch("SELECT schluessel FROM " + mc_VERMESSUNGSUNTERLAGENAUFTRAG + " WHERE schluessel LIKE '" + jobKey + "'", this.getConnectionContext());
        return !result.isEmpty();
    }

    public void cleanup(String jobKey) {
        VermessungsunterlagenJobInfoWrapper infoWrapper = JOB_MAP.get(jobKey);
        if (infoWrapper != null) {
            infoWrapper.cleanup();
        }
    }

    public VermessungsunterlagenJobInfoWrapper getJobInfo(String jobkey) {
        if (JOB_MAP.containsKey(jobkey)) {
            return JOB_MAP.get(jobkey);
        }
        return null;
    }

    private void persistJobCidsBean(VermessungsunterlagenJob job, String executeJobContent) throws Exception {
        CidsBean pnr;
        CidsBean geomBean;
        Polygon geometry;
        VermessungsunterlagenAnfrageBean anfrageBean = job.getAnfrageBean();
        MetaClass mc_GEOM = this.getMetaService().getClassByTableName(this.getUser(), "geom", this.getConnectionContext());
        MetaClass mc_VERMESSUNGSUNTERLAGENAUFTRAG_PUNKTNUMMER = this.getMetaService().getClassByTableName(this.getUser(), "vermessungsunterlagenauftrag_punktnummer", this.getConnectionContext());
        MetaClass mc_VERMESSUNGSUNTERLAGENAUFTRAG = this.getMetaService().getClassByTableName(this.getUser(), "vermessungsunterlagenauftrag", this.getConnectionContext());
        MetaClass mc_VERMESSUNGSUNTERLAGENAUFTRAG_VERMESSUNGSART = this.getMetaService().getClassByTableName(this.getUser(), "vermessungsunterlagenauftrag_vermessungsart", this.getConnectionContext());
        MetaClass mc_VERMESSUNGSUNTERLAGENAUFTRAG_FLURSTUECK = this.getMetaService().getClassByTableName(this.getUser(), "vermessungsunterlagenauftrag_flurstueck", this.getConnectionContext());
        Polygon[] aparr = anfrageBean.getAnfragepolygonArray();
        Polygon polygon = geometry = aparr != null && aparr.length > 0 ? aparr[0] : null;
        if (geometry != null) {
            geometry.setSRID(25832);
            geomBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)mc_GEOM.getTableName(), (ConnectionContext)this.getConnectionContext());
            geomBean.setProperty("geo_field", (Object)geometry);
        } else {
            geomBean = null;
        }
        CidsBean jobCidsBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)mc_VERMESSUNGSUNTERLAGENAUFTRAG.getTableName(), (ConnectionContext)this.getConnectionContext());
        jobCidsBean.setProperty("portalversion", (Object)anfrageBean.getPortalVersion());
        jobCidsBean.setProperty("executejob_json", (Object)executeJobContent);
        jobCidsBean.setProperty("schluessel", (Object)job.getKey());
        jobCidsBean.setProperty("geometrie", (Object)geomBean);
        jobCidsBean.setProperty("aktenzeichen", (Object)anfrageBean.getAktenzeichenKatasteramt());
        if (anfrageBean.getAntragsflurstuecksArray() != null) {
            for (VermessungsunterlagenAnfrageBean.AntragsflurstueckBean flurstueckBean : anfrageBean.getAntragsflurstuecksArray()) {
                CidsBean flurstueck = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)mc_VERMESSUNGSUNTERLAGENAUFTRAG_FLURSTUECK.getTableName(), (ConnectionContext)this.getConnectionContext());
                flurstueck.setProperty("gemarkung", (Object)flurstueckBean.getGemarkungsID());
                flurstueck.setProperty("flur", (Object)flurstueckBean.getFlurID());
                flurstueck.setProperty("flurstueck", (Object)flurstueckBean.getFlurstuecksID());
                jobCidsBean.getBeanCollectionProperty("flurstuecke").add(flurstueck);
            }
        }
        if (anfrageBean.getPunktnummernreservierungsArray() != null) {
            for (VermessungsunterlagenAnfrageBean.PunktnummernreservierungBean pnrBean : anfrageBean.getPunktnummernreservierungsArray()) {
                pnr = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)mc_VERMESSUNGSUNTERLAGENAUFTRAG_PUNKTNUMMER.getTableName(), (ConnectionContext)this.getConnectionContext());
                pnr.setProperty("anzahl", (Object)pnrBean.getAnzahlPunktnummern());
                pnr.setProperty("katasteramt", (Object)pnrBean.getKatasteramtsID());
                pnr.setProperty("kilometerquadrat", (Object)pnrBean.getUtmKilometerQuadrat());
                jobCidsBean.getBeanCollectionProperty("punktnummern").add(pnr);
            }
        }
        jobCidsBean.setProperty("mit_grenzniederschriften", (Object)anfrageBean.getMitGrenzniederschriften());
        jobCidsBean.setProperty("geschaeftsbuchnummer", (Object)anfrageBean.getGeschaeftsbuchnummer());
        jobCidsBean.setProperty("auftragsnummer", (Object)anfrageBean.getKatasteramtAuftragsnummer());
        jobCidsBean.setProperty("katasteramtsid", (Object)anfrageBean.getKatasteramtsId());
        jobCidsBean.setProperty("vermessungsstelle", (Object)anfrageBean.getZulassungsnummerVermessungsstelle());
        jobCidsBean.setProperty("nur_punktnummernreservierung", (Object)anfrageBean.getNurPunktnummernreservierung());
        jobCidsBean.setProperty("mit_alkisbestandsdatenmiteigentuemerinfo", (Object)anfrageBean.getMitAlkisBestandsdatenmitEigentuemerinfo());
        jobCidsBean.setProperty("mit_alkisbestandsdatenohneeigentuemerinfo", (Object)anfrageBean.getMitAlkisBestandsdatenohneEigentuemerinfo());
        jobCidsBean.setProperty("mit_alkisbestandsdatennurpunkte", (Object)anfrageBean.getMitAlkisBestandsdatennurPunkte());
        jobCidsBean.setProperty("mit_punktnummernreservierung", (Object)anfrageBean.getMitPunktnummernreservierung());
        jobCidsBean.setProperty("mit_risse", (Object)anfrageBean.getMitRisse());
        jobCidsBean.setProperty("mit_apuebersichten", (Object)anfrageBean.getMitAPUebersichten());
        jobCidsBean.setProperty("mit_apkarten", (Object)anfrageBean.getMitAPKarten());
        jobCidsBean.setProperty("mit_apbeschreibungen", (Object)anfrageBean.getMitAPBeschreibungen());
        jobCidsBean.setProperty("anonym", (Object)anfrageBean.getAnonymousOrder());
        try {
            jobCidsBean.setProperty("saumap", (Object)Integer.parseInt(anfrageBean.getSaumAPSuche()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (anfrageBean.getArtderVermessung() != null) {
            for (String art : anfrageBean.getArtderVermessung()) {
                pnr = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)mc_VERMESSUNGSUNTERLAGENAUFTRAG_VERMESSUNGSART.getTableName(), (ConnectionContext)this.getConnectionContext());
                pnr.setProperty("name", (Object)art);
                jobCidsBean.getBeanCollectionProperty("vermessungsarten").add(pnr);
            }
        }
        jobCidsBean.setProperty("timestamp", (Object)new Timestamp(new Date().getTime()));
        jobCidsBean.setProperty("tasks", (Object)Arrays.toString(this.getAllowedTasks().toArray()));
        jobCidsBean.setProperty("test", (Object)anfrageBean.isTest());
        job.setCidsBean(this.getMetaService().insertMetaObject(this.getUser(), jobCidsBean.getMetaObject(), this.getConnectionContext()).getBean());
    }

    public Collection<String> getAllowedTasks() throws Exception {
        String rawAllowedTasks = DomainServerImpl.getServerInstance().getConfigAttr(this.getUser(), ALLOWED_TASKS_CONFIG_ATTR, this.getConnectionContext());
        ArrayList<String> allowedTasks = new ArrayList<String>();
        if (rawAllowedTasks != null) {
            for (String allowedTask : Arrays.asList(rawAllowedTasks.split("\n"))) {
                if (allowedTask == null) continue;
                allowedTasks.add(allowedTask.trim());
            }
        }
        return allowedTasks;
    }

    public final void updateJobCidsBeanZip(VermessungsunterlagenJob job, String zipDateiname) throws Exception {
        CidsBean jobCidsBean = job.getCidsBean();
        jobCidsBean.setProperty("zip_pfad", (Object)zipDateiname);
        jobCidsBean.setProperty("zip_timestamp", (Object)new Timestamp(new Date().getTime()));
        this.getMetaService().updateMetaObject(this.getUser(), jobCidsBean.getMetaObject(), this.getConnectionContext());
    }

    public final void updateJobCidsBeanStatus(VermessungsunterlagenJob job, Boolean status) throws Exception {
        CidsBean jobCidsBean = job.getCidsBean();
        jobCidsBean.setProperty("status", (Object)status);
        jobCidsBean.setProperty("status_timestamp", (Object)new Timestamp(new Date().getTime()));
        this.getMetaService().updateMetaObject(this.getUser(), jobCidsBean.getMetaObject(), this.getConnectionContext());
    }

    public final void updateJobCidsBeanFlurstueckGeom(VermessungsunterlagenJob job, Geometry geom) throws Exception {
        CidsBean geomBean;
        CidsBean jobCidsBean = job.getCidsBean();
        MetaClass mc_GEOM = this.getMetaService().getClassByTableName(this.getUser(), "geom", this.getConnectionContext());
        if (geom != null) {
            geomBean = (CidsBean)jobCidsBean.getProperty("geometrie_flurstuecke");
            if (geomBean == null) {
                geomBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)mc_GEOM.getTableName(), (ConnectionContext)this.getConnectionContext());
            }
            geomBean.setProperty("geo_field", (Object)geom);
        } else {
            geomBean = null;
        }
        jobCidsBean.setProperty("geometrie_flurstuecke", (Object)geomBean);
        this.getMetaService().updateMetaObject(this.getUser(), jobCidsBean.getMetaObject(), this.getConnectionContext());
    }

    public final void updateJobCidsBeanException(VermessungsunterlagenJob job, Exception ex) throws Exception {
        CidsBean jobCidsBean = job.getCidsBean();
        jobCidsBean.setProperty("exception_json", (Object)VermessungsunterlagenUtils.getExceptionJson(ex));
        jobCidsBean.setProperty("exception_timestamp", (Object)new Timestamp(new Date().getTime()));
        this.getMetaService().updateMetaObject(this.getUser(), jobCidsBean.getMetaObject(), this.getConnectionContext());
    }

    public void test() {
        try {
            File directory;
            if (this.vermessungsunterlagenProperties.getAbsPathTest() != null && !this.vermessungsunterlagenProperties.getAbsPathTest().isEmpty() && (directory = new File(this.vermessungsunterlagenProperties.getAbsPathTest())).exists()) {
                File[] executeJobFiles;
                for (final File executeJobFile : executeJobFiles = directory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("executeJob.") && name.endsWith(".json");
                    }
                })) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"----");
                                    LOG.debug((Object)("Path: " + executeJobFile.getAbsolutePath()));
                                }
                                String executeJobContent = IOUtils.toString((InputStream)new FileInputStream(executeJobFile));
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Content: " + executeJobContent));
                                }
                                String jobkey = VermessungsunterlagenHandler.this.createJob(executeJobContent, true);
                                LOG.info((Object)("Job created: " + jobkey));
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex, (Throwable)ex);
                            }
                        }
                    }).start();
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public final MetaService getMetaService() {
        return this.metaService;
    }

    public final User getUser() {
        return this.user;
    }

    public Collection performSearch(CidsServerSearch serverSearch) throws SearchException {
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("WUNDA_BLAU", this.getMetaService());
        serverSearch.setActiveLocalServers(localServers);
        serverSearch.setUser(this.getUser());
        return serverSearch.performServerSearch();
    }

    public Collection<CidsBean> loadBeans(Collection<MetaObjectNode> mons) throws Exception {
        if (mons != null) {
            if (mons.size() > MAX_BEAN_LOADING) {
                throw new Exception("Zu viele Objekte gefunden. Bitte Fehler melden !");
            }
            ArrayList<CidsBean> beans = new ArrayList<CidsBean>(mons.size());
            for (MetaObjectNode mon : mons) {
                if (mon == null) continue;
                MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                mo.setAllClasses(((MetaClassCacheService)Lookup.getDefault().lookup(MetaClassCacheService.class)).getAllClasses(mo.getDomain(), this.getConnectionContext()));
                beans.add(mo.getBean());
            }
            return beans;
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        NasProduct productPunkte = null;
        NasProduct productOhneEigentuemer = null;
        NasProduct productKomplett = null;
        try {
            ArrayList nasProducts = (ArrayList)mapper.readValue((Reader)ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.NAS_PRODUCT_DESCRIPTION_JSON.getValue()), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, NasProduct.class));
            for (NasProduct nasProduct : nasProducts) {
                if ("punkte".equals(nasProduct.getKey())) {
                    productPunkte = nasProduct;
                    continue;
                }
                if ("ohne_eigentuemer".equals(nasProduct.getKey())) {
                    productOhneEigentuemer = nasProduct;
                    continue;
                }
                if (!"komplett".equals(nasProduct.getKey())) continue;
                productKomplett = nasProduct;
            }
        }
        catch (Exception ex) {
            String message = "could not load NasProducts";
            LOG.error((Object)"could not load NasProducts", (Throwable)ex);
            throw new RuntimeException("could not load NasProducts", ex);
        }
        NAS_PRODUCT_PUNKTE = productPunkte;
        NAS_PRODUCT_OHNE_EIGENTUEMER = productOhneEigentuemer;
        NAS_PRODUCT_KOMPLETT = productKomplett;
        JOB_MAP = new ConcurrentHashMap<String, VermessungsunterlagenJobInfoWrapper>();
        MAX_BEAN_LOADING = 1000;
    }
}

