/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenAnfrageBean;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenFtpHelper;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenHandler;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenProperties;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTask;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenValidator;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenWebdavHelper;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenJobException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskAPList;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskAPMap;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskAPUebersicht;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNasKomplett;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNasOhneEigentuemer;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNasPunkte;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNivPBeschreibungen;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNivPUebersicht;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskPNR;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskRisseBilder;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskRisseGrenzniederschrift;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMeasurementPointSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.CidsVermessungRissSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;

public class VermessungsunterlagenJob
implements Runnable,
ConnectionContextProvider {
    private static final transient Logger LOG = Logger.getLogger(VermessungsunterlagenJob.class);
    private final ConnectionContext connectionContext;
    private final String key;
    private final VermessungsunterlagenAnfrageBean anfrageBean;
    private Status status = Status.WAITING;
    private VermessungsunterlagenException exception;
    private final Map<VermessungsunterlagenTask, Future> taskMap = new HashMap<VermessungsunterlagenTask, Future>();
    private String ftpZipPath;
    private String webDAVPath;
    private final transient ThreadPoolExecutor taskExecutor = (ThreadPoolExecutor)CismetExecutors.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors());
    private final transient CompletionService<VermessungsunterlagenTask> completionService = new ExecutorCompletionService<VermessungsunterlagenTask>(this.taskExecutor);
    private final transient VermessungsunterlagenHandler helper;
    private final transient VermessungsunterlagenValidator validator;
    private transient CidsBean cidsBean;
    private final transient Collection<String> allowedTask;
    private final User user;
    private final MetaService metaService;
    private final VermessungsunterlagenProperties properties;

    public VermessungsunterlagenJob(String jobkey, VermessungsunterlagenAnfrageBean anfrageBean, VermessungsunterlagenProperties properties, User user, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        this.key = jobkey;
        this.anfrageBean = anfrageBean;
        this.properties = properties;
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
        this.helper = new VermessungsunterlagenHandler(user, metaService, connectionContext);
        this.validator = new VermessungsunterlagenValidator(this.helper, connectionContext);
        this.allowedTask = this.helper.getAllowedTasks();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setStatus(Status status) {
        LOG.info((Object)("Job changed (" + this.getKey() + "): " + status.toString()));
        this.status = status;
        try {
            switch (status) {
                case OK: {
                    this.helper.updateJobCidsBeanStatus(this, Boolean.TRUE);
                    break;
                }
                case ERROR: {
                    this.helper.updateJobCidsBeanStatus(this, Boolean.FALSE);
                    break;
                }
                default: {
                    this.helper.updateJobCidsBeanStatus(this, null);
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"error Updating Status of cidsbean", (Throwable)ex);
        }
    }

    public void submitTask(VermessungsunterlagenTask task) throws Exception {
        if (this.isTaskAllowed(task.getType())) {
            task.setProperties(this.getProperties());
            task.setUser(this.getUser());
            task.setMetaService(this.getMetaService());
            task.initWithConnectionContext(this.getConnectionContext());
            this.taskMap.put(task, this.completionService.submit(task));
        } else {
            LOG.info((Object)("Not allowed to run task of Type " + task.getType() + "."));
        }
    }

    public boolean isTaskAllowed(String type) {
        return this.allowedTask.contains(type);
    }

    public void setException(VermessungsunterlagenException exception) {
        this.exception = exception;
    }

    private Collection<CidsBean> searchRisse(Geometry geometry) throws Exception {
        List<String> schluesselCollection = Arrays.asList("503", "504", "505", "506", "507", "508");
        CidsVermessungRissSearchStatement serverSearch = new CidsVermessungRissSearchStatement(null, null, null, null, schluesselCollection, geometry, null);
        Collection mons = this.helper.performSearch((CidsServerSearch)serverSearch);
        return this.helper.loadBeans(mons);
    }

    private Collection<CidsBean> searchAPs(Geometry geometry) throws Exception {
        CidsMeasurementPointSearchStatement serverSearch = new CidsMeasurementPointSearchStatement("", Arrays.asList(CidsMeasurementPointSearchStatement.Pointtype.AUFNAHMEPUNKTE, CidsMeasurementPointSearchStatement.Pointtype.SONSTIGE_VERMESSUNGSPUNKTE), null, geometry);
        Collection mons = this.helper.performSearch((CidsServerSearch)serverSearch);
        return this.helper.loadBeans(mons);
    }

    private Collection<CidsBean> searchNivPs(Geometry geometry) throws Exception {
        CidsMeasurementPointSearchStatement serverSearch = new CidsMeasurementPointSearchStatement("", Arrays.asList(CidsMeasurementPointSearchStatement.Pointtype.NIVELLEMENT_PUNKTE), null, geometry);
        Collection mons = this.helper.performSearch((CidsServerSearch)serverSearch);
        return this.helper.loadBeans(mons);
    }

    private Geometry createGeometryFrom(Collection<CidsBean> cidsBeans, Geometry intersectionGeometry) throws Exception {
        Geometry geometry = null;
        for (CidsBean cidsBean : cidsBeans) {
            Geometry fsGeometry;
            if (cidsBean.getProperty("geometrie") instanceof Geometry) {
                fsGeometry = (Geometry)cidsBean.getProperty("geometrie");
                geometry = geometry == null ? fsGeometry : geometry.union(fsGeometry);
                continue;
            }
            fsGeometry = (Geometry)cidsBean.getProperty("geometrie.geo_field");
            geometry = geometry == null ? fsGeometry : geometry.union(fsGeometry);
        }
        if (geometry != null && intersectionGeometry != null) {
            geometry = geometry.intersection(intersectionGeometry);
        }
        if (geometry != null) {
            geometry.setSRID(25832);
        }
        return geometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block33: {
            this.setStatus(Status.WORKING);
            try {
                VermessungsunterlagenAnfrageBean anfrageBean = this.getAnfrageBean();
                if (!this.validator.validateAndGetErrorMessage(anfrageBean)) break block33;
                try {
                    Geometry vermessungsGeometrieSaum;
                    Polygon vermessungsGeometrie;
                    new File(this.getPath()).mkdirs();
                    int saum = Integer.parseInt(anfrageBean.getSaumAPSuche());
                    Polygon polygon = vermessungsGeometrie = anfrageBean.getAnfragepolygonArray() != null && anfrageBean.getAnfragepolygonArray()[0] != null ? anfrageBean.getAnfragepolygonArray()[0] : null;
                    if (vermessungsGeometrie != null) {
                        vermessungsGeometrieSaum = vermessungsGeometrie.buffer((double)saum);
                        vermessungsGeometrieSaum.setSRID(vermessungsGeometrie.getSRID());
                    } else {
                        vermessungsGeometrieSaum = null;
                    }
                    Geometry geometryFlurstuecke = this.createGeometryFrom(this.validator.getFlurstuecke(), (Geometry)(this.validator.isGeometryFromFlurstuecke() ? null : vermessungsGeometrie));
                    this.helper.updateJobCidsBeanFlurstueckGeom(this, geometryFlurstuecke);
                    if ((!this.validator.isVermessungsstelleKnown() || this.validator.isPnrNotZero()) && anfrageBean.isMitPunktnummernreservierung()) {
                        this.submitTask(new VermUntTaskPNR(this.getKey(), anfrageBean.getZulassungsnummerVermessungsstelle(), anfrageBean.getGeschaeftsbuchnummer(), anfrageBean.getPunktnummernreservierungsArray()));
                    }
                    Collection<CidsBean> aPs = !(vermessungsGeometrieSaum == null || !anfrageBean.isMitAPKarten() && !anfrageBean.isMitAPBeschreibungen() && !anfrageBean.isMitAPUebersichten() || !this.isTaskAllowed("AP_Karten") && !this.isTaskAllowed("AP_List") && !this.isTaskAllowed("AP_Uebersicht")) ? this.searchAPs(vermessungsGeometrieSaum) : null;
                    Collection<CidsBean> nivPs = !(vermessungsGeometrieSaum == null || !anfrageBean.isMitNIVPBeschreibungen() && !anfrageBean.isMitNIVPUebersichten() || !this.isTaskAllowed("NivP_Beschreibungen") && !this.isTaskAllowed("NivP_Uebersicht")) ? this.searchNivPs(vermessungsGeometrieSaum) : null;
                    Collection<CidsBean> risse = anfrageBean.isMitRisse() && this.isTaskAllowed("RISSE_Bilder") || anfrageBean.isMitGrenzniederschriften() && this.isTaskAllowed("RISSE_ErgaenzendeDokumente") && geometryFlurstuecke != null ? this.searchRisse(geometryFlurstuecke) : null;
                    if (aPs != null && !aPs.isEmpty()) {
                        if (anfrageBean.isMitAPKarten()) {
                            this.submitTask(new VermUntTaskAPMap(this.getKey(), aPs));
                        }
                        if (anfrageBean.isMitAPBeschreibungen()) {
                            this.submitTask(new VermUntTaskAPList(this.getKey(), aPs));
                        }
                        if (anfrageBean.isMitAPUebersichten()) {
                            this.submitTask(new VermUntTaskAPUebersicht(this.getKey(), aPs, this.validator.getFlurstuecke(), anfrageBean.getGeschaeftsbuchnummer()));
                        }
                    }
                    if (nivPs != null && !nivPs.isEmpty()) {
                        if (anfrageBean.isMitNIVPBeschreibungen()) {
                            this.submitTask(new VermUntTaskNivPBeschreibungen(this.getKey(), nivPs));
                        }
                        if (anfrageBean.isMitNIVPUebersichten()) {
                            this.submitTask(new VermUntTaskNivPUebersicht(this.getKey(), nivPs, this.validator.getFlurstuecke(), anfrageBean.getGeschaeftsbuchnummer()));
                        }
                    }
                    String requestId = this.getKey();
                    if (anfrageBean.isMitAlkisBestandsdatenmitEigentuemerinfo() && vermessungsGeometrie != null) {
                        this.submitTask(new VermUntTaskNasKomplett(this.getKey(), requestId, (Geometry)vermessungsGeometrie, Boolean.TRUE.equals(anfrageBean.getAnonymousOrder())));
                    }
                    if (anfrageBean.isMitAlkisBestandsdatennurPunkte() && vermessungsGeometrieSaum != null) {
                        this.submitTask(new VermUntTaskNasPunkte(this.getKey(), requestId, vermessungsGeometrieSaum, Boolean.TRUE.equals(anfrageBean.getAnonymousOrder())));
                    }
                    if (anfrageBean.isMitAlkisBestandsdatenohneEigentuemerinfo() && this.isTaskAllowed("NAS_OhneEigentuemer")) {
                        this.submitTask(new VermUntTaskNasOhneEigentuemer(this.getKey(), requestId, vermessungsGeometrieSaum, Boolean.TRUE.equals(anfrageBean.getAnonymousOrder())));
                    }
                    if (risse != null && !risse.isEmpty()) {
                        if (anfrageBean.isMitRisse()) {
                            this.submitTask(new VermUntTaskRisseBilder(this.getKey(), risse, anfrageBean.getGeschaeftsbuchnummer(), ""));
                        }
                        if (anfrageBean.isMitGrenzniederschriften()) {
                            this.submitTask(new VermUntTaskRisseGrenzniederschrift(this.getKey(), risse, anfrageBean.getGeschaeftsbuchnummer(), ""));
                        }
                    }
                    for (int received = 0; received < this.taskMap.size(); ++received) {
                        Future<VermessungsunterlagenTask> resultFuture = this.completionService.take();
                        VermessungsunterlagenTask task = resultFuture.get();
                        if (this.validator.isIgnoreError() || !VermessungsunterlagenTask.Status.ERROR.equals((Object)task.getStatus())) continue;
                        throw new VermessungsunterlagenJobException("Ein unerwarteter Fehler ist beim Ausf\u00fchren des Tasks " + task.getType() + " aufgetreten.\n Bitte wenden Sie sich an das Geodatenzentrum der Stadt Wuppertal " + " E-Mail: geodatenzentrum@stadt.wuppertal.de  Tel.: +49 202 563 5399 " + ".", task.getException());
                    }
                    String zipFilePath = this.getPath() + ".zip";
                    File zipFile = new File(zipFilePath);
                    this.zipDirectoryTo(zipFile);
                    this.uploadZip(zipFile);
                    try {
                        this.helper.updateJobCidsBeanZip(this, zipFilePath);
                    }
                    catch (Exception ex2) {
                        LOG.error((Object)("Error while updating cids bean for " + this.getKey()), (Throwable)ex2);
                    }
                    this.setStatus(Status.OK);
                }
                catch (Exception ex) {
                    VermessungsunterlagenUtils.writeExceptionJson(ex, this.getPath() + "/fehlerprotokoll.json");
                    throw ex;
                }
                finally {
                    this.taskExecutor.shutdown();
                }
            }
            catch (Exception ex) {
                VermessungsunterlagenException vermessungsunterlagenException;
                if (ex instanceof VermessungsunterlagenException) {
                    vermessungsunterlagenException = (VermessungsunterlagenException)ex;
                } else {
                    LOG.error((Object)"unexpected error while excecution VermessungsunterlagenJob !", (Throwable)ex);
                    vermessungsunterlagenException = new VermessungsunterlagenException("Ein unerwarter Fehler ist aufgetreten!", ex);
                }
                this.setException(vermessungsunterlagenException);
                this.setStatus(Status.ERROR);
                try {
                    this.helper.updateJobCidsBeanException(this, vermessungsunterlagenException);
                }
                catch (Exception ex2) {
                    LOG.error((Object)("Error while updating cids bean for " + this.getKey()), (Throwable)ex2);
                }
            }
            finally {
                this.helper.cleanup(this.getKey());
            }
        }
    }

    public static void configure4LumbermillOn(String host, int port, String level) {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        builder.setStatusLevel(Level.WARN);
        builder.setConfigurationName("DynamicConfig");
        AppenderComponentBuilder socketAppender = (AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("Remote", "Socket").addAttribute("host", host)).addAttribute("port", port);
        socketAppender.add(builder.newLayout("JsonLayout"));
        builder.add(socketAppender);
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);
        builder.add(rootLogger);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = (Configuration)builder.build();
        ctx.start(conf);
    }

    public void uploadZip(File file) throws VermessungsunterlagenException {
        if (this.helper.getProperties().isFtpEnabled()) {
            try {
                this.ftpZipPath = this.uploadZipToFTP(file);
            }
            catch (Exception ex) {
                this.ftpZipPath = null;
                throw new VermessungsunterlagenException("Fehler beim Hochladen der Zip-Datei auf den FTP-Server.", ex);
            }
        }
        if (this.helper.getProperties().isWebDavEnabled()) {
            try {
                this.webDAVPath = this.uploadZipToWebDAV(file);
            }
            catch (Exception ex) {
                this.webDAVPath = null;
                throw new VermessungsunterlagenException("Fehler beim Hochladen der Zip-Datei auf den WebDAV-Server.", ex);
            }
        }
    }

    private String uploadZipToFTP(File file) throws Exception {
        String fileName = file.getName();
        FileInputStream inputStream = new FileInputStream(file);
        String ftpPath = this.getHelper().getProperties().getFtpPath();
        String ftpZipPath = (ftpPath.isEmpty() ? "" : "/" + ftpPath) + fileName;
        new VermessungsunterlagenFtpHelper().uploadToFTP(inputStream, ftpZipPath);
        return ftpZipPath;
    }

    private String uploadZipToWebDAV(File file) throws Exception {
        String fileName = file.getName();
        FileInputStream inputStream = new FileInputStream(file);
        String webDAVPath = this.getHelper().getProperties().getWebDavPath();
        String webDAVZipPath = (webDAVPath.isEmpty() ? "" : "/" + webDAVPath) + fileName;
        new VermessungsunterlagenWebdavHelper().uploadToWebDAV(inputStream, webDAVZipPath);
        return webDAVZipPath;
    }

    private void zipDirectoryTo(File file) throws VermessungsunterlagenException {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(file));){
            this.addDirectoryToZip("", this.getPath(), zipOut);
            zipOut.flush();
        }
        catch (Exception ex) {
            throw new VermessungsunterlagenException("Fehler beim erzeugen der ZIP-Datei", ex);
        }
    }

    private void addFileToZip(String path, String fileName, ZipOutputStream zipOut, boolean flag) throws Exception {
        File file = new File(fileName);
        if (flag) {
            zipOut.putNextEntry(new ZipEntry(path + "/" + file.getName() + "/"));
        } else if (file.isDirectory()) {
            this.addDirectoryToZip(path, fileName, zipOut);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(fileName);
            zipOut.putNextEntry(new ZipEntry(path + "/" + file.getName()));
            while ((len = in.read(buf)) > 0) {
                zipOut.write(buf, 0, len);
            }
        }
    }

    private void addDirectoryToZip(String path, String dirName, ZipOutputStream zipOut) throws Exception {
        File dir = new File(dirName);
        if (dir.isDirectory()) {
            if (dir.list().length == 0) {
                this.addFileToZip(path, dirName, zipOut, true);
            } else {
                for (String filename : dir.list()) {
                    if (path.isEmpty()) {
                        this.addFileToZip(dir.getName(), dirName + "/" + filename, zipOut, false);
                        continue;
                    }
                    this.addFileToZip(path + "/" + dir.getName(), dirName + "/" + filename, zipOut, false);
                }
            }
        }
    }

    public String getPath() {
        return this.getProperties().getPath(this.getKey());
    }

    public String getKey() {
        return this.key;
    }

    public VermessungsunterlagenAnfrageBean getAnfrageBean() {
        return this.anfrageBean;
    }

    public Status getStatus() {
        return this.status;
    }

    public VermessungsunterlagenException getException() {
        return this.exception;
    }

    public Map<VermessungsunterlagenTask, Future> getTaskMap() {
        return this.taskMap;
    }

    public String getFtpZipPath() {
        return this.ftpZipPath;
    }

    public String getWebDAVPath() {
        return this.webDAVPath;
    }

    public VermessungsunterlagenHandler getHelper() {
        return this.helper;
    }

    public VermessungsunterlagenValidator getValidator() {
        return this.validator;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
    }

    public Collection<String> getAllowedTask() {
        return this.allowedTask;
    }

    public User getUser() {
        return this.user;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public VermessungsunterlagenProperties getProperties() {
        return this.properties;
    }

    public static enum Status {
        WAITING,
        WORKING,
        ERROR,
        OK;

    }
}

