/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskAP;
import de.cismet.cids.dynamics.CidsBean;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;

public class VermUntTaskAPList
extends VermUntTaskAP {
    public static final String TYPE = "AP_List";

    public VermUntTaskAPList(String jobkey, Collection<CidsBean> alkisPoints) {
        super(TYPE, jobkey, alkisPoints);
    }

    @Override
    public void performTask() throws VermessungsunterlagenTaskException {
        String punktListenString = VermUntTaskAPList.getPunktlistenStringForChosenPoints(this.getAlkisPoints());
        String code = ServerAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_TXT);
        String filename = this.getPath() + "/" + ServerAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_TXT) + ".plst";
        File fileToSaveTo = new File(filename);
        if (punktListenString.length() > 3 && code != null && code.length() > 0) {
            String url = null;
            try {
                url = ServerAlkisProducts.getInstance().productListenNachweisUrl(punktListenString, code).toString();
            }
            catch (MalformedURLException ex) {
                String message = "Beim Generieren der URL kam es zu einem unerwarteten Fehler.";
                throw new VermessungsunterlagenTaskException(this.getType(), "Beim Generieren der URL kam es zu einem unerwarteten Fehler.", ex);
            }
            if (url != null && url.trim().length() > 0) {
                URL getOrPostUrl;
                String parameters;
                int parameterPosition = url.indexOf(63);
                try {
                    if (parameterPosition < 0) {
                        parameters = null;
                        getOrPostUrl = new URL(url);
                    } else {
                        parameters = url.substring(parameterPosition + 1);
                        getOrPostUrl = new URL(url.substring(0, parameterPosition));
                    }
                }
                catch (Exception ex) {
                    String message = "Beim Erstellen der AP-Listen URL '" + url + "' kam es zu einem unerwarteten Fehler.";
                    throw new VermessungsunterlagenTaskException(this.getType(), message, ex);
                }
                try (InputStream in = parameters == null || parameters.trim().length() <= 0 ? VermessungsunterlagenUtils.doGetRequest(getOrPostUrl) : VermessungsunterlagenUtils.doPostRequest(getOrPostUrl, new StringReader(parameters));
                     FileOutputStream out = new FileOutputStream(fileToSaveTo);){
                    VermessungsunterlagenUtils.downloadStream(in, out);
                }
                catch (Exception ex) {
                    String message = "Beim Herunterladen des Produktes unter der URL '" + url + "' kam es zu einem unerwarteten Fehler.";
                    throw new VermessungsunterlagenTaskException(this.getType(), message, ex);
                }
            }
        }
    }

    private static String getPunktlistenStringForChosenPoints(Collection<CidsBean> alkisPoints) {
        StringBuffer punktListeString = new StringBuffer();
        for (CidsBean alkisPoint : alkisPoints) {
            if (punktListeString.length() > 0) {
                punktListeString.append(",");
            }
            ServerAlkisProducts.getInstance();
            punktListeString.append(ServerAlkisProducts.getPointDataForProduct(alkisPoint));
        }
        return punktListeString.toString();
    }
}

