/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMauernSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

@Deprecated
public class NasZaehlObjekteSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private static final Logger LOG = Logger.getLogger(CidsMauernSearchStatement.class);
    private static final String FLURSTUECK_STMT = "select count(*) as Anzahl from ax_flurstueck where st_intersects(wkb_geometry,<geom>)";
    private static final String GEAEUDE_STMT = "select count(*) as Anzahl from ax_gebaeude where st_intersects(wkb_geometry,<geom>)";
    private static final String DACH_PKT_STMT = "SELECT count (*) FROM sic_regen_dachpg where st_intersects(wkb_geometry,<geom>)";
    private static final String BODEN_PKT_STMT = "SELECT count (*) FROM sic_regen_bodenpg where st_intersects(wkb_geometry,<geom>)";
    private static final String ADRESE_STMT = "SELECT DISTINCT i.class_id , i.object_id, s.stringrep FROM geom g, cs_attr_object_derived i LEFT OUTER JOIN cs_cache s ON ( s.class_id =i.class_id AND s.object_id=i.object_id ) WHERE i.attr_class_id = ( SELECT cs_class.id FROM cs_class WHERE cs_class.table_name::text ILIKE 'GEOM'::text ) AND i.attr_object_id = g.id AND i.class_id IN (6) AND geo_field && st_GeometryFromText('<geom>') AND st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_buffer(st_GeometryFromText('<geom>'), " + INTERSECTS_BUFFER + ")) ORDER BY 1,2,3";
    private static Connection fmeConn = null;
    private static String url;
    private static String user;
    private static String pw;
    private static boolean initError;
    final Geometry geometry;
    final NasSearchType searchType;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public NasZaehlObjekteSearch(Geometry g, NasSearchType type) {
        this.geometry = g;
        this.searchType = type;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    private int getFlurstueckObjectsCount() throws SearchException {
        return this.getObjectsCount(FLURSTUECK_STMT);
    }

    private int getGebaeudeObjectsCount() throws SearchException {
        return this.getObjectsCount(GEAEUDE_STMT);
    }

    private int getBodenpunkteObjectsCount() throws SearchException {
        return this.getObjectsCount(BODEN_PKT_STMT);
    }

    private int getDachpunkteObjectsCount() throws SearchException {
        return this.getObjectsCount(DACH_PKT_STMT);
    }

    private synchronized int getObjectsCount(String statement) throws SearchException {
        Statement st = null;
        try {
            if (fmeConn == null || fmeConn.isClosed()) {
                NasZaehlObjekteSearch.initConnection();
            }
            st = fmeConn.createStatement();
            StringBuilder sb = new StringBuilder();
            String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
            if (this.geometry instanceof Polygon || this.geometry instanceof MultiPolygon) {
                sb.append(statement.replace("<geom>", "st_buffer(st_GeometryFromText('" + geostring + "'), 0.000001)"));
            }
            if (st != null && !fmeConn.isClosed() && !st.isClosed()) {
                st.execute(sb.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + sb.toString()));
                }
                ResultSet rs = st.getResultSet();
                rs.next();
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error during NasZaehlobjekteSearch", (Throwable)ex);
            throw new SearchException("Error during NasZaehlobjekteSearch");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private int getAddressenCount() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                StringBuilder sb = new StringBuilder();
                String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
                if (this.geometry instanceof Polygon || this.geometry instanceof MultiPolygon) {
                    sb.append(ADRESE_STMT.replace("<geom>", geostring));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + sb.toString()));
                }
                ArrayList lists = ms.performCustomSearch(sb.toString(), this.getConnectionContext());
                return lists.size();
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return 0;
    }

    private static void initConnection() throws SearchException {
        try {
            fmeConn = DriverManager.getConnection(url, user, pw);
        }
        catch (SQLException ex) {
            throw new SearchException("Error during NasZaehlObjekte search.Could not create db connection to fme_import database");
        }
    }

    public Collection performServerSearch() throws SearchException {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        if (initError) {
            LOG.warn((Object)"NasZaehlObjekteSearch initialisation error. An error during reading fme_db_con properties occured.");
            return resultList;
        }
        if (this.searchType == NasSearchType.FLURSTUECKE) {
            resultList.add(this.getFlurstueckObjectsCount());
        } else if (this.searchType == NasSearchType.GEBAEUDE) {
            resultList.add(this.getGebaeudeObjectsCount());
        } else if (this.searchType == NasSearchType.ADRESSE) {
            resultList.add(this.getAddressenCount());
        } else if (this.searchType == NasSearchType.BODENPUNKTE) {
            resultList.add(this.getBodenpunkteObjectsCount());
        } else if (this.searchType == NasSearchType.DACHPUNKTE) {
            resultList.add(this.getDachpunkteObjectsCount());
        }
        return resultList;
    }

    public static void main(String[] args) {
        NasZaehlObjekteSearch search = new NasZaehlObjekteSearch(null, NasSearchType.GEBAEUDE);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        initError = false;
        try {
            Properties serviceProperties = new Properties();
            serviceProperties.load(ServerResourcesLoader.getInstance().loadStringReader(WundaBlauServerResources.FME_DB_CONN_PROPERTIES.getValue()));
            url = serviceProperties.getProperty("connection_url");
            user = serviceProperties.getProperty("connection_username");
            pw = serviceProperties.getProperty("connection_pw");
            NasZaehlObjekteSearch.initConnection();
        }
        catch (SearchException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"error during initialisation of fme db connection.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            initError = true;
            LOG.warn((Object)"error during initialisation of fme db connection. Could not read properties file. Search disabled", (Throwable)ex);
        }
    }

    public static enum NasSearchType {
        FLURSTUECKE,
        GEBAEUDE,
        ADRESSE,
        DACHPUNKTE,
        BODENPUNKTE;

    }
}

