/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BPlanByGeometrySearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BPlanByGeometrySearch.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String QUERY_BPLAN = "select nummer || ' ' || name from bplan_verfahren join geom on (geometrie = geom.id) where st_intersects(geo_field, st_setSrid('%s'::geometry, 25832))";
    private String geom;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public BPlanByGeometrySearch(String geom) {
        this.geom = geom;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        try {
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService != null) {
                ArrayList bPlanList = metaService.performCustomSearch(String.format(QUERY_BPLAN, this.geom), this.getConnectionContext());
                String bPlanCs = null;
                if (bPlanList != null && bPlanList.size() > 0) {
                    for (ArrayList resultPart : bPlanList) {
                        if (bPlanCs != null) {
                            bPlanCs = bPlanCs + ", ";
                            bPlanCs = bPlanCs + resultPart.get(0);
                            continue;
                        }
                        bPlanCs = (String)resultPart.get(0);
                    }
                    return Arrays.asList(bPlanCs);
                }
            } else {
                LOG.error((Object)"active local server not found");
            }
            return null;
        }
        catch (Exception ex) {
            throw new SearchException("error while loading verfahren objects", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

