/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.utils.pointnumberreservation.VermessungsStellenSearchResult;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class KundeByVermessungsStellenNummerSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(KundeByVermessungsStellenNummerSearch.class);
    private final String vermessungsstellennummer;
    private final String QUERY = "SELECT vermessungsstellennummer, name FROM billing_kunde WHERE vermessungsstellennummer LIKE '%1$s';";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public KundeByVermessungsStellenNummerSearch(String vermessungsstellennummer) {
        this.vermessungsstellennummer = vermessungsstellennummer;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                String query = String.format("SELECT vermessungsstellennummer, name FROM billing_kunde WHERE vermessungsstellennummer LIKE '%1$s';", this.vermessungsstellennummer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + query));
                }
                ArrayList lists = ms.performCustomSearch(query, this.getConnectionContext());
                ArrayList<VermessungsStellenSearchResult> result = new ArrayList<VermessungsStellenSearchResult>();
                for (ArrayList l : lists) {
                    String vermessungsStellenNummer = (String)l.get(0);
                    String name = (String)l.get(1);
                    result.add(new VermessungsStellenSearchResult(vermessungsStellenNummer, name));
                }
                return result;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

