/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BaumArtDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(BaumArtDeletionProvider.class);
    private static final String TABLE_NAME = "baum_art";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_art";
    private static final String TABLE_NAME_SEARCH_S = "baum_schaden";
    private static final String TABLE_NAME_SEARCH_E = "baum_ersatzbaum";
    private static final String TABLE_NAME_SEARCH_F = "baum_festsetzung";
    private static final String TABLE_NAME_SEARCH_SORTE = "baum_sorte";
    private static final String CAUSE_SCHADEN = "Diese Art kann nicht gel\u00f6scht werden, da diese bei mindestens einem Schaden verwendet wird.";
    private static final String CAUSE_ERSATZ = "Diese Art kann nicht gel\u00f6scht werden, da diese bei mindestens einer Ersatzpflanzung verwendet wird.";
    private static final String CAUSE_FEST = "Diese Art kann nicht gel\u00f6scht werden, da diese bei mindestens einer Festsetzung verwendet wird.";
    private static final String CAUSE_SORTE = "Diese Art kann nicht gel\u00f6scht werden, da diese mindestens eine Sorte hat.";
    private String deleteText = "Diese Art kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean artBean = metaObject.getBean();
        Integer art_id = (Integer)artBean.getProperty(FIELD__ID);
        String queryArtInSchaden = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_S, FIELD__FK, art_id);
        String queryArtInErsatz = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_E, FIELD__FK, art_id);
        String queryArtInFest = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_F, FIELD__FK, art_id);
        String queryArtInSorte = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_SORTE, FIELD__FK, art_id);
        try {
            ArrayList artArrayS = this.getMetaService().performCustomSearch(queryArtInSchaden, this.getConnectionContext());
            if (!artArrayS.isEmpty()) {
                this.deleteText = CAUSE_SCHADEN;
                return true;
            }
            ArrayList artArrayE = this.getMetaService().performCustomSearch(queryArtInErsatz, this.getConnectionContext());
            if (!artArrayE.isEmpty()) {
                this.deleteText = CAUSE_ERSATZ;
                return true;
            }
            ArrayList artArrayF = this.getMetaService().performCustomSearch(queryArtInFest, this.getConnectionContext());
            if (!artArrayF.isEmpty()) {
                this.deleteText = CAUSE_FEST;
                return true;
            }
            ArrayList artArraySorte = this.getMetaService().performCustomSearch(queryArtInSorte, this.getConnectionContext());
            if (!artArraySorte.isEmpty()) {
                this.deleteText = CAUSE_SORTE;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Art object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

