/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BaumKroneDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(BaumKroneDeletionProvider.class);
    private static final String TABLE_NAME = "baum_krone";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_krone";
    private static final String TABLE_NAME_SEARCH_S = "baum_schaden_krone";
    private static final String DELETE_TEXT = "Dieser Kronenschaden kann nicht gel\u00f6scht werden, da dieser verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean schadenBean = metaObject.getBean();
        Integer schaden_id = (Integer)schadenBean.getProperty(FIELD__ID);
        String queryKroneInSchaden = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_S, FIELD__FK, schaden_id);
        try {
            ArrayList artArrayS = this.getMetaService().performCustomSearch(queryKroneInSchaden, this.getConnectionContext());
            if (!artArrayS.isEmpty()) {
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete krone object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(DELETE_TEXT);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

