/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.wunda_blau.search.server.BaumChildLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BaumMeldungDeletionProvider
extends AbstractCustomDeletionProvider
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BaumMeldungDeletionProvider.class);
    private static final String TABLE_NAME = "baum_meldung";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_meldung";
    private static final String TABLE_NAME_SEARCH_S = "baum_schaden";
    private static final String TABLE_NAME_SEARCH_O = "baum_ortstermin";
    private static final String DELETE_TEXT_DEFAULT = "Dieses Meldung kann nicht gel\u00f6scht werden, da diese mindestens ein Unterobjekt hat.";
    private static final String DELETE_TEXT_SCHADEN = "Diese Meldung kann nicht gel\u00f6scht werden, da diese mindestens einen Schaden hat.";
    private static final String DELETE_TEXT_ORT = "Diese Meldung kann nicht gel\u00f6scht werden, da diese mindestens einen Ortstermin hat.";
    private String deleteText;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean meldungBean = metaObject.getBean();
        Integer meldung_id = (Integer)meldungBean.getProperty(FIELD__ID);
        this.deleteText = DELETE_TEXT_DEFAULT;
        if (this.checkChildObject(FIELD__FK, meldung_id, TABLE_NAME_SEARCH_O, user)) {
            this.deleteText = DELETE_TEXT_ORT;
            return true;
        }
        if (this.checkChildObject(FIELD__FK, meldung_id, TABLE_NAME_SEARCH_S, user)) {
            this.deleteText = DELETE_TEXT_SCHADEN;
            return true;
        }
        return false;
    }

    public boolean checkChildObject(String fkField, int parentId, String searchTable, User user) {
        String[] childFields = new String[]{FIELD__ID};
        BaumChildLightweightSearch search = new BaumChildLightweightSearch();
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("WUNDA_BLAU", this.getMetaService());
        search.setActiveLocalServers(localServers);
        search.setUser(user);
        search.initWithConnectionContext(this.connectionContext);
        search.setFkField(fkField);
        search.setParentId(parentId);
        search.setTable(searchTable);
        search.setRepresentationFields(childFields);
        try {
            Collection mons = search.performServerSearch();
            if (!mons.isEmpty()) {
                return true;
            }
        }
        catch (SearchException ex) {
            LOG.error((Object)"Cannot delete Meldung object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

