/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ByteArrayFactoryHandler {
    private static final Logger LOG = Logger.getLogger(ByteArrayFactoryHandler.class);
    private static final String PROPERTY_CMD_TEMPLATE = "cmd";
    private static final String PROPERTY_JWT_PLACEHOLDER = "jwt";
    private static final String PROPERTY_FACTORYCLASS_PLACEHOLDER = "factory";
    private static final String PROPERTY_PARAMETERS_PLACEHOLDER = "parameters";
    private static final String DEFAULT_JWT_PLACEHOLDER = "<jwt>";
    private static final String DEFAULT_FACTORYCLASS_PLACEHOLDER = "<factoryClass>";
    private static final String DEFAULT_PARAMETERS_PLACEHOLDER = "<parameters>";
    private final String cmdTemplate;
    private final String jwtPlaceholder;
    private final String factoryClassPlaceholder;
    private final String parametersPlaceholder;

    private ByteArrayFactoryHandler(Properties properties) throws Exception {
        this.cmdTemplate = properties.getProperty(PROPERTY_CMD_TEMPLATE, null);
        if (this.cmdTemplate == null) {
            throw new Exception(String.format("The property %s can't be null !", PROPERTY_CMD_TEMPLATE));
        }
        this.jwtPlaceholder = properties.getProperty(PROPERTY_JWT_PLACEHOLDER, DEFAULT_JWT_PLACEHOLDER);
        this.factoryClassPlaceholder = properties.getProperty(PROPERTY_FACTORYCLASS_PLACEHOLDER, DEFAULT_FACTORYCLASS_PLACEHOLDER);
        this.parametersPlaceholder = properties.getProperty(PROPERTY_PARAMETERS_PLACEHOLDER, DEFAULT_PARAMETERS_PLACEHOLDER);
    }

    public String getExecutionTemplate() {
        return this.cmdTemplate;
    }

    public byte[] execute(String factoryClassName, String parameters, User user, ConnectionContext connectionContext) throws Exception {
        String cmd = this.cmdTemplate.replaceAll(this.jwtPlaceholder, user.getJwsToken()).replaceAll(this.factoryClassPlaceholder, factoryClassName).replaceAll(this.parametersPlaceholder, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)cmd);
        }
        String response = ByteArrayFactoryHandler.executeCmd(cmd);
        return Base64.getMimeDecoder().decode(response);
    }

    private static String executeCmd(String cmd) throws Exception {
        ProcessBuilder builder = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process process = builder.start();
        InputStream inputStream = process.getInputStream();
        return IOUtils.toString((Reader)new InputStreamReader(inputStream));
    }

    public static ByteArrayFactoryHandler getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final ByteArrayFactoryHandler INSTANCE;

        private LazyInitialiser() {
        }

        static {
            try {
                INSTANCE = new ByteArrayFactoryHandler(ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.BYTEARRAYFACTORY_PROPERTIES.getValue()));
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Exception while initializing %s", WundaBlauServerResources.BYTEARRAYFACTORY_PROPERTIES.toString()), ex);
            }
        }
    }
}

