/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.alkis.ServerAlkisConf;
import de.cismet.cids.custom.utils.alkis.VermessungPictureFinder;
import de.cismet.cids.custom.utils.alkis.VermessungRissImageReportBean;
import de.cismet.cids.custom.utils.alkis.VermessungRissReportBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.utils.MultiPagePictureReader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class VermessungsRissReportHelper
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VermessungsRissReportHelper.class);
    public static final String TYPE_VERMESSUNGSRISSE = "Vermessungsrisse";
    public static final String TYPE_COMPLEMENTARYDOCUMENTS = "Erg\u00e4nzende Dokumente";
    private static final String PARAMETER_JOBNUMBER = "JOBNUMBER";
    private static final String PARAMETER_PROJECTNAME = "PROJECTNAME";
    private static final String PARAMETER_TYPE = "TYPE";
    private static final String PARAMETER_STARTINGPAGES = "STARTINGPAGES";
    private static final String PARAMETER_IMAGEAVAILABLE = "IMAGEAVAILABLE";
    private static final String SUBREPORT_DIR = "SUBREPORT_DIR";
    private final ServerAlkisConf alkisConf = ServerAlkisConf.getInstance();
    private final User user;
    private final MetaService metaService;
    private final ConnectionContext connectionContext;
    private final VermessungPictureFinder pictureFinder;

    public VermessungsRissReportHelper(User user, MetaService metaService, ConnectionContext connectionContext) {
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
        this.pictureFinder = new VermessungPictureFinder(user, metaService, connectionContext);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Object[] generateReportData(String jobNumber, String projectName, Collection<CidsBean> selectedVermessungsrisse, String host, Class<? extends MultiPagePictureReader> multiPageReaderClass) {
        LinkedList<VermessungRissImageReportBean> imageBeans = new LinkedList<VermessungRissImageReportBean>();
        HashMap<Object, String> startingPages = new HashMap<Object, String>();
        int startingPage = 2;
        if (selectedVermessungsrisse.size() > 27) {
            startingPage = (int)((double)startingPage + Math.ceil(((double)selectedVermessungsrisse.size() - 27.0) / 37.0));
        }
        HashMap<Object, Boolean> imageAvailable = new HashMap<Object, Boolean>();
        for (CidsBean vermessungsriss : selectedVermessungsrisse) {
            String blatt;
            String flur;
            Integer gemarkung;
            String schluessel;
            try {
                schluessel = vermessungsriss.getProperty("schluessel").toString();
                gemarkung = (Integer)vermessungsriss.getProperty("gemarkung.id");
                flur = vermessungsriss.getProperty("flur").toString();
                blatt = vermessungsriss.getProperty("blatt").toString();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not include raster document for vermessungsriss '" + vermessungsriss.toJSONString(true) + "'."), (Throwable)ex);
                continue;
            }
            StringBuilder description = host.equals(this.alkisConf.getVermessungHostGrenzniederschriften()) ? new StringBuilder("Erg\u00e4nzende Dokumente zum Vermessungsriss ") : new StringBuilder("Vermessungsriss ");
            description.append(vermessungsriss.getProperty("schluessel"));
            description.append(" - ");
            description.append(vermessungsriss.getProperty("gemarkung.name"));
            description.append(" - ");
            description.append(vermessungsriss.getProperty("flur"));
            description.append(" - ");
            description.append(vermessungsriss.getProperty("blatt"));
            description.append(" - Seite ");
            String document = host.equals(this.alkisConf.getVermessungHostGrenzniederschriften()) ? this.pictureFinder.findGrenzniederschriftPicture(schluessel, gemarkung, flur, blatt) : this.pictureFinder.findVermessungsrissPicture(schluessel, gemarkung, flur, blatt);
            if (document == null) {
                LOG.info((Object)"No document URLS found for the Vermessungsriss report");
            }
            MultiPagePictureReader reader = null;
            int pageCount = 0;
            StringBuilder fileReference = new StringBuilder();
            if (document != null) {
                try {
                    URL url = ServerAlkisConf.getInstance().getDownloadUrlForDocument(document);
                    reader = multiPageReaderClass.getConstructor(URL.class, Boolean.TYPE, Boolean.TYPE).newInstance(url, false, false);
                    pageCount = reader.getNumberOfPages();
                    String path = url.getPath();
                    path = path.substring(path.lastIndexOf(47) + 1);
                    fileReference.append(" (");
                    fileReference.append(path);
                    fileReference.append(')');
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Could not read document from URL '" + document + "'. Skipping this url."), (Throwable)ex);
                }
            }
            imageAvailable.put(vermessungsriss.getProperty("id"), reader != null);
            if (reader == null) continue;
            for (int i = 0; i < pageCount; ++i) {
                imageBeans.add(new VermessungRissImageReportBean(description.toString() + (i + 1) + fileReference.toString(), host, schluessel, gemarkung, flur, blatt, i, reader));
            }
            String startingPageString = Integer.toString(startingPage);
            startingPages.put(vermessungsriss.getProperty("id"), startingPageString);
            startingPage += pageCount;
        }
        String type = host.equals(this.alkisConf.getVermessungHostGrenzniederschriften()) ? TYPE_COMPLEMENTARYDOCUMENTS : TYPE_VERMESSUNGSRISSE;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAMETER_JOBNUMBER, jobNumber);
        parameters.put(PARAMETER_PROJECTNAME, projectName);
        parameters.put(PARAMETER_TYPE, type);
        parameters.put(PARAMETER_STARTINGPAGES, startingPages);
        parameters.put(PARAMETER_IMAGEAVAILABLE, imageAvailable);
        parameters.put(SUBREPORT_DIR, DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
        LinkedList<VermessungRissReportBean> reportBeans = new LinkedList<VermessungRissReportBean>();
        reportBeans.add(new VermessungRissReportBean(selectedVermessungsrisse, imageBeans));
        return new Object[]{reportBeans, parameters, this.identifyAdditionalFiles(selectedVermessungsrisse, host)};
    }

    private Collection<URL> identifyAdditionalFiles(Collection<CidsBean> selectedVermessungsrisse, String host) {
        LinkedList<URL> additionalFilesToDownload = new LinkedList<URL>();
        for (CidsBean vermessungsriss : selectedVermessungsrisse) {
            String blatt;
            String flur;
            Integer gemarkung;
            String schluessel;
            try {
                schluessel = vermessungsriss.getProperty("schluessel").toString();
                gemarkung = (Integer)vermessungsriss.getProperty("gemarkung.id");
                flur = vermessungsriss.getProperty("flur").toString();
                blatt = vermessungsriss.getProperty("blatt").toString();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not include raster document for vermessungsriss '" + vermessungsriss.toJSONString(true) + "'."), (Throwable)ex);
                continue;
            }
            String document = host.equals(ServerAlkisConf.getInstance().getVermessungHostGrenzniederschriften()) ? this.pictureFinder.findGrenzniederschriftPicture(schluessel, gemarkung, flur, blatt) : this.pictureFinder.findVermessungsrissPicture(schluessel, gemarkung, flur, blatt);
            if (document == null) {
                LOG.info((Object)"No document URLS found for the Vermessungsriss report");
            }
            boolean isOfReducedSize = false;
            if (document == null) continue;
            try {
                URL url = ServerAlkisConf.getInstance().getDownloadUrlForDocument(document);
                if (url.toString().contains("_rs")) {
                    isOfReducedSize = true;
                }
                if (!isOfReducedSize) break;
                additionalFilesToDownload.add(new URL(url.toString().replaceAll("_rs", "")));
                break;
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not read document from URL '" + document + "'. Skipping this url."), (Throwable)ex);
            }
        }
        return additionalFilesToDownload;
    }
}

