/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.berechtigungspruefung;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BerechtigungspruefungProperties {
    private static final transient Logger LOG = Logger.getLogger(BerechtigungspruefungProperties.class);
    private final String cidsLogin;
    private final String cidsPassword;
    private final String anhangAbsPath;
    private final String csmAnfrage;
    private final String csmBearbeitung;
    private final String csmFreigabe;
    private final Integer billingStornogrundId;

    public BerechtigungspruefungProperties(Properties serviceProperties) {
        String cidsLogin = null;
        String cidsPassword = null;
        String anhangAbsPath = "/tmp";
        String csmAnfrage = "berechtigungspruefungAnfrage";
        String csmBearbeitung = "berechtigungspruefungBearbeitung";
        String csmFreigabe = "berechtigungspruefungFreigabe";
        Integer billingStornogrundId = null;
        try {
            cidsLogin = serviceProperties.getProperty("CIDS_LOGIN");
            cidsPassword = serviceProperties.getProperty("CIDS_PASSWORD");
            if (serviceProperties.getProperty("ANHANG_ABS_PATH") != null) {
                anhangAbsPath = serviceProperties.getProperty("ANHANG_ABS_PATH");
            }
            if (serviceProperties.getProperty("CSM_ANFRAGE") != null) {
                csmAnfrage = serviceProperties.getProperty("CSM_ANFRAGE");
            }
            if (serviceProperties.getProperty("CSM_BEARBEITUNG") != null) {
                csmBearbeitung = serviceProperties.getProperty("CSM_BEARBEITUNG");
            }
            if (serviceProperties.getProperty("CSM_FREIGABE") != null) {
                csmFreigabe = serviceProperties.getProperty("CSM_FREIGABE");
            }
            if (serviceProperties.getProperty("BILLING_STORNOGRUND_ID") != null) {
                billingStornogrundId = Integer.parseInt(serviceProperties.getProperty("BILLING_STORNOGRUND_ID"));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading properties", (Throwable)ex);
        }
        this.cidsLogin = cidsLogin;
        this.cidsPassword = cidsPassword;
        this.anhangAbsPath = anhangAbsPath;
        this.csmAnfrage = csmAnfrage;
        this.csmBearbeitung = csmBearbeitung;
        this.csmFreigabe = csmFreigabe;
        this.billingStornogrundId = billingStornogrundId;
    }

    public static BerechtigungspruefungProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String getCidsLogin() {
        return this.cidsLogin;
    }

    public String getCidsPassword() {
        return this.cidsPassword;
    }

    public String getAnhangAbsPath() {
        return this.anhangAbsPath;
    }

    public String getCsmAnfrage() {
        return this.csmAnfrage;
    }

    public String getCsmBearbeitung() {
        return this.csmBearbeitung;
    }

    public String getCsmFreigabe() {
        return this.csmFreigabe;
    }

    public Integer getBillingStornogrundId() {
        return this.billingStornogrundId;
    }

    private static final class LazyInitialiser {
        private static final BerechtigungspruefungProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            BerechtigungspruefungProperties instance = null;
            try {
                instance = new BerechtigungspruefungProperties(ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.BERECHTIGUNGSPRUEFUNG_PROPERTIES.getValue()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

