/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.billing;

import Sirius.server.MetaClassCache;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.billing.BillingModus;
import de.cismet.cids.custom.utils.billing.BillingPrice;
import de.cismet.cids.custom.utils.billing.BillingProduct;
import de.cismet.cids.custom.utils.billing.BillingUsage;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class BillingUtils {
    private static final Logger LOG = Logger.getLogger(BillingUtils.class);

    public CidsBean createBilling(String projektBezeichnung, String geschaeftsbuchNummer, String request, String billingBerechnung, BillingModus billingModus, BillingUsage billingUsage, BillingProduct billingProduct, BillingPrice billingPrice, User user, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        CidsBean cb = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"Billing_Billing", (ConnectionContext)connectionContext);
        cb.setProperty("username", (Object)user.toString());
        cb.setProperty("angelegt_durch", (Object)this.getExternalUser(metaService, user, connectionContext));
        cb.setProperty("ts", (Object)new Timestamp(System.currentTimeMillis()));
        cb.setProperty("angeschaeftsbuch", (Object)Boolean.FALSE);
        cb.setProperty("modus", (Object)billingModus.getKey());
        cb.setProperty("produktkey", (Object)billingProduct.getId());
        cb.setProperty("produktbezeichnung", (Object)billingProduct.getName());
        cb.setProperty("berechnung", (Object)billingBerechnung);
        cb.setProperty("netto_summe", billingPrice != null ? Double.valueOf(billingPrice.getNetto()) : null);
        cb.setProperty("mwst_satz", (Object)billingProduct.getMwst());
        cb.setProperty("brutto_summe", billingPrice != null ? Double.valueOf(billingPrice.getBrutto()) : null);
        cb.setProperty("geschaeftsbuchnummer", (Object)geschaeftsbuchNummer);
        cb.setProperty("modusbezeichnung", (Object)billingModus.getName());
        cb.setProperty("verwendungszweck", (Object)billingUsage.getName());
        cb.setProperty("verwendungskey", (Object)billingUsage.getKey());
        cb.setProperty("projektbezeichnung", (Object)projektBezeichnung);
        cb.setProperty("request", (Object)request);
        cb.setProperty("abgerechnet", (Object)Boolean.FALSE);
        return cb;
    }

    public MetaClass getMetaClass(String tableName, ConnectionContext connectionContext) {
        return MetaClassCache.getInstance().getMetaClass("WUNDA_BLAU", "billing_kunden_logins");
    }

    public MetaObject[] getMetaObjects(String query, MetaService metaService, User user, ConnectionContext connectionContext) throws Exception {
        return metaService.getMetaObject(user, query, connectionContext);
    }

    public CidsBean getExternalUser(MetaService metaService, User user, ConnectionContext connectionContext) throws Exception {
        return this.getExternalUser(user.getName(), metaService, user, connectionContext);
    }

    public CidsBean getExternalUser(String loginName, MetaService metaService, User user, ConnectionContext connectionContext) throws Exception {
        MetaClass metaClass = this.getMetaClass("billing_kunden_logins", connectionContext);
        if (metaClass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The metaclass for billing_kunden_logins is null. The current user has probably not the needed rights.");
            }
            return null;
        }
        String query = String.format("SELECT %d, %s FROM %s WHERE name = '%s'", metaClass.getID(), metaClass.getPrimaryKey(), metaClass.getTableName(), loginName);
        CidsBean externalUser = null;
        try {
            MetaObject[] metaObjects = this.getMetaObjects(query, metaService, user, connectionContext);
            if (metaObjects != null && metaObjects.length > 0) {
                externalUser = metaObjects[0].getBean();
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Error while retrieving the CidsBean of an external user.", (Throwable)ex);
        }
        return externalUser;
    }

    public static BillingUtils getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final BillingUtils INSTANCE = new BillingUtils();

        private LazyInitialiser() {
        }
    }
}

