/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.motd;

import de.cismet.cids.custom.utils.motd.MotdRetrieverListener;
import de.cismet.cids.custom.utils.motd.MotdRetrieverListenerEvent;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MotdRetriever {
    private static final transient Logger LOG = Logger.getLogger(MotdRetriever.class);
    private final SimpleHttpAccessHandler httpHandler = new SimpleHttpAccessHandler();
    private final Collection<MotdRetrieverListener> listeners = new ArrayList<MotdRetrieverListener>();
    private final MotdRetrieverListenerHandler listenerHandler = new MotdRetrieverListenerHandler();
    private final Timer timer = new Timer();
    private String domain;
    private String motd = null;
    private String motd_extern = null;
    private String totd = null;
    private String totd_extern = null;
    private boolean running;
    private String motd_url;
    private String motd_extern_url;
    private Integer retrieveRate;
    private String noMessage;
    private final Properties properties;
    private final Map<String, Boolean> retrieveSuccessfulMap = new HashMap<String, Boolean>();

    public MotdRetriever(Properties properties) {
        this.properties = properties;
    }

    public boolean init(String domain) throws Exception {
        if (domain == null) {
            throw new IllegalArgumentException("Domain darf nicht null sein !");
        }
        if (this.domain != null) {
            throw new IllegalStateException("MotdRetriever wurde bereits initialisiert !");
        }
        try {
            this.motd_url = this.properties.getProperty("MOTD_URL");
            this.motd_extern_url = this.properties.getProperty("MOTD_EXTERN_URL");
            this.retrieveRate = Integer.parseInt(this.properties.getProperty("RETRIEVE_RATE_IN_MS"));
            this.noMessage = this.properties.getProperty("NO_MESSAGE");
            this.domain = domain;
            return true;
        }
        catch (Exception ex) {
            throw new Exception("Fehler beim Initialisieren des MotdRetrievers. Es werden keine aktuellen Meldungen verteilt !", ex);
        }
    }

    private SimpleHttpAccessHandler getHttpAccessHandler() {
        return this.httpHandler;
    }

    public String getTotd(boolean extern) {
        return this.totd;
    }

    private void setTotd(String newTotd, boolean extern) {
        boolean changed;
        String old;
        String string = old = extern ? this.totd_extern : this.totd;
        if (newTotd != null) {
            changed = !newTotd.equals(old);
        } else {
            boolean bl = changed = old != null;
        }
        if (changed) {
            if (extern) {
                this.totd_extern = newTotd;
            } else {
                this.totd = newTotd;
            }
            this.listenerHandler.totdChanged(new MotdRetrieverListenerEvent(2, newTotd, extern, this));
        }
    }

    public String getMotd(boolean extern) {
        return extern ? this.motd_extern : this.motd;
    }

    private void setMotd(String newMotd, boolean extern) {
        boolean changed;
        String old;
        String string = old = extern ? this.motd_extern : this.motd;
        if (newMotd != null) {
            changed = !newMotd.equals(old);
        } else {
            boolean bl = changed = old != null;
        }
        if (changed) {
            if (extern) {
                this.motd_extern = newMotd;
            } else {
                this.motd = newMotd;
            }
            this.listenerHandler.motdChanged(new MotdRetrieverListenerEvent(1, newMotd, extern, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.domain == null) {
            throw new IllegalStateException("MotdRetriever wurde nicht initialisiert !");
        }
        Timer timer = this.timer;
        synchronized (timer) {
            if (!this.running) {
                this.startTimer(this.retrieveRate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.running) {
                this.timer.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer(int scheduleMs) {
        this.running = true;
        Timer timer = this.timer;
        synchronized (timer) {
            this.timer.schedule((TimerTask)new RetrieveTimerTask(scheduleMs), scheduleMs);
        }
    }

    public boolean addMotdRetrieverListener(MotdRetrieverListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeMotdRetrieverListener(MotdRetrieverListener listener) {
        return this.listeners.remove(listener);
    }

    private String extractTitle(String motd) {
        if (motd == null) {
            return null;
        }
        Elements elements = Jsoup.parse((String)motd).select("span.totd");
        if (elements != null && !elements.isEmpty() && elements.get(0) != null) {
            return ((Element)elements.get(0)).text();
        }
        return null;
    }

    class MotdRetrieverListenerHandler
    implements MotdRetrieverListener {
        MotdRetrieverListenerHandler() {
        }

        @Override
        public void motdChanged(MotdRetrieverListenerEvent event) {
            for (MotdRetrieverListener listener : MotdRetriever.this.listeners) {
                listener.motdChanged(event);
            }
        }

        @Override
        public void totdChanged(MotdRetrieverListenerEvent event) {
            for (MotdRetrieverListener listener : MotdRetriever.this.listeners) {
                listener.totdChanged(event);
            }
        }
    }

    class RetrieveTimerTask
    extends TimerTask {
        private final int intervall;

        public RetrieveTimerTask(int intervall) {
            this.intervall = intervall;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String retrieveMotd(String motd_url) {
            InputStream inputStream = null;
            try {
                inputStream = MotdRetriever.this.getHttpAccessHandler().doRequest(new URL(motd_url), (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.GET_REQUEST);
                String motd = IOUtils.toString((InputStream)inputStream, (String)"ISO-8859-1");
                MotdRetriever.this.retrieveSuccessfulMap.put(motd_url, true);
                String string = motd;
                return string;
            }
            catch (Exception ex) {
                if (!MotdRetriever.this.retrieveSuccessfulMap.containsKey(motd_url) || Boolean.TRUE.equals(MotdRetriever.this.retrieveSuccessfulMap.get(motd_url))) {
                    LOG.warn((Object)("couldnt get the MOTD from " + motd_url), (Throwable)ex);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("couldnt get the MOTD from " + motd_url), (Throwable)ex);
                }
                MotdRetriever.this.retrieveSuccessfulMap.put(motd_url, false);
            }
            finally {
                block16: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            if (!LOG.isDebugEnabled()) break block16;
                            LOG.debug((Object)"couldnt close the inputstream", (Throwable)ex);
                        }
                    }
                }
            }
            return null;
        }

        private void processMotd(boolean extern) {
            String newMotd = this.retrieveMotd(extern ? MotdRetriever.this.motd_extern_url : MotdRetriever.this.motd_url);
            if (newMotd != null) {
                if (newMotd.equals(MotdRetriever.this.noMessage)) {
                    MotdRetriever.this.setMotd(null, extern);
                    MotdRetriever.this.setTotd(null, extern);
                } else {
                    MotdRetriever.this.setMotd(newMotd, extern);
                    MotdRetriever.this.setTotd(MotdRetriever.this.extractTitle(newMotd), extern);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.processMotd(false);
                this.processMotd(true);
            }
            catch (Exception ex) {
                LOG.warn((Object)"couldnt retrieve motd", (Throwable)ex);
            }
            finally {
                Timer timer = MotdRetriever.this.timer;
                synchronized (timer) {
                    MotdRetriever.this.startTimer(this.intervall);
                }
            }
        }
    }
}

