/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.nas;

import de.cismet.cids.custom.utils.nas.CidsActionClient;
import de.cismet.cidsx.server.api.types.ActionTask;
import de.cismet.commons.concurrency.CismetExecutors;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;

public class DXFConverterAction
extends CidsActionClient {
    private static final String ACTION_KEY = "dxf";
    private static final ExecutorService executor = CismetExecutors.newCachedLimitedThreadPool((int)30, (String)"dxfConvertPollingThread");
    private static final int POLLING_INTERVAL = 5000;

    public DXFConverterAction(String domain, String serviceUrl) {
        super(domain, serviceUrl);
    }

    public ActionTask createDxfActionTask(Map<String, Object> params, File nasFile, boolean isZipped) {
        ActionTask task = new ActionTask();
        TreeMap<String, Object> p = new TreeMap<String, Object>();
        if (isZipped) {
            p.put("$1", "zip");
        } else {
            p.put("$1", "not_zip");
        }
        p.putAll(params);
        task.setParameters(p);
        MediaType type = isZipped ? new MediaType("application", "zip") : MediaType.APPLICATION_XML_TYPE;
        return super.createTask(ACTION_KEY, task, nasFile, type, true);
    }

    public Future<File> getResult(String taskKey) {
        return executor.submit(new DXFConverterPollingCallable(taskKey));
    }

    private final class DXFConverterPollingCallable
    implements Callable<File> {
        private final String taskKey;

        public DXFConverterPollingCallable(String taskKey) {
            this.taskKey = taskKey;
        }

        @Override
        public File call() throws Exception {
            ActionTask.Status status = DXFConverterAction.this.getTaskStatus(DXFConverterAction.ACTION_KEY, this.taskKey);
            while (status != ActionTask.Status.FINISHED) {
                try {
                    Thread.sleep(5000L);
                    status = DXFConverterAction.this.getTaskStatus(DXFConverterAction.ACTION_KEY, this.taskKey);
                }
                catch (InterruptedException interruptedException) {}
            }
            File tmpFile = DXFConverterAction.this.getTaskResult(File.class, DXFConverterAction.ACTION_KEY, this.taskKey, "dxfOutput");
            return tmpFile;
        }
    }
}

