/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.pointnumberreservation;

import de.aed_sicad.www.namespaces.svr.AuftragsManagerLocator;
import de.aed_sicad.www.namespaces.svr.AuftragsManagerSoap;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationBeanParser;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class PointNumberReservationService {
    private static final transient Logger LOG = Logger.getLogger(PointNumberReservationService.class);
    private static final String AUFTRAGS_NUMMER = "ANR";
    private static final String NUMMERIERUNGS_BEZIRK = "NBZ";
    private static final String ABLAUF_RESERVIERUNG = "ADR";
    private static final String STARTWERT = "START_VALUE";
    private static final String ANZAHL = "POINT_AMOUNT";
    private static final String LEBENSZEIT_BEGINN = "LBZ";
    private static final String PUNKT_NUMMER = "PNR";
    private static final String PUNKT_UUID = "PUUID";
    private static final String PUNKT_UUIDLBZ = "PUUIDLBZ";
    private static final String FIRST_NUMBER = "FIRST_NUMBER";
    private static final String LAST_NUMBER = "LAST_NUMBER";
    private static final String VERMESSUNG_STELLE = "VERMESSUNG_STELLE";
    private static final String PROFIL_KENNUNG = "WUNDA_RES";
    private static PointNumberReservationService instance;
    private String SERVICE_URL;
    private String USER;
    private String PW;
    private AuftragsManagerSoap manager;
    private boolean initError = false;
    private String TEMPLATE_BEN_AUFTR_ALL;
    private String TEMPLATE_BEN_AUFTR_ONE_ANR;
    private String TEMPLATE_BEN_AUFTR_WILDCARD;
    private String TEMPLATE_FREIGABE;
    private String TEMPLATE_PROLONG;
    private String TEMPLATE_PROLONG_SUB;
    private String TEMPLATE_RESERVIERUNG;
    private String TEMPLATE_RESERVIERUNG_SW;

    private PointNumberReservationService() {
        try {
            Properties serviceProperties = ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.PNR_PROPERTIES.getValue());
            this.TEMPLATE_BEN_AUFTR_ALL = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_BEN_AUFTR_ALL.getValue());
            this.TEMPLATE_BEN_AUFTR_ONE_ANR = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_BEN_AUFTR_ONE_ANR.getValue());
            this.TEMPLATE_BEN_AUFTR_WILDCARD = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_BEN_AUFTR_WILDCARD.getValue());
            this.TEMPLATE_FREIGABE = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_FREIGABE.getValue());
            this.TEMPLATE_PROLONG = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_PROLONG.getValue());
            this.TEMPLATE_PROLONG_SUB = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_PROLONG_SUB.getValue());
            this.TEMPLATE_RESERVIERUNG = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_RESERVIERUNG.getValue());
            this.TEMPLATE_RESERVIERUNG_SW = ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.PNR_TEMPLATE_RESERVIERUNG_SW.getValue());
            if (!this.checkTemplateFilesAccessible()) {
                LOG.warn((Object)"Punktnummernreservierung initialisation Error!");
                this.initError = true;
            }
            if (!(serviceProperties.containsKey("service") && serviceProperties.containsKey("user") && serviceProperties.containsKey("password"))) {
                LOG.warn((Object)"Could not read all necessary properties from pointNumberRes_conf.properties. Disabling PointNumberReservationService!");
                this.initError = true;
            }
            this.SERVICE_URL = serviceProperties.getProperty("service", "");
            this.USER = serviceProperties.getProperty("user", "");
            this.PW = serviceProperties.getProperty("password", "");
        }
        catch (Exception ex) {
            LOG.warn((Object)"Punktnummernreservierung initialisation Error!", (Throwable)ex);
            this.initError = true;
        }
    }

    public static PointNumberReservationService instance() {
        if (instance == null) {
            instance = new PointNumberReservationService();
        }
        return instance;
    }

    private void initAmManager() {
        if (this.initError) {
            return;
        }
        try {
            AuftragsManagerLocator am = new AuftragsManagerLocator();
            this.manager = am.getAuftragsManagerSoap(new URL(this.SERVICE_URL));
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating 3AServer interface", (Throwable)ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] gZipFile(InputStream is) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream zipOut = null;
        try {
            zipOut = new GZIPOutputStream(bos);
            byte[] buffer = new byte[8192];
            int length = is.read(buffer, 0, 8192);
            while (true) {
                if (length == -1) {
                    is.close();
                    ((OutputStream)zipOut).close();
                    return bos.toByteArray();
                }
                ((OutputStream)zipOut).write(buffer, 0, length);
                length = is.read(buffer, 0, 8192);
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)"error during gzip of file", (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            LOG.error((Object)"error during gzip of file", (Throwable)ex);
            return null;
        }
    }

    private String readFile(InputStream file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(file));
            String line = null;
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)("could not find request file: " + file), (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)("error during reading request file: " + file), (Throwable)ex);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gunzip(byte[] data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPInputStream is = null;
        try {
            is = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] buffer = new byte[8192];
            int length = ((InputStream)is).read(buffer, 0, 8192);
            while (length != -1) {
                bos.write(buffer, 0, length);
                length = ((InputStream)is).read(buffer, 0, 8192);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            LOG.error((Object)"error during gunzip of nas response files", (Throwable)ex);
        }
        finally {
            try {
                bos.close();
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private String sendRequestAndAwaitResult(InputStream preparedQuery) {
        this.initAmManager();
        if (this.manager == null) {
            LOG.error((Object)"3AServer manager interface is  null");
            return null;
        }
        try {
            int sessionID = this.manager.login(this.USER, this.PW);
            String orderId = this.manager.registerGZip(sessionID, this.gZipFile(preparedQuery));
            while (this.manager.getResultCount(sessionID, orderId) < 1 && this.manager.getProtocolGZip(sessionID, orderId) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Sleep interrupted");
                }
            }
            int resCount = this.manager.getResultCount(sessionID, orderId);
            if (resCount == 0) {
                LOG.error((Object)("Protocol for PointNumberReservation order " + orderId + ": " + new String(this.gunzip(this.manager.getProtocolGZip(sessionID, orderId)))));
                return null;
            }
            byte[] data = this.manager.getResultGZip(sessionID, orderId);
            return new String(this.gunzip(data), "UTF-8");
        }
        catch (Exception e) {
            LOG.error((Object)"Error during registering order at aaa service", (Throwable)e);
            return null;
        }
    }

    private String getAblaufDatum() {
        GregorianCalendar currDate = new GregorianCalendar();
        currDate.add(2, 18);
        SimpleDateFormat fd = new SimpleDateFormat("yyyy-MM-dd");
        return fd.format(currDate.getTime());
    }

    public Collection<PointNumberReservationRequest> getAllBenAuftr(String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        String request = this.TEMPLATE_BEN_AUFTR_ALL.replaceAll(PROFIL_KENNUNG, profilKennung);
        ByteArrayInputStream preparedQuery = new ByteArrayInputStream(request.getBytes());
        String result = this.sendRequestAndAwaitResult(preparedQuery);
        if (result == null) {
            return null;
        }
        return PointNumberReservationBeanParser.parseBestandsdatenauszug(result);
    }

    public PointNumberReservationRequest getBenAuftr(String anr, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        if (this.TEMPLATE_BEN_AUFTR_ONE_ANR == null) {
            return null;
        }
        String request = this.TEMPLATE_BEN_AUFTR_ONE_ANR.replaceAll(AUFTRAGS_NUMMER, anr).replaceAll(PROFIL_KENNUNG, profilKennung);
        ByteArrayInputStream preparedQuery = new ByteArrayInputStream(request.getBytes());
        String result = this.sendRequestAndAwaitResult(preparedQuery);
        if (result == null) {
            return null;
        }
        Collection<PointNumberReservationRequest> requests = PointNumberReservationBeanParser.parseBestandsdatenauszug(result);
        if (requests.isEmpty()) {
            return null;
        }
        if (requests.size() > 1) {
            LOG.warn((Object)"There should be exact one Auftragsnummer but the result contains multiple one. Returning only the first one");
        }
        return requests.toArray(new PointNumberReservationRequest[1])[0];
    }

    public Collection<PointNumberReservationRequest> getAllBenAuftrWithWildCard(String anr, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        if (this.TEMPLATE_BEN_AUFTR_WILDCARD == null) {
            return null;
        }
        String request = this.TEMPLATE_BEN_AUFTR_WILDCARD.replaceAll(AUFTRAGS_NUMMER, anr).replaceAll(PROFIL_KENNUNG, profilKennung);
        ByteArrayInputStream preparedQuery = new ByteArrayInputStream(request.getBytes());
        String result = this.sendRequestAndAwaitResult(preparedQuery);
        if (result == null) {
            return null;
        }
        Collection<PointNumberReservationRequest> requests = PointNumberReservationBeanParser.parseBestandsdatenauszug(result);
        if (requests.isEmpty()) {
            LOG.info((Object)("Could not find a result for Auftragsnummer " + anr));
        }
        for (PointNumberReservationRequest r : requests) {
            List<PointNumberReservation> pointNUmbers = r.getPointNumbers();
            StringBuffer b = new StringBuffer();
            for (PointNumberReservation pnr : pointNUmbers) {
                b.append(pnr.getPunktnummer());
                b.append(",");
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Found request: " + r.getAntragsnummer() + " with pointNUmbers: " + b.toString()));
        }
        return requests;
    }

    public boolean isAntragsNummerExisting(String anr, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return false;
        }
        PointNumberReservationRequest auftrag = this.getBenAuftr(anr, profilKennung);
        if (auftrag == null || auftrag.getAntragsnummer() == null) {
            return false;
        }
        return auftrag.getAntragsnummer().equals(anr);
    }

    public Collection<PointNumberReservation> getReserviertePunkte(String requestId, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        PointNumberReservationRequest request = this.getBenAuftr(requestId, profilKennung);
        if (request != null) {
            return request.getPointNumbers();
        }
        return null;
    }

    public PointNumberReservationRequest doReleaseReservation(String prefix, String anr, String nummerierungsbezirk, int firstPointNumber, int lastPointNumber, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        if (this.TEMPLATE_FREIGABE == null) {
            return null;
        }
        DecimalFormat dcf = new DecimalFormat("000000");
        String request = this.TEMPLATE_FREIGABE.replaceAll(AUFTRAGS_NUMMER, anr).replaceAll(NUMMERIERUNGS_BEZIRK, nummerierungsbezirk).replaceAll(VERMESSUNG_STELLE, prefix).replaceAll(PROFIL_KENNUNG, profilKennung).replaceAll(FIRST_NUMBER, dcf.format(firstPointNumber)).replaceAll(LAST_NUMBER, dcf.format(lastPointNumber));
        ByteArrayInputStream preparedQuery = new ByteArrayInputStream(request.getBytes());
        String result = this.sendRequestAndAwaitResult(preparedQuery);
        if (result == null) {
            return null;
        }
        return PointNumberReservationBeanParser.parseReservierungsErgebnis(result);
    }

    public PointNumberReservationRequest doProlongReservation(String prefix, String anr, Collection<Long> points, Date date, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        if (this.TEMPLATE_PROLONG == null || this.TEMPLATE_PROLONG_SUB == null) {
            return null;
        }
        PointNumberReservationRequest result = this.getBenAuftr(anr, profilKennung);
        if (result != null) {
            ArrayList<PointNumberReservation> pnrList = new ArrayList<PointNumberReservation>();
            for (PointNumberReservation pointNumberReserveration : result.getPointNumbers()) {
                if (!points.contains(Long.parseLong(pointNumberReserveration.getPunktnummer()))) continue;
                pnrList.add(pointNumberReserveration);
            }
            String requestSub = this.TEMPLATE_PROLONG_SUB;
            StringBuffer subs = new StringBuffer();
            for (PointNumberReservation pointNumberReserveration : pnrList) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String requestSubTmp = requestSub.replaceAll(PUNKT_UUIDLBZ, pointNumberReserveration.getFeatureId()).replaceAll(PUNKT_UUID, pointNumberReserveration.getUuid()).replaceAll(LEBENSZEIT_BEGINN, pointNumberReserveration.getIntervallbeginn()).replaceAll(PUNKT_NUMMER, pointNumberReserveration.getPunktnummer()).replaceAll(ABLAUF_RESERVIERUNG, sdf.format(date)).replaceAll(VERMESSUNG_STELLE, pointNumberReserveration.getVermessungsstelle()).replaceAll(AUFTRAGS_NUMMER, anr);
                subs.append(requestSubTmp);
            }
            String request = this.TEMPLATE_PROLONG.replaceAll(AUFTRAGS_NUMMER, anr).replaceAll(PROFIL_KENNUNG, profilKennung).replaceAll("SUBTEMPLATE", subs.toString());
            ByteArrayInputStream preparedQuery = new ByteArrayInputStream(request.getBytes());
            String verlaengernResult = this.sendRequestAndAwaitResult(preparedQuery);
            if (verlaengernResult == null) {
                return null;
            }
            return PointNumberReservationBeanParser.parseReservierungsErgebnis(verlaengernResult);
        }
        LOG.warn((Object)"no pointnumbers found to prolong");
        return null;
    }

    public PointNumberReservationRequest doReservation(String prefix, String requestId, String nummerierungsbezirk, int anzahl, int startValue, String profilKennung) {
        if (this.initError) {
            LOG.info((Object)"PointNumberReservationService initialisation error");
            return null;
        }
        if (this.TEMPLATE_RESERVIERUNG == null) {
            return null;
        }
        String request = (startValue == 0 ? this.TEMPLATE_RESERVIERUNG : this.TEMPLATE_RESERVIERUNG_SW).replaceAll(AUFTRAGS_NUMMER, requestId).replaceAll(NUMMERIERUNGS_BEZIRK, nummerierungsbezirk).replaceAll(ANZAHL, Integer.toString(anzahl)).replaceAll(STARTWERT, Integer.toString(startValue)).replaceAll(ABLAUF_RESERVIERUNG, this.getAblaufDatum()).replaceAll(VERMESSUNG_STELLE, prefix).replaceAll(PROFIL_KENNUNG, profilKennung);
        ByteArrayInputStream preparedQuery = new ByteArrayInputStream(request.getBytes());
        String result = this.sendRequestAndAwaitResult(preparedQuery);
        if (result == null) {
            return null;
        }
        PointNumberReservationRequest tmpResult = PointNumberReservationBeanParser.parseReservierungsErgebnis(result);
        if (tmpResult.isSuccessfull()) {
            this.fillWithAblaufDatum(requestId, tmpResult, profilKennung);
        }
        return tmpResult;
    }

    private void fillWithAblaufDatum(String requestId, PointNumberReservationRequest resultWithoutDate, String profilKennung) {
        List<PointNumberReservation> tmp = this.getBenAuftr(requestId, profilKennung).getPointNumbers();
        List<PointNumberReservation> pnrWithoutDate = resultWithoutDate.getPointNumbers();
        tmp.retainAll(resultWithoutDate.getPointNumbers());
        Collections.sort(tmp);
        Collections.sort(pnrWithoutDate);
        for (PointNumberReservation pnr : pnrWithoutDate) {
            PointNumberReservation completePnr;
            if (!pnr.equals(completePnr = tmp.get(pnrWithoutDate.indexOf(pnr)))) continue;
            pnr.setAblaufDatum(completePnr.getAblaufDatum());
        }
    }

    private boolean checkTemplateFilesAccessible() {
        boolean benAuftrAllTempl = this.TEMPLATE_BEN_AUFTR_ALL != null;
        boolean benAuftrOneTempl = this.TEMPLATE_BEN_AUFTR_ONE_ANR != null;
        boolean benAuftrWildTempl = this.TEMPLATE_BEN_AUFTR_WILDCARD != null;
        boolean releaseTempl = this.TEMPLATE_FREIGABE != null;
        boolean prolongTempl = this.TEMPLATE_PROLONG != null;
        boolean prolongSubTempl = this.TEMPLATE_PROLONG_SUB != null;
        boolean reservationTempl = this.TEMPLATE_RESERVIERUNG != null;
        boolean reservationSWTempl = this.TEMPLATE_RESERVIERUNG_SW != null;
        return benAuftrAllTempl && benAuftrOneTempl && benAuftrWildTempl && releaseTempl && prolongTempl && prolongSubTempl && reservationSWTempl && reservationTempl;
    }
}

