/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.interfaces.domainserver.UserStore;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenProperties;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenTaskRetryable;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskRetryException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class VermessungsunterlagenTask
implements Callable<VermessungsunterlagenTask>,
ConnectionContextStore,
MetaServiceStore,
UserStore {
    protected static final transient Logger LOG = Logger.getLogger(VermessungsunterlagenTask.class);
    protected static final long DEFAULT_FIRST_WAIT_TIME_MS = 1000L;
    protected static final long DEFAULT_MAX_TOTAL_WAIT_TIME_MS = 1023000L;
    protected static final double DEFAULT_WAIT_TIME_MULTIPLICATOR = 2.0;
    private transient VermessungsunterlagenProperties properties;
    private transient User user;
    private transient MetaService metaService;
    private transient ConnectionContext connectionContext;
    private final String type;
    private final String jobKey;
    private Status status = Status.NONE;
    private final Collection<String> files = new ArrayList<String>();
    private VermessungsunterlagenTaskException exception;

    protected VermessungsunterlagenTask(String type, String jobkey) {
        this.type = type;
        this.jobKey = jobkey;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    protected void addFile(String file) {
        this.files.add(file);
    }

    protected void setStatus(Status status) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task status changed (" + this.getJobKey() + "/" + this.getType() + "): " + status.toString()));
        }
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VermessungsunterlagenTask call() throws VermessungsunterlagenTaskException {
        this.setStatus(Status.RUNNING);
        try {
            new File(this.getPath()).mkdirs();
            if (this instanceof VermessungsunterlagenTaskRetryable) {
                VermessungsunterlagenTaskRetryable retryable = (VermessungsunterlagenTaskRetryable)((Object)this);
                boolean success = false;
                long totalWaitTime = 0L;
                long waitTime = retryable.getFirstWaitTimeMs();
                ArrayList<VermessungsunterlagenException> exceptions = new ArrayList<VermessungsunterlagenException>();
                while (!success && totalWaitTime < retryable.getMaxTotalWaitTimeMs()) {
                    try {
                        this.performTask();
                        success = true;
                    }
                    catch (VermessungsunterlagenException ex) {
                        LOG.warn((Object)("performTask failed. will wait " + waitTime + "ms and try again"), (Throwable)ex);
                        exceptions.add(ex);
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException ex1) {
                            throw new VermessungsunterlagenTaskException(this.getType(), ex1.getMessage(), ex1);
                        }
                    }
                    finally {
                        totalWaitTime += waitTime;
                        waitTime = (long)((double)waitTime * retryable.getWaitTimeMultiplicator());
                    }
                }
                if (!success && !exceptions.isEmpty()) {
                    throw new VermessungsunterlagenTaskRetryException(this.getType(), "Abbruch nach " + exceptions.size() + " Versuchen.", exceptions);
                }
            } else {
                this.performTask();
            }
            this.setStatus(Status.FINISHED);
        }
        catch (VermessungsunterlagenTaskException ex) {
            LOG.info((Object)"setting status to ERROR because of an exception", (Throwable)ex);
            this.exception = ex;
            this.setStatus(Status.ERROR);
            VermessungsunterlagenUtils.writeExceptionJson(ex, this.getPath() + "/fehlerprotokoll_" + this.getType() + ".json");
        }
        return this;
    }

    protected abstract void performTask() throws VermessungsunterlagenTaskException;

    protected abstract String getSubPath();

    public String getPath() {
        return this.getProperties().getPath(this.getJobKey().replace("/", "--")) + this.getSubPath();
    }

    public VermessungsunterlagenProperties getProperties() {
        return this.properties;
    }

    public void setProperties(VermessungsunterlagenProperties properties) {
        this.properties = properties;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getType() {
        return this.type;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public Status getStatus() {
        return this.status;
    }

    public Collection<String> getFiles() {
        return this.files;
    }

    public VermessungsunterlagenTaskException getException() {
        return this.exception;
    }

    public static enum Status {
        NONE,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

